/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer;

import java.applet.Applet;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Vector;
import quadbase.common.awt.Arc;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.SwingUtil;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ZoomGraphics;
import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportViewer.CCanvas;
import quadbase.reportdesigner.ReportViewer.CPanel;
import quadbase.reportdesigner.ReportViewer.CRuler;
import quadbase.reportdesigner.ReportViewer.CScrollPane;
import quadbase.reportdesigner.ReportViewer.CServerPortDialog;
import quadbase.reportdesigner.ReportViewer.DrillDownValueSelectionDialog;
import quadbase.reportdesigner.ReportViewer.MouseThread;
import quadbase.reportdesigner.ReportViewer.PopupMenuForReport;
import quadbase.reportdesigner.ReportViewer.ReportToolBar;
import quadbase.reportdesigner.ReportViewer.Viewer;
import quadbase.reportdesigner.ReportViewer.swing.OpenSaveDialog;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.PaginatedReport;
import quadbase.reportdesigner.report.PrintReport;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.IReportMain;

public class ReportCanvas
extends CCanvas
implements Runnable,
MouseListener,
MouseMotionListener,
KeyListener {
    String exportServlet = null;
    boolean exportTarget = true;
    boolean isDynamicExport = false;
    String serverName = "localhost";
    int serverPort = 8080;
    String servletDir = "servlet/";
    boolean hasDefaultDynamicExportParam = false;
    BrowseDirectories browseDir;
    private Report report;
    Image offScreenImage;
    Image offScreenImage2;
    Graphics backBuffer;
    Graphics backBuffer2;
    int scrollBarOption = 1;
    boolean loading = false;
    boolean isRefreshEnabled = true;
    boolean isExportEnabled = true;
    int prefWidth = 500;
    int prefHeight = 500;
    CScrollPane scrollPane;
    private boolean showScrollPane;
    private boolean isKeyReady = false;
    private ReportUI reportUI;
    int page = 1;
    int section = 1;
    boolean isPopupMenuOp;
    boolean isPopupTrigger;
    int lastx;
    int lasty;
    Cursor currentCursor;
    Vector imageMap;
    Color dataBgColor = new Color(253, 250, 217);
    Color dataFontColor = Color.black;
    Font dataFont = new Font("TimesRoman", 0, 10);
    int hintX = 0;
    int hintY = 0;
    MouseThread mouseThread = null;
    boolean isDataPointSelected;
    boolean showDataHint = true;
    public Vector linkHistory = new Vector();
    private int backLinkMask = IOUtil.getRightMouseClickMask();
    private int forwLinkMask = 0;
    private int forwLinkClickCount = 1;
    private int backLinkClickCount = 2;
    private IReportMain reportMain;
    private MouseListener mouseListener = null;
    private MouseMotionListener mouseMotionListener = null;
    private double zoomFactor = 1.0;
    private boolean designer = false;
    private CRuler xRuler;
    private CRuler yRuler;
    private Color canvasBackgroundColor = Color.white;
    public static final int PAGELAYOUT_OFFSET = 50;
    public boolean menuVisible = true;
    public boolean sectionMenuVisible = true;
    public boolean pageMenuVisible = true;
    public boolean outputMenuVisible = true;
    public boolean backMenuItemVisible = true;
    public boolean refreshMenuItemVisible = true;
    public boolean goToMenuItemVisible = true;
    public boolean sortMenuVisible = true;
    public boolean zoomMenuItemVisible = true;
    public boolean multiDrillDownVisible = true;
    public boolean toolbarMenuVisible = true;
    public Vector invisibleSectionMenuItem;
    public Vector invisiblePageMenuItem;
    public Vector invisibleOutputMenuItem;
    private ReportToolBar reportToolBar;
    private Container toolbarContainer;

    public ReportCanvas(Report report) {
        this(report, 0);
    }

    public ReportCanvas(Report report, int scrollBarOption) {
        try {
            this.browseDir = new QbBrowseDirectories();
            this.setReport(report);
            this.setBackground(Color.white);
            if (report != null) {
                this.canvasBackgroundColor = report.getBackgroundColor();
            }
            ServerMessage.setComponent(this);
            this.scrollBarOption = scrollBarOption;
            if (scrollBarOption == 2) {
                this.showScrollPane = false;
            } else {
                this.showScrollPane = true;
                this.scrollPane = new CScrollPane(this, scrollBarOption);
                Adjustable vAdjust = this.scrollPane.getVAdjustable();
                Adjustable hAdjust = this.scrollPane.getHAdjustable();
                vAdjust.setUnitIncrement(5 * vAdjust.getUnitIncrement());
                hAdjust.setUnitIncrement(5 * hAdjust.getUnitIncrement());
                this.setSize(QbUtil.toPixel(report.getPageWidth()) + 100, QbUtil.toPixel(report.getPageHeight()) + 100);
            }
            this.reportToolBar = new ReportToolBar(this);
            CPanel mainPanel = new CPanel();
            if (this.showScrollPane) {
                mainPanel.add("Center", this.scrollPane);
            } else {
                mainPanel.add("Center", this);
            }
            this.toolbarContainer = mainPanel;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.mouseThread = new MouseThread(this);
            this.addMouseMotionListener(this.mouseThread);
            this.mouseThread.setPriority(1);
            this.mouseThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ReportToolBar getReportToolBar() {
        return this.reportToolBar;
    }

    public void setReportToolBarVisible(boolean b) {
        if (this.toolbarContainer == null) {
            return;
        }
        if (!b) {
            this.toolbarContainer.remove(this.reportToolBar);
            this.toolbarContainer.validate();
        } else {
            this.toolbarContainer.add("South", this.reportToolBar);
            this.toolbarContainer.validate();
        }
    }

    public boolean isReportToolBarVisible() {
        if (this.toolbarContainer == null) {
            return false;
        }
        for (int i = 0; i < this.toolbarContainer.getComponentCount(); ++i) {
            if (this.toolbarContainer.getComponent(i) != this.reportToolBar) continue;
            return true;
        }
        return false;
    }

    protected Container getToolbarContainer() {
        return this.toolbarContainer;
    }

    public void setExportEnabled(boolean b) {
        this.isExportEnabled = b;
    }

    public boolean isExportEnabled() {
        return this.isExportEnabled;
    }

    public void setRefreshEnabled(boolean b) {
        this.isRefreshEnabled = b;
    }

    public boolean isRefreshEnabled() {
        return this.isRefreshEnabled;
    }

    public boolean isExportToMultiPages() {
        return this.report.isExportToMultiPages();
    }

    public void setExportToMultiPages(boolean state) {
        this.report.setExportToMultiPages(state);
    }

    public void setExportToSingleWPagination(boolean state) {
        this.report.setExportToSingleWPagination(state);
    }

    private void removeCanvasListener() {
        if (this.mouseThread != null) {
            try {
                this.removeMouseMotionListener(this.mouseThread);
                this.mouseThread.pleaseStop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mouseThread = null;
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this.isKeyReady) {
            this.removeKeyListener(this);
        }
    }

    protected void finalize() throws Throwable {
        this.removeCanvasListener();
    }

    public Report getReport() {
        return this.report;
    }

    public QbReport getQbReport() {
        if (this.report == null) {
            return null;
        }
        return QbReport.createQbReport(this.report);
    }

    public Component getReportComponent() {
        return this.toolbarContainer;
    }

    public void setReport(Report report) throws Exception {
        this.setReport(report, null);
    }

    public void setReport(Report report, Report parentReport) throws Exception {
        Dimension d = this.getSize();
        if (this.backBuffer != null) {
            this.backBuffer.setColor(Color.gray);
            this.backBuffer.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        }
        if (this.backBuffer2 != null) {
            this.backBuffer2.setColor(Color.gray);
            this.backBuffer2.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        }
        if (parentReport != null && parentReport.currentNode != null) {
            if (parentReport.currentNode.getChartPath() != null) {
                report.setChartPath(parentReport.currentNode.getChartPath());
            }
            if (parentReport.currentNode.getImagePath() != null) {
                report.setImagePath(parentReport.currentNode.getImagePath());
            }
            if (parentReport.currentNode.getSubReportPath() != null) {
                report.setSubReportPath(parentReport.currentNode.getSubReportPath());
            }
            if (parentReport.currentNode.getDrillDownPath() != null) {
                report.setDrillDownPath(parentReport.currentNode.getDrillDownPath());
            }
            if (parentReport.domainPath != null && !parentReport.domainPath.equals("")) {
                report.domainPath = parentReport.domainPath;
            }
        } else if (this.report != null && this.report.currentNode != null) {
            if (this.report.currentNode.getChartPath() != null) {
                report.setChartPath(this.report.currentNode.getChartPath());
            }
            if (this.report.currentNode.getImagePath() != null) {
                report.setImagePath(this.report.currentNode.getImagePath());
            }
            if (this.report.currentNode.getSubReportPath() != null) {
                report.setSubReportPath(this.report.currentNode.getSubReportPath());
            }
            if (this.report.currentNode.getDrillDownPath() != null) {
                report.setDrillDownPath(this.report.currentNode.getDrillDownPath());
            }
            if (this.report.currentNode.getDomainPath() != null && !this.report.currentNode.getDomainPath().equals("")) {
                report.domainPath = this.report.currentNode.getDomainPath();
            }
        }
        this.report = report;
        this.setSize(QbUtil.toPixel(report.getPageWidth()) + 100, QbUtil.toPixel(report.getPageHeight()) + 100);
        this.resetPages();
        this.resetOffScreenImage();
        this.reportUI = null;
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        if (!this.showScrollPane) {
            super.setSize(w, h);
            return;
        }
        if (this.scrollPane != null) {
            Dimension size = this.scrollPane.getViewSize();
            this.prefWidth = Math.max(size.width, w);
            this.prefHeight = Math.max(size.height, h);
        } else {
            this.prefWidth = w;
            this.prefHeight = h;
        }
        super.setSize(this.prefWidth, this.prefHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        if (this.report == null) {
            return new Dimension(this.prefWidth, this.prefHeight);
        }
        return new Dimension(Math.max(QbUtil.toPixel(this.report.getPageWidth()), this.prefWidth), Math.max(QbUtil.toPixel(this.report.getPageHeight()), this.prefHeight));
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.showScrollPane) {
            return super.getPreferredSize();
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public void setRepaint(IReport report) {
        try {
            this.setReport(report.getReportInfo());
            this.resetOffScreenImage();
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.report == null) {
            super.paint(g);
            return;
        }
        if (!this.isKeyReady) {
            this.addKeyListener(this);
            this.isKeyReady = true;
        }
        this.update(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g) {
        Dimension d;
        if (this.showScrollPane) {
            this.scrollPane.doLayout();
            g = this.scrollPane.getClippedGraphics(g);
        }
        boolean redrawBG = false;
        if (this.designer) {
            if (this.xRuler != null) {
                this.xRuler.setZoomFactor(this.zoomFactor);
            }
            if (this.yRuler != null) {
                this.yRuler.setZoomFactor(this.zoomFactor);
            }
            d = this.getSize();
            g.setColor(Color.gray);
            g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
            g.setColor(Color.black);
            g.drawRect(49, 49, 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageWidth()) * this.zoomFactor), 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageHeight()) * this.zoomFactor));
            g.fillRect(53, 53, 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageWidth()) * this.zoomFactor), 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageHeight()) * this.zoomFactor));
            g.translate(50, 50);
        } else if (this.canvasBackgroundColor != null) {
            redrawBG = true;
        } else if (this.isSwing()) {
            redrawBG = true;
        }
        try {
            this.currentCursor = this.getCursor();
            if (this.reportUI == null) {
                this.reportUI = new ReportUI(this.report, g);
                this.reportUI.setImageMapEnabled(true);
                if (this.reportMain != null) {
                    this.reportMain.goToPageSection(this.page, this.section);
                }
            }
            if (this.offScreenImage == null || this.page != this.reportUI.getPage() || this.section != this.reportUI.getSection()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.flushImage();
                this.offScreenImage = this.createImage(QbUtil.toPixel(this.report.getPageWidth() * this.zoomFactor), QbUtil.toPixel(this.report.getPageHeight() * this.zoomFactor));
                this.backBuffer = this.offScreenImage.getGraphics();
                if (this.zoomFactor != 1.0) {
                    this.backBuffer = new ZoomGraphics(this.backBuffer, QbUtil.toPixel(this.report.getPageWidth()), QbUtil.toPixel(this.report.getPageHeight()), this.zoomFactor, this.zoomFactor);
                }
                this.reportUI.draw(this.backBuffer, this.page, this.section);
                this.imageMap = this.reportUI.getImageMap();
            }
            if (redrawBG) {
                d = this.getSize();
                if (this.canvasBackgroundColor != null) {
                    g.setColor(this.canvasBackgroundColor);
                } else {
                    g.setColor(Color.white);
                }
                g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
            }
            g.drawImage(this.offScreenImage, 0, 0, this);
            if (this.reportToolBar != null) {
                this.reportToolBar.setEnabled();
            }
            this.setCursor(this.currentCursor);
        }
        catch (OutOfMemoryError mem) {
            this.setCursor(this.currentCursor);
            System.out.println("Release Memory ...");
            System.gc();
            this.repaint();
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    boolean isBackButtonVisible() {
        if (this.imageMap == null) {
            return false;
        }
        for (int i = 0; i < this.imageMap.size(); ++i) {
            ImageMapNode node = (ImageMapNode)this.imageMap.elementAt(i);
            if (!node.isDrillDownLink()) continue;
            return true;
        }
        return false;
    }

    void showDataBox(int xpos, int ypos) throws Exception {
        if (!this.showDataHint) {
            return;
        }
        if (this.report == null) {
            this.removeCanvasListener();
            return;
        }
        ImageMapNode link = this.getImageMapNode(this.translate(xpos), this.translate(ypos));
        if (link != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.isDataPointSelected = this.displayHint(link.getHint(), this.translate(xpos), this.translate(ypos));
        } else {
            this.setCursor(this.currentCursor);
        }
    }

    void removeDataBox(int xpos, int ypos) throws Exception {
        if (this.report == null) {
            this.removeCanvasListener();
            return;
        }
        ImageMapNode node = this.getImageMapNode(this.translate(xpos), this.translate(ypos));
        if (node == null && this.isDataPointSelected) {
            this.initBackImage(true);
            Graphics graphics = this.getGraphics();
            if (this.showScrollPane) {
                graphics = this.scrollPane.getClippedGraphics(graphics);
            }
            Dimension d = this.getSize();
            if (this.showScrollPane) {
                graphics = this.scrollPane.getClippedGraphics(graphics);
            }
            if (this.canvasBackgroundColor != null) {
                graphics.setColor(this.canvasBackgroundColor);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
            graphics.drawImage(this.offScreenImage2, 0, 0, this);
            this.isDataPointSelected = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    ImageMapNode getImageMapNode(int xpos, int ypos) {
        if (this.imageMap == null) {
            return null;
        }
        for (int i = 0; i < this.imageMap.size(); ++i) {
            ImageMapNode node = (ImageMapNode)this.imageMap.elementAt(i);
            if (node.getObject() instanceof Rectangle && ((Rectangle)node.getObject()).contains(xpos, ypos)) {
                return node;
            }
            if (node.getObject() instanceof Polygon && ((Polygon)node.getObject()).contains(xpos, ypos)) {
                return node;
            }
            if (!(node.getObject() instanceof Arc) || !((Arc)node.getObject()).contains(xpos, ypos)) continue;
            return node;
        }
        return null;
    }

    private boolean displayHint(String str, int x, int y) {
        return this.displayHint(str, this.dataBgColor, this.dataFontColor, this.dataFont, x + this.hintX, y + this.hintY);
    }

    private boolean displayHint(String str, Color bgColor, Color fnColor, Font font, int x, int y) {
        if (str == null || str.trim().equals("")) {
            return false;
        }
        this.initBackImage(true);
        x = (int)Math.ceil((double)x * this.zoomFactor);
        y = (int)Math.ceil((double)y * this.zoomFactor);
        FontMetrics fm = this.backBuffer2.getFontMetrics(font);
        int cw = fm.stringWidth("A");
        int w = fm.stringWidth(str);
        int txtheight = fm.getMaxAscent() + fm.getMaxDescent();
        int h = txtheight + 4;
        if (x + (w += 2 * cw) > QbUtil.toPixel(this.report.getPageWidth())) {
            x = QbUtil.toPixel(this.report.getPageWidth()) - w;
        }
        if (y + h > QbUtil.toPixel(this.report.getPageHeight())) {
            y = QbUtil.toPixel(this.report.getPageHeight()) - h;
        }
        this.backBuffer2.setColor(bgColor);
        this.backBuffer2.fill3DRect(x - 2, y, w, h, true);
        this.backBuffer2.setColor(fnColor);
        this.backBuffer2.setFont(font);
        this.backBuffer2.drawString(str, x + cw, y + txtheight);
        Graphics graphics = this.getGraphics();
        Dimension d = this.getSize();
        if (this.showScrollPane) {
            graphics = this.scrollPane.getClippedGraphics(graphics);
        }
        if (this.canvasBackgroundColor != null) {
            graphics.setColor(this.canvasBackgroundColor);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        graphics.drawImage(this.offScreenImage2, 0, 0, this);
        return true;
    }

    boolean gotoHyperLink(String target, String link) {
        if (link == null || link.trim().equals("") || link.trim().equals("http://") || link.trim().equals("https://")) {
            return false;
        }
        Object obj = this.do_openReport(link, target, null, -1, null);
        if (obj != null) {
            this.linkHistory.addElement(obj);
        }
        return true;
    }

    void gotoBookmark(int pageNumber, int section, double y) {
        try {
            this.setPage(pageNumber);
            this.setSection(section);
            this.reportMain.updatePreviewToolBar();
            int xPos = 0;
            int yPos = QbUtil.toPixel(y + this.report.getTopMargin());
            this.scrollPane.setScrollPosition(new Point(xPos, yPos));
            this.resetOffScreenImage();
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    boolean gotoDrillDownLink(Report ddReport, byte[] bytearray, String link, Object[] params, int nodeIndex, String parentFile) {
        if (link == null || link.trim().equals("") || link.trim().equals("http://") || link.trim().equals("https://")) {
            return false;
        }
        try {
            if (ddReport != null) {
                OrderedParameterSet ps = ddReport.getParametersInSequence();
                int unMappedCt = 0;
                if (params != null) {
                    for (Object param : params) {
                        if (!param.equals("UnMapped")) continue;
                        ++unMappedCt;
                    }
                }
                if (unMappedCt > 0) {
                    DBInfoBasic dbInfo = ddReport.dbInfo;
                    QueryFileInfo queryFileInfo = (QueryFileInfo)dbInfo;
                    QueryInParam[] queryInParam = queryFileInfo.getInSet().getParameter();
                    if (ddReport.isPrevParamPrompt) {
                        int i;
                        int paramCt = ps.size();
                        QueryInParam[][] paramInPromptSequence = new QueryInParam[paramCt][paramCt];
                        OrderedParameterSet ops = this.report.getParametersInSequence(this.report.currentNode.getChildAt(nodeIndex), true);
                        unMappedCt = 0;
                        for (i = 0; i < params.length; ++i) {
                            if (params[i].equals("UnMapped")) continue;
                            queryInParam[i].setValue(params[i]);
                        }
                        for (i = 0; i < ops.getOrderCount(); ++i) {
                            for (int j = 0; j < ops.getParamsAt(i).size(); ++j) {
                                for (QueryInParam element : queryInParam) {
                                    if (!element.getParamName().equals(ops.get(i, j).name())) continue;
                                    paramInPromptSequence[i][j] = element;
                                }
                            }
                        }
                        DBInfoBasic newDBInfo = dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(dbInfo.getJNDIName(), dbInfo.getQuery(), dbInfo.getEnvProperties()) : new DBInfoBasic(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword(), dbInfo.getQuery(), dbInfo.getAdditionalDb());
                        QueryFileInfo qfi = new QueryFileInfo(queryFileInfo.getProductName(), queryFileInfo.getVersion(), newDBInfo, new QueryInParamSet(queryInParam, paramInPromptSequence));
                        ddReport.dbInfo = qfi;
                        EnterParamDialog dialog = new EnterParamDialog(SwingUtil.findFrameParent(this), ddReport, queryFileInfo, null, 1, true, null, null);
                        dialog.setVisible(true);
                        ddReport.dbInfo = dbInfo;
                        if (dialog.isCancelled()) {
                            return false;
                        }
                    } else {
                        for (int i = 0; i < ps.size(); ++i) {
                            if (!params[i].equals("UnMapped")) {
                                ps.get(i).setValue(params[i]);
                                continue;
                            }
                            ps.get(i).setValue(ps.get(i).getDefaultValue());
                        }
                    }
                } else {
                    for (int i = 0; i < ps.size(); ++i) {
                        ps.get(i).setValue(params[i]);
                    }
                }
                ddReport = ReloadReport.reloadData(ddReport, false);
                this.linkHistory.addElement(new PaginatedReport(this.report, this.page, this.section));
                this.setReport(ddReport);
                this.repaint();
                return true;
            }
            if (Report.fileExists(this.reportMain.getSubFilesTable(), link)) {
                Object obj = this.do_openReport(link, "", params, nodeIndex, parentFile);
                if (obj != null) {
                    this.linkHistory.addElement(obj);
                }
                return true;
            }
            if (bytearray != null) {
                Vector<QueryInParamSet> vect = new Vector<QueryInParamSet>();
                vect.addElement((QueryInParamSet)params);
                Report newReport = new LoadReport().loadReport(new DataInputStream(new ByteArrayInputStream(bytearray)), vect);
                if (newReport == null) {
                    return false;
                }
                this.linkHistory.addElement(new PaginatedReport(this.report, this.page, this.section));
                this.setReport(newReport);
                this.repaint();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean goBackHyperLink() {
        if (this.linkHistory.size() <= 0) {
            return false;
        }
        Object obj = this.linkHistory.lastElement();
        this.linkHistory.removeElement(obj);
        if (obj instanceof PaginatedReport) {
            this.do_openReport((PaginatedReport)obj);
        } else {
            this.do_openReport((String)obj, "EspressChart", null, -1, null);
        }
        return true;
    }

    int countLinkHistory() {
        return this.linkHistory.size();
    }

    boolean do_openReport(Report newReport) {
        try {
            this.setReport(newReport);
            if (newReport instanceof PaginatedReport) {
                this.setSection(((PaginatedReport)newReport).getLastBrowseSection());
                this.setPage(((PaginatedReport)newReport).getLastBrowsePage());
                this.repaint();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object do_openReport(String s, String target, Object[] params, int nodeIndex, String parentFile) {
        block31: {
            Object object = null;
            if (s.toLowerCase().endsWith(".pak") || s.toLowerCase().endsWith(".rpt") || s.toLowerCase().endsWith(".xml")) {
                try {
                    Report rpt;
                    this.currentCursor = this.getCursor();
                    Report parentReport = null;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (params == null) {
                        LoadReport lr = new LoadReport();
                        lr.setSubFilesTable(this.report.getSubFilesTable());
                        if (this.report != null) {
                            lr.setSecurityLevel(this.report.getPreviewSecurityLevel());
                        }
                        if ((rpt = lr.loadReportFromFile(s)) == null) {
                            Object var10_13 = null;
                            return var10_13;
                        }
                        if (lr.getDrillDownNode() != null) {
                            rpt.currentNode = lr.getDrillDownNode();
                        }
                    } else {
                        Vector<QueryInParamSet> vect = new Vector<QueryInParamSet>();
                        vect.addElement((QueryInParamSet)params);
                        LoadReport lr = new LoadReport();
                        lr.setSubFilesTable(this.report.getSubFilesTable());
                        if (this.reportMain != null) {
                            lr.setRelativeDomainPath(this.reportMain.getRelativeDomainPath());
                        }
                        if (this.report != null) {
                            lr.setSecurityLevel(this.report.getPreviewSecurityLevel());
                        }
                        if (this.report.currentNode.getChildCount() > nodeIndex) {
                            lr.setNodeForUnmappedDrillDown(this.report.currentNode.getChildAt(nodeIndex));
                        }
                        if ((rpt = lr.loadReportFromFile(s, vect, false, true)) == null) {
                            Object var11_15 = null;
                            return var11_15;
                        }
                        boolean sub = false;
                        for (int i = 0; this.report.subReports != null && i < this.report.subReports.size(); ++i) {
                            if (!this.report.subReports.elementAt(i).getFileName().equals(parentFile)) continue;
                            SubReportObject sro = this.report.subReports.elementAt(i);
                            try {
                                Class<?> qbReportClass = Class.forName("quadbase.reportdesigner.ReportAPI.QbReport");
                                parentReport = ((IReport)((Object)sro.getSubReport(false, false, true, this.report))).getReportInfo();
                            }
                            catch (Exception ex) {
                                parentReport = this.report.getSubReportArray()[i];
                            }
                            try {
                                rpt.currentNode = parentReport.currentNode.getChildAt(nodeIndex);
                                sub = true;
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!sub) {
                            rpt.currentNode = this.report.currentNode.getChildAt(nodeIndex);
                        }
                        ReportTable tbl = rpt.getReportTables().elementAt(0);
                        for (int j = 0; j < tbl.getColumnCount(); ++j) {
                            if (!rpt.colInfo[rpt.getColInfoIndex(tbl.getColumn(j))].isColumnBreak() || tbl.getColumn(j).getDrillDownName() != null) continue;
                            tbl.getColumn(j).setDrillDownName(rpt.colInfo[rpt.getColInfoIndex(tbl.getColumn(j))].getDrillDownName());
                        }
                    }
                    this.setCursor(this.currentCursor);
                    String reportName = this.report.getName();
                    object = reportName == null || reportName.equals("") ? new PaginatedReport(this.report, this.page, this.section) : reportName;
                    this.setReport(rpt, parentReport);
                    this.repaint();
                    Object object2 = object;
                    return object2;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.setCursor(this.currentCursor);
                    System.out.println(ex.toString());
                    if (s.toLowerCase().endsWith(".rpt")) {
                        Object var9_11 = null;
                        return var9_11;
                    }
                    break block31;
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            try {
                if (QbUtil.openLinkInBrowserFromJNLP(s)) {
                    return null;
                }
                Applet applet = ServerMessage.getApplet();
                if (applet == null) {
                    System.out.println("Cannot open link - applet is null: " + s);
                    return null;
                }
                if (s.startsWith("http:") || s.startsWith("https:")) {
                    applet.getAppletContext().showDocument(new URL(s), target);
                } else {
                    applet.getAppletContext().showDocument(new URL(applet.getDocumentBase(), s), target);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }
        return null;
    }

    void initBackImage(boolean copy) {
        if (this.reportUI == null) {
            return;
        }
        try {
            if (this.offScreenImage2 == null || this.page != this.reportUI.getPage() || this.section != this.reportUI.getSection()) {
                this.flushImage2();
                int width = QbUtil.toPixel(this.report.getPageWidth());
                int height = QbUtil.toPixel(this.report.getPageHeight());
                if (this.showScrollPane) {
                    width += 100;
                    height += 100;
                }
                this.offScreenImage2 = this.createImage(width, height);
                this.backBuffer2 = this.offScreenImage2.getGraphics();
                if (this.designer) {
                    Dimension d = this.getSize();
                    this.backBuffer2.setColor(Color.gray);
                    this.backBuffer2.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
                    this.backBuffer2.setColor(Color.black);
                    this.backBuffer2.drawRect(49, 49, 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageWidth()) * this.zoomFactor), 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageHeight()) * this.zoomFactor));
                    this.backBuffer2.fillRect(53, 53, 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageWidth()) * this.zoomFactor), 1 + (int)Math.floor((double)QbUtil.toPixel(this.report.getPageHeight()) * this.zoomFactor));
                    this.backBuffer2.translate(50, 50);
                } else {
                    if (this.canvasBackgroundColor != null) {
                        this.backBuffer2.setColor(this.canvasBackgroundColor);
                    } else {
                        this.backBuffer2.setColor(Color.white);
                    }
                    this.backBuffer2.fillRect(0, 0, width, height);
                }
            }
            if (copy && this.offScreenImage != null) {
                this.backBuffer2.drawImage(this.offScreenImage, 0, 0, this);
            } else {
                this.reportUI.draw(this.backBuffer2, this.page, this.section);
                this.imageMap = this.reportUI.getImageMap();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void flushImage() {
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
    }

    void flushImage2() {
        if (this.offScreenImage2 != null) {
            this.offScreenImage2.flush();
            this.offScreenImage2 = null;
        }
    }

    void resetOffScreenImage() {
        this.offScreenImage = null;
    }

    @Override
    public void run() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseClicked(e);
        } else if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseExited(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mouseListener != null) {
            this.mouseListener.mousePressed(e);
        } else {
            try {
                this.lastx = e.getX();
                this.lasty = e.getY();
                this.isPopupTrigger = false;
                this.isPopupMenuOp = false;
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (mouseMask == this.backLinkMask && e.getClickCount() == this.backLinkClickCount && this.goBackHyperLink()) {
                    return;
                }
                ImageMapNode node = this.getImageMapNode(this.translate(this.lastx), this.translate(this.lasty));
                if (node != null) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    if (mouseMask == this.forwLinkMask && e.getClickCount() == this.forwLinkClickCount) {
                        if (node.isBookmark()) {
                            this.gotoBookmark(node.getPageNumber(), node.getSection(), node.getY());
                            return;
                        }
                        if (node.isDrillDownLink() ? this.gotoDrillDownLink(node.getDrillReport(), node.getByteArray(), node.getLink(), node.getParameters(), node.getDrillDownNodeIndex(), node.getParentFile()) : this.gotoHyperLink(node.getTarget(), node.getLink())) {
                            return;
                        }
                    }
                }
                if (mouseMask == IOUtil.getRightMouseClickMask() && e.getClickCount() == 1) {
                    this.isPopupMenuOp = true;
                    if (!this.isPopupTrigger) {
                        this.isPopupTrigger = e.isPopupTrigger();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.menuVisible) {
            return;
        }
        if (this.mouseListener != null) {
            this.mouseListener.mouseReleased(e);
        } else {
            int x = e.getX();
            int y = e.getY();
            if (!this.isPopupTrigger) {
                this.isPopupTrigger = e.isPopupTrigger();
            }
            if (this.isPopupMenuOp && x == this.lastx && y == this.lasty && this.isPopupTrigger) {
                try {
                    PopupMenuForReport popupMenu = new PopupMenuForReport(this, this.reportMain, this.report);
                    if (popupMenu.getItemCount() > 0) {
                        this.add(popupMenu);
                        popupMenu.show((Component)popupMenu.getParent(), x, y);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.out.println("REPORT CANVAS: cannot display popup menu!");
                }
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseMoved(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (e.isControlDown() && key == 82 && this.isRefreshEnabled) {
            this.do_Reload();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getSection() {
        return this.section;
    }

    public void setPage(int p) {
        this.page = p;
    }

    public void setSection(int s) {
        this.section = s;
    }

    public int getTotalPages() {
        if (this.reportUI != null) {
            return this.reportUI.getTotalPages();
        }
        return -1;
    }

    public int getTotalSections() {
        if (this.reportUI != null) {
            return this.reportUI.getTotalSections();
        }
        return -1;
    }

    public boolean isNextPageEnabled() {
        if (this.reportUI == null) {
            return false;
        }
        return this.page < this.reportUI.getTotalPages();
    }

    public boolean isPrevPageEnabled() {
        return this.page > 1;
    }

    public boolean isNextSectionEnabled() {
        if (this.reportUI == null) {
            return false;
        }
        return this.section < this.reportUI.getTotalSections();
    }

    public boolean isPrevSectionEnabled() {
        return this.section > 1;
    }

    public void goToPreviousAvailPage() {
        if (!this.isPrevAvailPageEnabled()) {
            return;
        }
        if (this.section == 1) {
            this.setSection(this.reportUI.getTotalSections());
            this.setPage(this.page - 1);
        } else {
            this.setSection(this.section - 1);
        }
    }

    public void goToNextAvailPage() {
        if (!this.isNextAvailPageEnabled()) {
            return;
        }
        if (this.section == this.reportUI.getTotalSections()) {
            this.setSection(1);
            this.setPage(this.page + 1);
        } else {
            this.setSection(this.section + 1);
        }
    }

    public boolean isPrevAvailPageEnabled() {
        return this.isPrevPageEnabled() || this.isPrevSectionEnabled();
    }

    public boolean isNextAvailPageEnabled() {
        return this.isNextPageEnabled() || this.isNextSectionEnabled();
    }

    public boolean isGotoEnabled() {
        return true;
    }

    public void resetPages() throws Exception {
        this.page = 1;
        this.section = 1;
        if (this.reportUI != null) {
            this.reportUI.resetPages();
        }
    }

    public void print() {
        try {
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (IOUtil.isJava2D()) {
                PrintReport.printUsingSwing(this.reportUI);
            } else {
                new PrintReport(this.reportUI, (Component)this).print();
            }
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            ex.printStackTrace();
            System.out.println("Print Job Cancelled!");
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void setExportTarget(boolean server) {
        this.exportTarget = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(int format) {
        String ext = ".html";
        if (format == 2) {
            ext = ".pdf";
        } else if (format == 3) {
            ext = ".csv";
        } else if (format == 5) {
            ext = ".txt";
        } else if (format == 9) {
            ext = ".xls";
        } else if (format == 17) {
            ext = ".xlsx";
        } else if (format == 13) {
            ext = ".rtf";
        } else if (format == 6 || format == 7) {
            ext = ".xml";
        }
        try {
            if (this.exportTarget) {
                String repFileName;
                String templatesDir = this.browseDir.getReportTemplatesDirectory();
                if (!templatesDir.endsWith("/") && !templatesDir.endsWith("\\")) {
                    templatesDir = templatesDir + "/";
                }
                repFileName = (repFileName = this.report.getFileNameWithoutExtension()).equals("") ? "Untitled" : repFileName;
                OpenSaveDialog dialog = new OpenSaveDialog((Object)ServerMessage.getFrame(), "Please specify the file name :", templatesDir + repFileName + ext, ext);
                dialog.setCurrentDirectory(templatesDir);
                dialog.pack();
                dialog.setVisible(true);
                if (dialog.getSelectedFile() != null) {
                    this.browseDir.setReportTemplatesDirectory(dialog.getCurrentDirectory());
                    if (!this.setupDynamicExport(format)) {
                        return;
                    }
                } else {
                    return;
                }
                System.out.print("Exporting file [" + dialog.getSelectedFile() + "]... ");
                this.currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.export(format, dialog.getSelectedFile());
                this.setCursor(this.currentCursor);
                System.out.println("done");
            } else {
                System.out.print("Export to client browser...");
                this.currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!this.setupDynamicExport(format)) {
                    return;
                }
                this.exportServlet(format);
                this.setCursor(this.currentCursor);
            }
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    boolean setupDynamicExport(int format) {
        if (this.report.currentNode.getChildCount() > 0 && (format == 4 || format == 2 || format == 6)) {
            if (!this.hasDefaultDynamicExportParam) {
                CServerPortDialog sDialog = new CServerPortDialog((Object)ServerMessage.getFrame());
                sDialog.setVisible(true);
                if (sDialog.isModified()) {
                    this.isDynamicExport = this.report.isDynamicExport();
                    this.serverName = sDialog.getServerName();
                    this.serverPort = sDialog.getPortNumber();
                    this.servletDir = sDialog.getServletDirectory();
                    this.hasDefaultDynamicExportParam = true;
                } else {
                    return false;
                }
            }
            this.report.setDynamicExport(this.isDynamicExport, this.serverName, this.serverPort);
            this.report.setServletDirectory(this.servletDir);
            System.out.println("dynamic export [" + this.serverName + ":" + this.serverPort + "," + this.servletDir + "]");
        }
        return true;
    }

    void export(int format, String file) throws Exception {
        if (this.report.currentNode == this.report.currentNode.getRoot()) {
            this.report.export(format, file, this.report.currentNode);
        } else {
            this.report.export(format, file, null);
        }
    }

    void exportServlet(int format) throws Exception {
        URL servlet = new URL(this.exportServlet);
        URLConnection con = servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/octet-stream");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        if (this.report.currentNode == this.report.currentNode.getRoot()) {
            this.report.export(format, bao, this.report.currentNode);
        } else {
            this.report.export(format, bao, null);
        }
        byte[] bytes = bao.toByteArray();
        ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
        out.writeInt(bytes.length);
        Properties info = new Properties();
        info.setProperty("format", String.valueOf(format));
        out.writeObject(info);
        out.write(bytes, 0, bytes.length);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(con.getInputStream()));
        boolean success = in.readBoolean();
        int key = in.readInt();
        this.showExportInBrowser(key);
    }

    void showExportInBrowser(int key) {
        try {
            Applet applet = ServerMessage.getApplet();
            if (applet == null) {
                System.out.println("Cannot show browser in non Applet");
                return;
            }
            URL url = new URL(this.exportServlet + "?key=" + key);
            applet.getAppletContext().showDocument(url, "ExportReport");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_Reload() {
        this.loading = true;
        Report newReport = null;
        this.setEnabled(false);
        try {
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            newReport = ReloadReport.reloadData(this.report, false);
            this.setReport(newReport);
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            this.setCursor(this.currentCursor);
            System.out.println(ex.toString());
            Applet applet = ServerMessage.getApplet();
            if (applet instanceof Viewer) {
                ((Viewer)applet).rThread.pleaseStop();
            }
            this.doneReload();
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.doneReload();
        this.resetOffScreenImage();
        this.repaint();
    }

    public void doneReload() {
        this.loading = false;
        this.setEnabled(true);
    }

    void setReportMain(IReportMain reportMain) {
        this.reportMain = reportMain;
    }

    IReportMain getReportMain() {
        return this.reportMain;
    }

    public void setMouseListener(MouseListener listener) {
        this.mouseListener = listener;
    }

    public void setMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = listener;
    }

    public int getZoomFactor() {
        return (int)Math.rint(this.zoomFactor * 100.0);
    }

    public void setZoomFactor(int in) {
        if (in <= 0) {
            in = 100;
        }
        if (in > 200) {
            in = 200;
        }
        this.zoom((float)in / 100.0f);
        if (this.reportToolBar != null) {
            this.reportToolBar.updateZoomFactor();
        }
    }

    public void zoom(double factor) {
        double oldzoom = this.zoomFactor;
        this.zoomFactor = factor < 0.2 ? 0.2 : factor;
        if (this.zoomFactor != oldzoom) {
            this.flushImage();
            this.flushImage2();
        }
        if (this.xRuler != null) {
            this.xRuler.setZoomFactor(this.zoomFactor);
        }
        if (this.yRuler != null) {
            this.yRuler.setZoomFactor(this.zoomFactor);
        }
        if (this.zoomFactor > 1.0) {
            this.setSize(QbUtil.toPixel(this.report.getPageWidth()) * 2 + 100, QbUtil.toPixel(this.report.getPageHeight()) * 2 + 100);
            if (this.xRuler != null) {
                this.xRuler.setMaxLength(QbUtil.toPixel(this.report.getPageWidth()) * 2 + 100);
            }
            if (this.yRuler != null) {
                this.yRuler.setMaxLength(QbUtil.toPixel(this.report.getPageHeight()) * 2 + 100);
            }
        } else {
            this.setSize(QbUtil.toPixel(this.report.getPageWidth()) + 100, QbUtil.toPixel(this.report.getPageHeight()) + 100);
            if (this.xRuler != null) {
                this.xRuler.setMaxLength(QbUtil.toPixel(this.report.getPageWidth()) * 2 + 100);
            }
            if (this.yRuler != null) {
                this.yRuler.setMaxLength(QbUtil.toPixel(this.report.getPageHeight()) * 2 + 100);
            }
        }
    }

    public void setFromDesigner(boolean state, boolean isMetric) {
        this.designer = state;
        if (this.showScrollPane && this.designer) {
            try {
                if (this.xRuler == null) {
                    this.xRuler = new CRuler(false, isMetric, QbUtil.toPixel(this.report.getPageWidth()) + 100, QbUtil.toPixel(this.report.getPageWidth()), this.zoomFactor);
                    this.scrollPane.setColumnHeaderView(this.xRuler);
                } else {
                    this.xRuler.update(false, isMetric, QbUtil.toPixel(this.report.getPageWidth()) + 100, QbUtil.toPixel(this.report.getPageWidth()), this.zoomFactor);
                }
                if (this.yRuler == null) {
                    this.yRuler = new CRuler(true, isMetric, QbUtil.toPixel(this.report.getPageHeight()) + 100, QbUtil.toPixel(this.report.getPageHeight()), this.zoomFactor);
                    this.scrollPane.setRowHeaderView(this.yRuler);
                } else {
                    this.yRuler.update(true, isMetric, QbUtil.toPixel(this.report.getPageHeight()) + 100, QbUtil.toPixel(this.report.getPageHeight()), this.zoomFactor);
                }
                CPanel p = new CPanel();
                p.setBackground(Color.gray);
                this.scrollPane.setCorner("UPPER_LEFT_CORNER", p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int translate(int x) {
        if (this.designer) {
            return (int)((double)(x - 50) / this.zoomFactor);
        }
        return (int)((double)x / this.zoomFactor);
    }

    public void setCanvasBackgroundColor(Color color) {
        this.canvasBackgroundColor = color != null ? color : Color.white;
    }

    public void setPageMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisiblePageMenuItem == null) {
                this.invisiblePageMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisiblePageMenuItem.addElement(element);
            }
        } else {
            if (this.invisiblePageMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisiblePageMenuItem.remove(element);
            }
        }
    }

    public void setOutputMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisibleOutputMenuItem == null) {
                this.invisibleOutputMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisibleOutputMenuItem.addElement(element);
            }
        } else {
            if (this.invisibleOutputMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisibleOutputMenuItem.remove(element);
            }
        }
    }

    public void setSectionMenuItemVisible(String[] menuItem, boolean b) {
        if (menuItem == null) {
            return;
        }
        if (!b) {
            if (this.invisibleSectionMenuItem == null) {
                this.invisibleSectionMenuItem = new Vector();
            }
            for (String element : menuItem) {
                this.invisibleSectionMenuItem.addElement(element);
            }
        } else {
            if (this.invisibleSectionMenuItem == null) {
                return;
            }
            for (String element : menuItem) {
                this.invisibleSectionMenuItem.remove(element);
            }
        }
    }

    public void setDrillDownParameterValues() throws Exception {
        DrillDownValueSelectionDialog dDialog = new DrillDownValueSelectionDialog(this);
        dDialog.setVisible(true);
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
    }

    void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.isDynamicExport = state;
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.servletDir = servletDirectory;
        this.hasDefaultDynamicExportParam = true;
    }

    void setExportServlet(String url) {
        this.exportServlet = url;
    }

    String getExportServlet() {
        return this.exportServlet;
    }

    boolean isSwing() {
        String className = this.getClass().toString();
        return className.indexOf("swing") > 0;
    }
}

