/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportViewer.CApplet;
import quadbase.reportdesigner.ReportViewer.CFrame;
import quadbase.reportdesigner.ReportViewer.CLabel;
import quadbase.reportdesigner.ReportViewer.ParamThread;
import quadbase.reportdesigner.ReportViewer.ReloadThread;
import quadbase.reportdesigner.ReportViewer.ReportCanvas;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.IReportMain;

public class Viewer
extends CApplet {
    private static final Logger LOGGER = Logger.getLogger(Viewer.class.getName());
    ReportCanvas reportCanvas;
    boolean initialized = false;
    long reloadTime;
    Socket serverSocket = null;
    int serverportno;
    InetAddress paramserver = null;
    ReloadThread rThread;
    ParamThread pThread;
    private IReportMain reportMain;
    private MouseListener mouseListener = null;
    private MouseMotionListener mouseMotionListener = null;
    private Color canvasBackgroundColor = null;

    public Component getComponent(IReport report) {
        return this.getComponent(report, 0);
    }

    public Component getComponent(IReport report, int scrollBarOption) {
        this.reportCanvas = new ReportCanvas(report.getReportInfo(true), scrollBarOption);
        this.reportCanvas.setReportMain(this.reportMain);
        this.reportCanvas.setMouseListener(this.mouseListener);
        this.reportCanvas.setMouseMotionListener(this.mouseMotionListener);
        if (this.canvasBackgroundColor != null) {
            this.reportCanvas.setCanvasBackgroundColor(this.canvasBackgroundColor);
        }
        return this.reportCanvas.getReportComponent();
    }

    public ReportCanvas getReportCanvas() {
        return this.reportCanvas;
    }

    @Override
    public void init() {
        String hosts;
        String portno;
        String address;
        String servletContext;
        String comm_url;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Viewer.initJNLP();
        ServerMessage.setCheckMachineName(false);
        ServerMessage.useServer = this.getBoolean("EspressManagerUsed", true);
        String c_proto = this.getParameter("comm_protocol");
        if (c_proto != null) {
            if (c_proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (c_proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        if ((address = this.getParameter("server_address")) != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
        if ((portno = this.getParameter("server_port_number")) != null) {
            try {
                int portnumber = Integer.parseInt(portno);
                ServerMessage.setPortNumber(portnumber);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
        if ((hosts = this.getParameter("server_hosts")) != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        String filename = this.getParameter("file");
        String enc = this.getParameter("enc");
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        ServerMessage.setApplet(this);
        this.setBorderLayout();
        try {
            this.getParamServer();
            this.getReloadInterval();
            this.reportCanvas = new ReportCanvas(this.createReport(), 0);
            this.setParameters(this.reportCanvas);
            this.add("Center", this.reportCanvas.getReportComponent());
            this.reportCanvas.setReportToolBarVisible(true);
        }
        catch (Exception ex) {
            this.add("Center", new CLabel(IOUtil.getStackTrace(ex)));
            ex.printStackTrace();
        }
    }

    void error(String s) {
        this.add("Center", new CLabel(s));
        System.out.println(s);
    }

    @Override
    public void start() {
        this.init();
        if (this.paramserver != null) {
            try {
                this.serverSocket = new Socket(this.paramserver, this.serverportno);
            }
            catch (Exception ex) {
                this.error("Failed to open socket for parameter server ! \n" + IOUtil.getStackTrace(ex));
                return;
            }
        }
        if (this.reloadTime > 0L && this.reportCanvas.getReport().sourceData != 0) {
            this.rThread = new ReloadThread(this);
            this.rThread.setTime(this.reloadTime * 1000L);
            this.rThread.start();
        }
        if (this.serverSocket != null) {
            this.pThread = new ParamThread(this.serverSocket, this.reportCanvas);
            this.pThread.start();
        }
    }

    @Override
    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        if (this.rThread != null) {
            this.rThread.pleaseStop();
            this.rThread = null;
        }
        if (this.pThread != null) {
            this.pThread.pleaseStop();
            this.pThread = null;
        }
        this.initialized = false;
    }

    void getParamServer() throws Exception {
        String serverPortnoStr = this.getParameter("ParameterServer");
        if (serverPortnoStr == null) {
            return;
        }
        int idx = serverPortnoStr.lastIndexOf(58);
        if (idx < 0) {
            throw new IllegalArgumentException("No port no specify for the server !");
        }
        this.serverportno = Integer.parseInt(serverPortnoStr.substring(idx + 1));
        if (this.serverportno <= 0) {
            throw new IllegalArgumentException("Invalid value for ServerPortno. It must be an interger > 0.");
        }
        String s = serverPortnoStr.substring(0, idx).trim();
        this.paramserver = s.equals("") ? InetAddress.getByName(this.getCodeBase().getHost()) : InetAddress.getByName(s);
    }

    void getReloadInterval() throws Exception {
        String reloadstr = this.getParameter("RefreshInterval");
        if (reloadstr == null) {
            return;
        }
        this.reloadTime = Long.parseLong(reloadstr);
        if (this.reloadTime <= 0L) {
            throw new IllegalArgumentException("Invalid value for RefreshInterval. It must be an integer > 0.");
        }
    }

    public static void main(String[] argv) {
        if (argv.length <= 0) {
            System.out.println("Please specify report file name!");
            return;
        }
        ServerMessage.useServer = argv.length < 1;
        ServerMessage.setApplet(null);
        Viewer viewer = null;
        CFrame frame = new CFrame("Viewer : " + argv[0]);
        WindowAdapter winAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(winAdapter);
        ServerMessage.setFrame(frame);
        frame.setBorderLayout();
        try {
            viewer = new Viewer();
            LoadReport loadReport = new LoadReport();
            if (argv[0].toLowerCase().endsWith(".pak")) {
                loadReport.getSubFilesTable().setTopName(argv[0]);
                loadReport.getSubFilesTable().setFileInMemEnabled(true);
            }
            frame.add("Center", viewer.getComponent(loadReport.loadReportFromFile(argv[0])));
            viewer.reportCanvas.setReportToolBarVisible(true);
        }
        catch (Exception ex) {
            frame.add("Center", new CLabel(IOUtil.getStackTrace(ex)));
            System.out.println("Cannot Open Report File!");
            ex.printStackTrace();
        }
        Viewer.setPosition(frame);
        frame.setVisible(true);
    }

    static void setPosition(CFrame frame) {
        frame.pack();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        int x = (screenSize.width - 500) / 2;
        int y = (screenSize.height - 500) / 2;
        frame.setBounds(x, y, 500, 500);
        frame.setSize(500, 500);
    }

    Report createReport() throws Exception {
        String tpl = this.getParameter("FileName");
        String securityLevel = this.getParameter("SecurityLevel");
        String reportData = this.getParameter("ReportData");
        if (reportData != null) {
            LoadReport lr = new LoadReport();
            lr.setSecurityLevel(securityLevel);
            return lr.loadReport(new DataInputStream(new ByteArrayInputStream(this.convertStringToByteArray(reportData))), null);
        }
        String sourceDB = this.getParameter("SourceDB");
        String sourceFile = this.getParameter("SourceFile");
        String sourceData = this.getParameter("SourceData");
        String sourceJNDI = this.getParameter("SourceJNDI");
        if (sourceDB == null && sourceFile == null && sourceData == null && tpl != null && sourceJNDI == null) {
            LoadReport lr = new LoadReport();
            if (tpl.toLowerCase().endsWith(".pak")) {
                lr.getSubFilesTable().setTopName(tpl);
                lr.getSubFilesTable().setFileInMemEnabled(true);
            }
            lr.readOnly = true;
            lr.setSecurityLevel(securityLevel);
            return lr.loadReportFromFile(tpl);
        }
        if (sourceDB != null) {
            return this.getDataBaseInfo(sourceDB, tpl);
        }
        if (sourceFile != null) {
            return this.getDataFileInfo(sourceFile, tpl);
        }
        if (sourceData != null) {
            return this.getDataSourceInfo(sourceData, tpl);
        }
        if (sourceJNDI != null) {
            return this.getJNDIInfo(sourceJNDI, tpl);
        }
        throw new IllegalArgumentException("Not enough information to create report!");
    }

    private Report getDataSourceInfo(String sourceData, String template) throws Exception {
        ColData[] colData = IOUtil2.getColData(sourceData);
        Report report = this.createReport(colData, template);
        report.sourceData = 0;
        return report;
    }

    private Report getDataFileInfo(String dataFile, String template) throws Exception {
        ColData[] colData = new DataFileInput().readProcessedData(dataFile, false, null, null);
        Report report = this.createReport(colData, template);
        report.sourceData = 2;
        report.sourceFile = dataFile;
        return report;
    }

    private Report getDataBaseInfo(String info, String template) throws Exception {
        int idx1 = info.indexOf(44);
        if (idx1 < 0) {
            throw new Exception("url name not find");
        }
        String url = info.substring(0, idx1).trim();
        int idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new Exception("driver name not find");
        }
        String driver = info.substring(idx1 + 1, idx2).trim();
        idx1 = info.indexOf(44, idx2 + 1);
        if (idx1 < 0) {
            throw new Exception("user name not find");
        }
        String userID = info.substring(idx2 + 1, idx1).trim();
        idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new Exception("password not find");
        }
        String password = info.substring(idx1 + 1, idx2).trim();
        String query = info.substring(idx2 + 1).trim();
        DBInfoBasic dbInfo = new DBInfoBasic(url, driver, userID, password, query);
        ColData[] colData = DBAccess.retrieveResult(null, dbInfo, true, false, null, null, null, false);
        Report report = this.createReport(colData, template);
        report.sourceData = 1;
        report.dbInfo = dbInfo;
        return report;
    }

    private Report getJNDIInfo(String info, String template) throws Exception {
        int idx1 = info.indexOf(44);
        if (idx1 < 0) {
            throw new Exception("JNDI name not find");
        }
        String jndiName = info.substring(0, idx1).trim();
        int idx2 = info.indexOf(44, idx1 + 1);
        if (idx2 < 0) {
            throw new Exception("INITIAL_CONTEXT_FACTORY not find");
        }
        String ctxFactory = info.substring(idx1 + 1, idx2).trim();
        idx1 = info.indexOf(44, idx2 + 1);
        if (idx1 < 0) {
            throw new Exception("PROVIDER_URL not find");
        }
        String providerUrl = info.substring(idx2 + 1, idx1).trim();
        String query = info.substring(idx1 + 1).trim();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ctxFactory);
        env.put("java.naming.provider.url", providerUrl);
        DBInfoBasic dbInfo = new DBInfoBasic(jndiName, query, env);
        ColData[] colData = DBAccess.retrieveResult(null, dbInfo, true, false, null, null, null, false);
        Report report = this.createReport(colData, template);
        report.sourceData = 1;
        report.dbInfo = dbInfo;
        return report;
    }

    private Report createReport(ColData[] colData, String tpl) throws Exception {
        Report report = new Report(colData);
        report.createTable(this.getReportType(), this.getMapping());
        if (tpl != null) {
            LoadReport loadReport = new LoadReport();
            if (tpl.toLowerCase().endsWith(".pak")) {
                loadReport.getSubFilesTable().setTopName(tpl);
                loadReport.getSubFilesTable().setFileInMemEnabled(true);
            }
            report = loadReport.loadTemplateFromFile(tpl, report);
        }
        return report;
    }

    private int getReportType() throws Exception {
        String s = this.getParameter("ReportType");
        if (s == null) {
            return 0;
        }
        for (int i = 0; i < 5; ++i) {
            if (!s.equalsIgnoreCase(Report.REPORTTYPENAME[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("No such type : " + s);
    }

    private short getAggregation() throws Exception {
        String s = this.getParameter("Aggregation");
        if (s == null) {
            return 0;
        }
        for (int i = 0; i < IAggregateConstants.AGGR.length; ++i) {
            if (!s.equalsIgnoreCase(IAggregateConstants.AGGR[i])) continue;
            return (short)i;
        }
        throw new IllegalArgumentException("No such aggregation : " + s);
    }

    private ColInfo[] getMapping() throws Exception {
        int[] mapping = this.getIntArray(this.getParameter("ColInfo"));
        short aggregation = this.getAggregation();
        int[] rowBreak = this.getIntArray(this.getParameter("RowBreak"));
        int colBreak = this.getInt(this.getParameter("ColumnBreak"));
        int colBreakValue = this.getInt(this.getParameter("ColumnBreakValue"));
        int primaryKey = this.getInt(this.getParameter("PrimaryKey"));
        int[] masterField = this.getIntArray(this.getParameter("Master"));
        ColInfo[] colInfo = new ColInfo[mapping.length];
        for (int i = 0; i < mapping.length; ++i) {
            colInfo[i] = new ColInfo(mapping[i]);
            if (rowBreak != null) {
                for (int element : rowBreak) {
                    if (mapping[i] != element) continue;
                    colInfo[i].setRowBreak(true);
                }
            }
            if (masterField != null) {
                for (int element : masterField) {
                    if (mapping[i] != element) continue;
                    colInfo[i].setMaster(true);
                }
            }
            if (mapping[i] == primaryKey) {
                colInfo[i].setPrimaryKey(true);
            }
            if (mapping[i] == colBreak) {
                colInfo[i].setColumnBreak(true);
            }
            if (mapping[i] == colBreakValue) {
                colInfo[i].setColumnBreakValue(true);
            }
            colInfo[i].setAggregation(aggregation);
        }
        return colInfo;
    }

    private void setParameters(ReportCanvas reportCanvas) {
        reportCanvas.isRefreshEnabled = this.getBoolean("RefreshData", reportCanvas.isRefreshEnabled);
        reportCanvas.setExportEnabled(this.getBoolean("ExportEnabled", reportCanvas.isExportEnabled()));
    }

    private int getInt(String s) throws Exception {
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private int[] getIntArray(String s) throws Exception {
        int ttype;
        if (s == null) {
            return null;
        }
        Vector<Integer> vec = new Vector<Integer>();
        boolean i = false;
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        while ((ttype = st.nextToken()) != 10 && ttype != -1) {
            if (ttype == -2) {
                vec.addElement((int)st.nval);
                continue;
            }
            throw new IllegalArgumentException("Format shall be \"n1 n2 n3 n4 ...\" where n1, n2..  . are integers");
        }
        int[] tmp = new int[vec.size()];
        for (int j = 0; j < tmp.length; ++j) {
            tmp[j] = (Integer)vec.elementAt(j);
        }
        return tmp;
    }

    private boolean getBoolean(String s, boolean b) {
        if ((s = this.getParameter(s)) == null) {
            return b;
        }
        return s.equalsIgnoreCase("true");
    }

    private byte[] convertStringToByteArray(String the_string) throws Exception {
        StringTokenizer st = new StringTokenizer(the_string);
        int count = st.countTokens();
        byte[] byte_array = new byte[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte_array[i] = (byte)Integer.parseInt(st.nextToken());
            ++i;
        }
        return byte_array;
    }

    public void setReportMain(IReportMain reportMain) {
        this.reportMain = reportMain;
    }

    public void setMouseListener(MouseListener listener) {
        this.mouseListener = listener;
    }

    public void setMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = listener;
    }

    public void setCanvasBackgroundColor(Color color) {
        this.canvasBackgroundColor = color != null ? color : Color.white;
    }

    public void setMenuVisible(boolean b) {
        this.reportCanvas.menuVisible = b;
    }

    public void setSectionMenuVisible(boolean b) {
        this.reportCanvas.sectionMenuVisible = b;
    }

    public void setSectionoMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setSectionMenuItemVisible(menuItem, b);
    }

    public void setPageMenuVisible(boolean b) {
        this.reportCanvas.pageMenuVisible = b;
    }

    public void setPageMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setPageMenuItemVisible(menuItem, b);
    }

    public void setOutputMenuVisible(boolean b) {
        this.reportCanvas.outputMenuVisible = b;
    }

    public void setOutputMenuItemVisible(String[] menuItem, boolean b) {
        this.reportCanvas.setOutputMenuItemVisible(menuItem, b);
    }

    public void setBackMenuItemVisible(boolean b) {
        this.reportCanvas.backMenuItemVisible = b;
    }

    public void setRefreshMenuItemVisible(boolean b) {
        this.reportCanvas.refreshMenuItemVisible = b;
    }

    public void setGoToMenuItemVisible(boolean b) {
        this.reportCanvas.goToMenuItemVisible = b;
    }

    public void setZoomMenuItemVisible(boolean b) {
        this.reportCanvas.zoomMenuItemVisible = b;
    }

    public void setSortMenuVisible(boolean b) {
        this.reportCanvas.sortMenuVisible = b;
    }

    public void setMultiDrillDownVisible(boolean b) {
        this.reportCanvas.multiDrillDownVisible = b;
    }

    public void setToolBarMenuVisible(boolean b) {
        this.reportCanvas.toolbarMenuVisible = b;
    }

    public void setDynamicExport(boolean state, String serverName, int serverPort, String servletDirectory) {
        this.reportCanvas.setDynamicExport(state, serverName, serverPort, servletDirectory);
    }

    public void setExportServlet(String url) {
        this.reportCanvas.setExportServlet(url);
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            Viewer.deleteJNLPFile();
            Viewer.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    Viewer.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }
}

