/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import quadbase.reportdesigner.ReportViewer.CButton;
import quadbase.reportdesigner.ReportViewer.CDialog;
import quadbase.reportdesigner.ReportViewer.CLabel;
import quadbase.reportdesigner.ReportViewer.CMessageDialog;
import quadbase.reportdesigner.ReportViewer.CPanel;
import quadbase.reportdesigner.ReportViewer.CTextField;
import quadbase.reportdesigner.ReportViewer.ReportCanvas;

public class ZoomDialog
extends CDialog
implements ActionListener {
    CTextField zoomField;
    CButton okButton;
    CButton cancelButton;
    ReportCanvas canvas;

    public ZoomDialog(Object frame, ReportCanvas canvas) {
        super(frame, "Zoom ...", true);
        this.canvas = canvas;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        this.setBackground(Color.lightGray);
        CPanel p1 = new CPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new CLabel(" Zoom Factor (%) "));
        this.zoomField = new CTextField(this.canvas.getZoomFactor() + "", 3);
        p1.add(this.zoomField);
        this.okButton = new CButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new CButton("Cancel");
        this.cancelButton.addActionListener(this);
        CPanel p2 = new CPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.add("Center", p1);
        this.add("South", p2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String msg = null;
            try {
                int zoomFac = Integer.parseInt(this.zoomField.getText());
                if (zoomFac <= 0) {
                    zoomFac = 100;
                }
                if (zoomFac > 200) {
                    zoomFac = 200;
                }
                this.canvas.setZoomFactor(zoomFac);
                this.canvas.resetOffScreenImage();
                if (this.canvas.getReportToolBar() != null) {
                    this.canvas.getReportToolBar().updateZoomFactor();
                }
            }
            catch (Exception ex) {
                msg = "Zoom Factor Field : Invalid Input!";
            }
            if (msg != null) {
                CMessageDialog.showWarning(this, true, msg);
                return;
            }
            this.canvas.repaint();
        }
        this.setVisible(false);
        this.dispose();
    }
}

