/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import quadbase.common.util.internal.QbUtil;

public class CRuler
extends JPanel {
    public static final int SIZE = 19;
    private boolean isVertical;
    private boolean isMetric;
    private int MAXLENGTH;
    private int pageLength;
    private double zoomFactor;
    private int frontMargin;
    private int backMargin;

    public CRuler(boolean v, boolean m, int l, int pl, int fm, int bm, double zf) throws IllegalArgumentException {
        this.isVertical = v;
        this.isMetric = m;
        this.MAXLENGTH = l;
        this.pageLength = pl;
        this.zoomFactor = zf;
        this.frontMargin = fm;
        this.backMargin = bm;
        if (this.pageLength > this.MAXLENGTH) {
            throw new IllegalArgumentException("Max lenght must be greater than page length.");
        }
        if (this.isVertical) {
            this.setPreferredHeight(this.MAXLENGTH);
        } else {
            this.setPreferredWidth(this.MAXLENGTH);
        }
    }

    public void update(boolean v, boolean m, int l, int pl, int fm, int bm, double zf) throws IllegalArgumentException {
        this.isVertical = v;
        this.isMetric = m;
        this.MAXLENGTH = l;
        this.pageLength = pl;
        this.zoomFactor = zf;
        this.frontMargin = fm;
        this.backMargin = bm;
        if (this.pageLength > this.MAXLENGTH) {
            throw new IllegalArgumentException("Max lenght must be greater than page length.");
        }
        if (this.isVertical) {
            this.setPreferredHeight(this.MAXLENGTH);
        } else {
            this.setPreferredWidth(this.MAXLENGTH);
        }
        this.repaint();
    }

    public void setZoomFactor(double z) {
        if (z == this.zoomFactor) {
            return;
        }
        this.zoomFactor = z < 0.2 ? 0.2 : z;
    }

    void setMaxLength(int ml) {
        this.MAXLENGTH = ml;
        if (this.isVertical) {
            this.setPreferredHeight(this.MAXLENGTH);
        } else {
            this.setPreferredWidth(this.MAXLENGTH);
        }
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.repaint();
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(19, ph));
        this.setSize(new Dimension(19, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 19));
        this.setSize(new Dimension(pw, 19));
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        double i;
        String text;
        int increment = 2;
        increment = !this.isMetric ? (this.zoomFactor < 0.5 ? 20 : (this.zoomFactor < 0.75 ? 5 : 2)) : (this.zoomFactor < 0.5 ? 40 : (this.zoomFactor < 0.75 ? 20 : 5));
        int smallPageLength = this.pageLength - this.frontMargin - this.backMargin;
        int scaledFrontMargin = (int)((double)this.frontMargin * this.zoomFactor);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.gray);
        if (!this.isVertical) {
            g2.fillRect(0, 0, this.MAXLENGTH, 19);
        } else {
            g2.fillRect(0, 0, 19, this.MAXLENGTH);
        }
        g2.setColor(Color.lightGray);
        if (!this.isVertical) {
            g2.fillRect(50, 0, (int)((double)this.pageLength * this.zoomFactor), 19);
        } else {
            g2.fillRect(0, 50, 19, (int)((double)this.pageLength * this.zoomFactor));
        }
        g2.setColor(Color.white);
        if (!this.isVertical) {
            g2.fillRect(50 + scaledFrontMargin, 0, (int)((double)smallPageLength * this.zoomFactor), 19);
        } else {
            g2.fillRect(0, 50 + scaledFrontMargin, 19, (int)((double)smallPageLength * this.zoomFactor));
        }
        g2.setFont(new Font("SansSerif", 0, 10));
        g2.setColor(Color.black);
        String string = text = this.isMetric ? "cm" : "in";
        if (!this.isVertical) {
            g2.drawString(text, 50 + scaledFrontMargin + 2, 8);
        } else {
            g2.drawString(text, 1, 50 + scaledFrontMargin + 9);
        }
        text = null;
        int tickLength = 2;
        double multipler = 1.0;
        if (this.isMetric) {
            multipler = 2.54;
        }
        int end = (int)Math.ceil((double)(this.pageLength - this.frontMargin) / (double)QbUtil.toPixel(1.0) * multipler * 20.0);
        for (i = 1.0; i < (double)end; i += 1.0) {
            x = 0;
            x = 50 + scaledFrontMargin + QbUtil.toPixel(i / 20.0 / multipler * this.zoomFactor);
            if (i % (double)increment != 0.0) continue;
            if (i % 20.0 != 0.0) {
                tickLength = 2;
                text = null;
                if (!this.isVertical) {
                    g2.drawLine(x, 18, x, 19 - tickLength - 1);
                    continue;
                }
                g2.drawLine(18, x, 19 - tickLength - 1, x);
                continue;
            }
            tickLength = 4;
            text = Integer.toString((int)i / 20);
            if (!this.isVertical) {
                g2.drawString(text, x - 3, 8);
                g2.drawLine(x, 18, x, 19 - tickLength - 1);
                continue;
            }
            g2.drawString(text, 1, x + 3);
            g2.drawLine(18, x, 19 - tickLength - 1, x);
        }
        end = (int)Math.ceil((double)this.frontMargin / (double)QbUtil.toPixel(1.0) * multipler * 20.0);
        for (i = 1.0; i < (double)end; i += 1.0) {
            x = 0;
            x = 50 + scaledFrontMargin - QbUtil.toPixel(i / 20.0 / multipler * this.zoomFactor);
            if (i % (double)increment != 0.0) continue;
            if (i % 20.0 != 0.0) {
                tickLength = 2;
                text = null;
                if (!this.isVertical) {
                    g2.drawLine(x, 18, x, 19 - tickLength - 1);
                    continue;
                }
                g2.drawLine(18, x, 19 - tickLength - 1, x);
                continue;
            }
            tickLength = 4;
            text = Integer.toString((int)i / 20);
            if (!this.isVertical) {
                g2.drawString(text, x - 3, 8);
                g2.drawLine(x, 18, x, 19 - tickLength - 1);
                continue;
            }
            g2.drawString(text, 1, x + 3);
            g2.drawLine(18, x, 19 - tickLength - 1, x);
        }
    }
}

