/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportViewer.swing.CDialog;
import quadbase.reportdesigner.ReportViewer.swing.CMessageDialog;
import quadbase.reportdesigner.ReportViewer.swing.CPanel;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;

public class DrillDownValueSelectionDialog
extends CDialog
implements ActionListener {
    ReportCanvas canvas;
    Report report;
    Vector list = new Vector();
    Vector title = new Vector();
    JButton okBtn;
    JButton cancelBtn;
    boolean modified;

    public DrillDownValueSelectionDialog(ReportCanvas canvas) throws Exception {
        super((Object)ServerMessage.getFrame(), LanguageEncoder.getText("Drill-Down Value Selection Dialog"), true);
        this.canvas = canvas;
        this.report = canvas.getReport();
        this.init();
        this.setPosition();
    }

    public void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void init() throws Exception {
        int[] mapping;
        this.setBackground(Color.lightGray);
        CPanel mainPanel = new CPanel();
        mainPanel.setLayout(new BorderLayout());
        CPanel titlePanel = new CPanel();
        titlePanel.setLayout(new GridLayout(1, 0));
        CPanel listPanel = new CPanel();
        listPanel.setLayout(new GridLayout(1, 0));
        boolean multiDrillDown = false;
        DrillDownNode node = this.report.currentNode;
        Enumeration<TreeNode> en = node.children();
        DrillDownNode child = null;
        if (en.hasMoreElements() && (child = (DrillDownNode)en.nextElement()).isMultiValueParameter(this.report.getSubFilesTable()) && !en.hasMoreElements()) {
            multiDrillDown = true;
        }
        if (!multiDrillDown) {
            throw new Exception("Cannot select multiple drill-down values! The report either doesn't contain a drilldown report\n or the drill-down report is not based on a multiple value parameter");
        }
        for (int element : mapping = child.getColumnMapping()) {
            this.title.addElement(this.report.colData[this.report.colInfo[element].getMapping()].getName());
            Vector<Object> listData = this.report.colData[this.report.colInfo[element].getMapping()].getDistinctValue();
            this.list.addElement(new JList<Object>(listData));
        }
        for (int i = 0; i < this.list.size(); ++i) {
            JLabel label = new JLabel((String)this.title.elementAt(i));
            titlePanel.add(label);
            JScrollPane scrollPane = new JScrollPane((JList)this.list.elementAt(i));
            listPanel.add(scrollPane);
        }
        CPanel buttonPanel = new CPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okBtn);
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        mainPanel.add("Center", titlePanel);
        mainPanel.add("South", listPanel);
        this.setLayout(this, new BorderLayout());
        this.add("Center", mainPanel);
        this.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            try {
                Vector<QueryInParamSet> vector = new Vector<QueryInParamSet>();
                Object[] obj = new Object[this.list.size()];
                for (int i = 0; i < this.list.size(); ++i) {
                    Object[] object = ((JList)this.list.elementAt(i)).getSelectedValues();
                    if (object == null || object.length == 0) {
                        String message = LanguageEncoder.getText("no value is selected");
                        CMessageDialog.showWarning(ServerMessage.getFrame(), true, message);
                        return;
                    }
                    Vector<Object> vec = new Vector<Object>();
                    for (Object element : object) {
                        vec.addElement(element);
                    }
                    obj[i] = vec;
                }
                vector.addElement((QueryInParamSet)obj);
                LoadReport lr = new LoadReport();
                if (this.report != null) {
                    lr.setSecurityLevel(this.report.getPreviewSecurityLevel());
                }
                String filename = ((DrillDownNode)this.report.currentNode.children().nextElement()).getFileName();
                Report rpt = lr.loadReportFromFile(filename, vector, true);
                rpt.currentNode = this.report.currentNode.getChildAt(0);
                this.canvas.setReport(rpt);
                this.canvas.repaint();
                this.modified = true;
                this.canvas.linkHistory.addElement(this.report);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }
}

