/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportViewer.swing.CBrowseDialog;
import quadbase.reportdesigner.ReportViewer.swing.CButton;
import quadbase.reportdesigner.ReportViewer.swing.CDialog;
import quadbase.reportdesigner.ReportViewer.swing.CFileChooser;
import quadbase.reportdesigner.ReportViewer.swing.CLabel;
import quadbase.reportdesigner.ReportViewer.swing.CPanel;
import quadbase.reportdesigner.ReportViewer.swing.CTextField;

public class OpenSaveDialog
extends CDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(OpenSaveDialog.class.getName());
    CTextField tf;
    CButton browseButton;
    CButton okButton;
    CButton cancelButton;
    CFileChooser fileChooser;
    CBrowseDialog browseDialog;
    Object frame;
    String selectedFile = "";
    String currentDir = "";
    String ext = "";

    public OpenSaveDialog(Object frame, String title, String fileName, String ext) {
        super(frame, title, true);
        this.selectedFile = fileName;
        this.frame = this.getFrame();
        this.ext = ext;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        this.setBackground(Color.lightGray);
        this.tf = this.selectedFile != null ? new CTextField(this.selectedFile, 25) : new CTextField(25);
        this.tf.addActionListener(this);
        CPanel p1 = new CPanel();
        p1.setLayout(new FlowLayout(1));
        p1.add(new CLabel("Name "));
        p1.add(this.tf);
        this.browseButton = new CButton("Browse...");
        this.browseButton.addActionListener(this);
        this.okButton = new CButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new CButton("Cancel");
        this.cancelButton.addActionListener(this);
        CPanel p2 = new CPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.browseButton);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.add("Center", p1);
        this.add("South", p2);
        this.pack();
        this.tf.requestFocus();
    }

    private String loadFile() {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new CFileChooser(this.frame, "Select file");
                this.fileChooser.setDirectory(this.currentDir);
            }
            this.fileChooser.show();
            if (this.fileChooser.getFile() == null) {
                return null;
            }
            this.currentDir = this.fileChooser.getDirectory();
            return this.fileChooser.getDirectory() + this.fileChooser.getFile();
        }
        if (this.browseDialog == null) {
            this.browseDialog = new CBrowseDialog(this.frame, this.currentDir, null);
        }
        this.browseDialog.show();
        if (this.browseDialog.getSelectedFile() != null) {
            this.currentDir = this.browseDialog.getCurrentDirectory();
        }
        return this.browseDialog.getSelectedFile();
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.tf.getText();
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                if (fileText.endsWith("/")) {
                    int pos = Math.max(filename.lastIndexOf(92), filename.lastIndexOf(47));
                    fileText = fileText + filename.substring(pos + 1, filename.length());
                }
                this.tf.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.cancelButton) {
            this.selectedFile = null;
        } else {
            if (filename == null || filename.equals("")) {
                String msg = LanguageEncoder.getText("Invalid Export File Location");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (filename.endsWith("/") || filename.endsWith("\\")) {
                String msg = LanguageEncoder.getText("Please enter a file name");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (!filename.toUpperCase().endsWith(this.ext.toUpperCase())) {
                filename = filename + this.ext;
            }
            FileInfo f = new FileInfo(filename);
            try {
                String msg;
                if (f.exists()) {
                    msg = LanguageEncoder.getText("File exists already!  Do you want to overwrite the file?");
                    JMessageDialog dialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg, 2);
                    int response = dialog.getResponse();
                    if (response == 5) {
                        return;
                    }
                }
                if (!f.isValidFile()) {
                    msg = LanguageEncoder.getText("The filename is not valid, please reenter.");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
            }
            catch (Exception e1) {
                LOGGER.log(Level.WARNING, "Failed to connect server", e1);
            }
            this.selectedFile = filename;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void setCurrentDirectory(String currentDir) {
        this.currentDir = currentDir;
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }
}

