/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.ReportViewer.swing.ViewerMessage;
import quadbase.reportdesigner.report.Report;

public class ParamThread
extends Thread {
    Socket socket;
    ReportCanvas canvas;
    boolean pleasestop = false;

    public ParamThread(Socket socket, ReportCanvas canvas) {
        this.socket = socket;
        this.canvas = canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DataOutputStream out;
        DataInputStream in;
        Report report = this.canvas.getReport();
        try {
            in = new DataInputStream(this.socket.getInputStream());
            out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException ex) {
            System.out.println("Fail to get input stream : " + ex.toString());
            return;
        }
        ViewerMessage message = new ViewerMessage();
        try {
            block24: while (!this.pleasestop) {
                message.readMessage(in, report.getRecordDataType());
                switch (message.command) {
                    case 1: {
                        try {
                            report.setRecord(message.record, message.recordno);
                        }
                        catch (IllegalArgumentException ex) {
                            out.writeInt(1);
                            continue block24;
                        }
                        out.writeInt(0);
                        continue block24;
                    }
                    case 2: {
                        report.addRecord(message.record);
                        out.writeInt(0);
                        continue block24;
                    }
                    case 3: {
                        if (report.removeRecord(message.recordno)) {
                            out.writeInt(0);
                            continue block24;
                        }
                        out.writeInt(1);
                        continue block24;
                    }
                    case 0: {
                        this.canvas.setRepaint(report);
                        this.canvas.repaint();
                        out.writeInt(0);
                        continue block24;
                    }
                    case 6: {
                        int[] dtype = report.getRecordDataType();
                        out.writeInt(dtype.length);
                        IOUtil.writeInts(out, dtype, dtype.length);
                        continue block24;
                    }
                    case 5: {
                        out.writeInt(report.getDataRowSize());
                        continue block24;
                    }
                    case 4: {
                        Object[] rec = report.getRecord(message.recordno);
                        if (rec != null) {
                            out.writeBoolean(true);
                            Object[] objectArray = rec;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block24;
                                Object element = objectArray[n2];
                                DataType.write(out, element);
                                ++n2;
                            }
                        }
                        out.writeBoolean(false);
                        continue block24;
                    }
                }
            }
            return;
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void pleaseStop() {
        this.interrupt();
    }
}

