/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportViewer.swing.CMenu;
import quadbase.reportdesigner.ReportViewer.swing.CMenuItem;
import quadbase.reportdesigner.ReportViewer.swing.CPopupMenu;
import quadbase.reportdesigner.ReportViewer.swing.GoToDialog;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.ReportViewer.swing.ZoomDialog;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IReportMain;

class PopupMenuForReport
extends CPopupMenu
implements ActionListener {
    ReportCanvas reportCanvas;
    CMenu pageMenu;
    CMenu sectionMenu;
    CMenu outputMenu;
    CMenu serverMenu;
    CMenu clientMenu;
    CMenu sortMenu;
    CMenu sortMenu2;
    int[] typeMap;
    private boolean isReady = false;
    private IReportMain reportMain;
    private Report report;
    boolean isAsc;
    Vector<ReportColumn> columnList;

    public PopupMenuForReport(ReportCanvas reportCanvas) {
        this.reportCanvas = reportCanvas;
        this.addMenu();
    }

    public PopupMenuForReport(ReportCanvas reportCanvas, IReportMain reportMain, Report report) {
        this.reportCanvas = reportCanvas;
        this.reportMain = reportMain;
        this.report = report;
        this.addMenu();
    }

    public void addMenu() {
        this.isReady = false;
        if (this.reportCanvas.sectionMenuVisible) {
            this.addSectionMenu();
        }
        if (this.reportCanvas.pageMenuVisible) {
            this.addPageMenu();
        }
        if (this.reportCanvas.isExportEnabled() && this.reportCanvas.outputMenuVisible && this.reportMain == null) {
            this.addOutputMenu();
        }
        if (this.reportCanvas.isRefreshEnabled() && this.reportCanvas.refreshMenuItemVisible) {
            this.addRefreshMenuItem();
        }
        if (this.reportCanvas.backMenuItemVisible) {
            this.addBackMenuItem();
        }
        if (this.reportCanvas.goToMenuItemVisible) {
            this.addGoToMenuItem();
        }
        if (this.reportCanvas.zoomMenuItemVisible) {
            this.addZoomMenuItem();
        }
        this.addSeparator();
        if (this.reportCanvas.sortMenuVisible) {
            this.addSortMenu();
        }
        if (this.reportCanvas.multiDrillDownVisible) {
            this.addMultiDrillDownMenuItem();
        }
        if (this.reportCanvas.toolbarMenuVisible && this.reportCanvas.getToolbarContainer() != null) {
            this.addSeparator();
            String rptToolBar = " Report Toolbar";
            rptToolBar = this.reportCanvas.isReportToolBarVisible() ? "Hide" + rptToolBar : "Show" + rptToolBar;
            this.add(this.newMenuItem(rptToolBar));
        }
        if (!(ServerMessage.getApplet() != null || this.reportCanvas.invisibleOutputMenuItem != null && this.reportCanvas.invisibleOutputMenuItem.contains("Print"))) {
            this.addSeparator();
            this.add(this.newMenuItem("Print"));
        }
        this.isReady = true;
    }

    void addSortMenu() {
        this.sortMenu = new CMenu("Sort by (ascend)");
        this.sortMenu2 = new CMenu("Sort by (descend)");
        for (int i = 0; i < 2; ++i) {
            ColInfo[] colInfo;
            String actionCmd;
            CMenu menu;
            if (i == 0) {
                menu = this.sortMenu;
                actionCmd = "asc";
            } else {
                menu = this.sortMenu2;
                actionCmd = "des";
            }
            menu.removeAll();
            Vector<ReportTable> vector = this.report.getReportTables();
            this.columnList = new Vector();
            if (this.report.getReportType() != 2) {
                for (int k = 0; k < vector.size(); ++k) {
                    ReportTable reporttable = vector.elementAt(k);
                    for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                        if (!reporttable.getColumn(i1).isVisible() && (this.report.getReportType() != 3 || !this.report.colInfo[i1].isMaster())) continue;
                        ReportTable tbl = reporttable;
                        while (tbl instanceof ReportTreeTable && ((ReportTreeTable)tbl).getSubTable() != null && ((ReportTreeTable)tbl).getSubTable().size() > 0) {
                            tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                        }
                        if (tbl.getColumn(i1).getData(0) instanceof ReportImage || tbl.getColumn(i1).getData(0) instanceof ReportDocument) continue;
                        this.columnList.addElement(reporttable.getColumn(i1));
                        menu.add(this.newMenuItem(reporttable.getColumn(i1).getText() + " Column", actionCmd + " " + reporttable.getColumn(i1).getText() + " Column"));
                    }
                }
                continue;
            }
            for (ColInfo element : colInfo = this.report.colInfo) {
                if (!element.isVisible() || !element.isRowBreak()) continue;
                menu.add(this.newMenuItem(element.getName() + " Column", actionCmd + " " + element.getName() + " Column"));
            }
        }
        this.sortMenu.addActionListener(this);
        this.sortMenu2.addActionListener(this);
        this.add(this.sortMenu);
        this.add(this.sortMenu2);
    }

    void addZoomMenuItem() {
        if (this.reportMain != null) {
            return;
        }
        this.addSeparator();
        CMenuItem f2 = this.newMenuItem("Zoom ...");
        this.add(f2);
    }

    void addPageMenu() {
        if (!this.reportCanvas.isPrevPageEnabled() && !this.reportCanvas.isNextPageEnabled()) {
            return;
        }
        this.pageMenu = new CMenu("Page");
        CMenuItem f1 = this.newMenuItem("First Page");
        f1.setEnabled(this.reportCanvas.isPrevPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("First Page")) {
            this.pageMenu.add(f1);
        }
        CMenuItem c1 = this.newMenuItem("Previous Page");
        c1.setEnabled(this.reportCanvas.isPrevPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Previous Page")) {
            this.pageMenu.add(c1);
        }
        CMenuItem c2 = this.newMenuItem("Next Page");
        c2.setEnabled(this.reportCanvas.isNextPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Next Page")) {
            this.pageMenu.add(c2);
        }
        CMenuItem f2 = this.newMenuItem("Last Page");
        f2.setEnabled(this.reportCanvas.isNextPageEnabled());
        if (this.reportCanvas.invisiblePageMenuItem == null || !this.reportCanvas.invisiblePageMenuItem.contains("Last Page")) {
            this.pageMenu.add(f2);
        }
        this.add(this.pageMenu);
    }

    void addSectionMenu() {
        try {
            if (!this.reportCanvas.isPrevSectionEnabled() && !this.reportCanvas.isNextSectionEnabled()) {
                return;
            }
            this.sectionMenu = new CMenu("Section");
            CMenuItem f1 = this.newMenuItem("First Section");
            f1.setEnabled(this.reportCanvas.isPrevSectionEnabled());
            if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("First Section")) {
                this.sectionMenu.add(f1);
            }
            CMenuItem c1 = this.newMenuItem("Previous Section");
            c1.setEnabled(this.reportCanvas.isPrevSectionEnabled());
            if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Previous Section")) {
                this.sectionMenu.add(c1);
            }
            CMenuItem c2 = this.newMenuItem("Next Section");
            c2.setEnabled(this.reportCanvas.isNextSectionEnabled());
            if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Next Section")) {
                this.sectionMenu.add(c2);
            }
            CMenuItem f2 = this.newMenuItem("Last Section");
            f2.setEnabled(this.reportCanvas.isNextSectionEnabled());
            if (this.reportCanvas.invisibleSectionMenuItem == null || !this.reportCanvas.invisibleSectionMenuItem.contains("Last Section")) {
                this.sectionMenu.add(f2);
            }
            this.add(this.sectionMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addOutputMenu() {
        this.outputMenu = new CMenu("Output");
        this.add(this.outputMenu);
        this.serverMenu = new CMenu("Server");
        this.addOutputMenu(this.serverMenu, " [Server]");
        this.outputMenu.add(this.serverMenu);
        if (ServerMessage.getApplet() != null && this.reportMain == null && this.reportCanvas.getExportServlet() != null && this.reportCanvas.isDynamicExport) {
            this.clientMenu = new CMenu("Client");
            this.addOutputMenu(this.clientMenu, " [Client]");
            this.outputMenu.add(this.clientMenu);
        }
    }

    void addOutputMenu(CMenu outputMenu, String appendCommand) {
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Single Page)")) {
            outputMenu.add(this.newMenuItem("Generate DHTML (Single Page)", "Generate DHTML (Single Page)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Paginated Single Page)")) {
            outputMenu.add(this.newMenuItem("Generate DHTML (Paginated Single Page)", "Generate DHTML (Paginated Single Page)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate DHTML (Multiple Pages)")) {
            outputMenu.add(this.newMenuItem("Generate DHTML (Multiple Pages)", "Generate DHTML (Multiple Pages)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate PDF")) {
            outputMenu.add(this.newMenuItem("Generate PDF", "Generate PDF" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate CSV")) {
            outputMenu.add(this.newMenuItem("Generate CSV", "Generate CSV" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate Excel (XLS)")) {
            outputMenu.add(this.newMenuItem("Generate Excel (XLS)", "Generate Excel (XLS)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate Excel 2007 (XLSX)")) {
            outputMenu.add(this.newMenuItem("Generate Excel 2007 (XLSX)", "Generate Excel 2007 (XLSX)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate TXT")) {
            outputMenu.add(this.newMenuItem("Generate TXT", "Generate TXT" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate RTF")) {
            outputMenu.add(this.newMenuItem("Generate RTF", "Generate RTF" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate XML (Data + Format)")) {
            outputMenu.add(this.newMenuItem("Generate XML (Data + Format)", "Generate XML (Data + Format)" + appendCommand));
        }
        if (this.reportCanvas.invisibleOutputMenuItem == null || !this.reportCanvas.invisibleOutputMenuItem.contains("Generate XML (Pure Data)")) {
            outputMenu.add(this.newMenuItem("Generate XML (Pure Data)", "Generate XML (Pure Data)" + appendCommand));
        }
        this.add(outputMenu);
    }

    void addBackMenuItem() {
        if (this.reportCanvas.countLinkHistory() > 0) {
            this.addSeparator();
            this.add(this.newMenuItem("Back"));
        }
    }

    void addRefreshMenuItem() {
        if (!this.reportCanvas.isRefreshEnabled) {
            return;
        }
        this.addSeparator();
        this.add(this.newMenuItem("Refresh"));
    }

    void addGoToMenuItem() {
        if (!(this.reportCanvas.isPrevPageEnabled() || this.reportCanvas.isNextPageEnabled() || this.reportCanvas.isPrevSectionEnabled() || this.reportCanvas.isNextSectionEnabled())) {
            return;
        }
        this.addSeparator();
        this.add(this.newMenuItem("Go To ..."));
    }

    void addMultiDrillDownMenuItem() {
        DrillDownNode node = this.report.currentNode;
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> en = node.children();
        if (en.hasMoreElements() && ((DrillDownNode)en.nextElement()).isMultiValueParameter(this.report.getSubFilesTable()) && !en.hasMoreElements()) {
            this.addSeparator();
            this.add(this.newMenuItem("Select Multiple Drill-Down Values..."));
        }
    }

    CMenuItem newMenuItem(String s) {
        return this.newMenuItem(s, s);
    }

    CMenuItem newMenuItem(String s, String cmd) {
        CMenuItem m = new CMenuItem(s);
        m.setActionCommand(cmd);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menustr = e.getActionCommand();
        if (menustr.endsWith(" [Server]")) {
            this.reportCanvas.setExportTarget(true);
            menustr = menustr.substring(0, menustr.length() - 9);
        } else if (menustr.endsWith(" [Client]")) {
            this.reportCanvas.setExportTarget(false);
            menustr = menustr.substring(0, menustr.length() - 9);
        }
        if (menustr.equals("Next Page")) {
            if (this.reportMain == null) {
                this.reportCanvas.setPage(this.reportCanvas.getPage() + 1);
            } else {
                this.reportMain.goToNextPage();
            }
        } else if (menustr.equals("Previous Page")) {
            if (this.reportMain == null) {
                this.reportCanvas.setPage(this.reportCanvas.getPage() - 1);
            } else {
                this.reportMain.goToPreviousPage();
            }
        } else if (menustr.equals("Next Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getSection() + 1);
        } else if (menustr.equals("Previous Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getSection() - 1);
        } else if (menustr.equals("First Page")) {
            if (this.reportMain == null) {
                this.reportCanvas.setPage(1);
            } else {
                this.reportMain.goToFirstPage();
            }
        } else if (menustr.equals("Last Page")) {
            if (this.reportMain == null) {
                this.reportCanvas.setPage(this.reportCanvas.getTotalPages());
            } else {
                this.reportMain.goToLastPage();
            }
        } else if (menustr.equals("First Section")) {
            this.reportCanvas.setSection(1);
        } else if (menustr.equals("Last Section")) {
            this.reportCanvas.setSection(this.reportCanvas.getTotalSections());
        } else if (menustr.equals("Go To ...")) {
            if (this.reportMain == null) {
                new GoToDialog((Object)ServerMessage.getFrame(), this.reportCanvas).setVisible(true);
            } else {
                this.reportMain.goTo();
            }
        } else if (menustr.equals("Zoom ...")) {
            new ZoomDialog((Object)ServerMessage.getFrame(), this.reportCanvas).setVisible(true);
        } else if (menustr.equals("Generate DHTML (Single Page)")) {
            this.reportCanvas.export(4);
        } else if (menustr.equals("Generate DHTML (Paginated Single Page)")) {
            this.reportCanvas.setExportToSingleWPagination(true);
            this.reportCanvas.export(4);
        } else if (menustr.equals("Generate DHTML (Multiple Pages)")) {
            this.reportCanvas.setExportToMultiPages(true);
            this.reportCanvas.export(4);
        } else if (menustr.equals("Generate PDF")) {
            this.reportCanvas.export(2);
        } else if (menustr.equals("Generate CSV")) {
            this.reportCanvas.export(3);
        } else if (menustr.equals("Generate Excel (XLS)")) {
            this.reportCanvas.export(9);
        } else if (menustr.equals("Generate Excel 2007 (XLSX)")) {
            this.reportCanvas.export(17);
        } else if (menustr.equals("Generate TXT")) {
            this.reportCanvas.export(5);
        } else if (menustr.equals("Generate RTF")) {
            this.reportCanvas.export(13);
        } else if (menustr.equals("Generate XML (Data + Format)")) {
            this.reportCanvas.export(6);
        } else if (menustr.equals("Generate XML (Pure Data)")) {
            this.reportCanvas.export(7);
        } else if (menustr.equals("Print")) {
            this.reportCanvas.print();
        } else if (menustr.equals("Refresh")) {
            if (this.reportMain == null) {
                this.reportCanvas.do_Reload();
            } else {
                this.reportMain.do_Refresh();
            }
        } else if (menustr.equals("Back")) {
            if (this.reportCanvas.countLinkHistory() > 0) {
                this.reportCanvas.goBackHyperLink();
            }
        } else if (menustr.equals("Hide Report Toolbar")) {
            this.reportCanvas.setReportToolBarVisible(false);
        } else if (menustr.equals("Show Report Toolbar")) {
            this.reportCanvas.setReportToolBarVisible(true);
        } else if (menustr.equals("Select Multiple Drill-Down Values...")) {
            try {
                this.reportCanvas.setDrillDownParameterValues();
            }
            catch (Exception exception) {}
        } else if (menustr.endsWith(" Column")) {
            ReportTable table = this.report.getReportTables().elementAt(0);
            for (int i = 0; i < table.getColumnCount(); ++i) {
                ReportColumn reportcolumn = table.getColumn(i);
                if (menustr.equals("asc " + reportcolumn.getText() + " Column") || menustr.equals("asc " + this.report.colInfo[i].getName() + " Column")) {
                    table.createIndexArray(i, true, this.report, 0);
                    if (this.reportMain != null) {
                        this.reportMain.setUpdateReport();
                    }
                    this.reportCanvas.setRepaint(this.report);
                    return;
                }
                if (!menustr.equals("des " + reportcolumn.getText() + " Column") && !menustr.equals("des " + this.report.colInfo[i].getName() + " Column")) continue;
                table.createIndexArray(i, false, this.report, 0);
                if (this.reportMain != null) {
                    this.reportMain.setUpdateReport();
                }
                this.reportCanvas.setRepaint(this.report);
                return;
            }
        }
        this.reportCanvas.repaint();
        this.reportCanvas.setExportToMultiPages(false);
        this.reportCanvas.setExportToSingleWPagination(false);
    }

    void setReportMain(IReportMain reportMain) {
        this.reportMain = reportMain;
    }
}

