/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.ReportViewer.swing;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportViewer.swing.CButton;
import quadbase.reportdesigner.ReportViewer.swing.CComboBox;
import quadbase.reportdesigner.ReportViewer.swing.CPanel;
import quadbase.reportdesigner.ReportViewer.swing.CSpinBox;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;

public class ReportToolBar
extends CPanel
implements ActionListener {
    private CButton firstPageBut;
    private CButton lastPageBut;
    private CButton prevPageBut;
    private CButton nextPageBut;
    private CButton sortBut;
    private CButton zoomBut;
    private CButton backBut;
    private CSpinBox zoomFactor;
    Vector columnList;
    private CComboBox comboListBut;
    private CComboBox dirBut;
    private ReportCanvas reportCanvas;
    private Report report;
    private CPanel panel1;

    public ReportToolBar(ReportCanvas reportCanvas) {
        this.reportCanvas = reportCanvas;
        this.report = reportCanvas.getReport();
        this.setLayout(new GridLayout(2, 1, 0, 0));
        this.panel1 = new CPanel();
        this.panel1.setLayout(new GridLayout(1, 0, 0, 0));
        this.comboListBut = this.getColumnList();
        this.dirBut = this.getDirectionList();
        this.panel1.add(this.comboListBut);
        this.panel1.add(this.dirBut);
        this.sortBut = new CButton("Sort");
        this.panel1.add(this.sortBut);
        this.sortBut.addActionListener(this);
        this.zoomFactor = new CSpinBox(1, 200, 1);
        this.panel1.add(this.zoomFactor);
        this.zoomFactor.setValue(reportCanvas.getZoomFactor());
        this.zoomBut = new CButton("Zoom");
        this.panel1.add(this.zoomBut);
        this.zoomBut.addActionListener(this);
        if (reportCanvas.isBackButtonVisible()) {
            this.backBut = new CButton("Back");
            this.panel1.add(this.backBut);
            this.backBut.addActionListener(this);
        }
        this.firstPageBut = new CButton("<< First");
        this.firstPageBut.addActionListener(this);
        this.prevPageBut = new CButton("< Previous");
        this.prevPageBut.addActionListener(this);
        this.nextPageBut = new CButton("Next >");
        this.nextPageBut.addActionListener(this);
        this.lastPageBut = new CButton("Last >>");
        this.lastPageBut.addActionListener(this);
        CPanel panel2 = new CPanel();
        panel2.setLayout(new GridLayout(1, 4, 0, 0));
        panel2.add(this.firstPageBut);
        panel2.add(this.prevPageBut);
        panel2.add(this.nextPageBut);
        panel2.add(this.lastPageBut);
        this.add(this.panel1);
        this.add(panel2);
        this.setEnabled();
    }

    CComboBox getDirectionList() {
        CComboBox box = new CComboBox();
        box.addItem("ASC");
        box.addItem("DES");
        return box;
    }

    CComboBox getColumnList() {
        CComboBox box = new CComboBox();
        Vector<ReportTable> vector = this.report.getReportTables();
        this.columnList = new Vector();
        if (this.report.getReportType() != 2) {
            for (int k = 0; k < vector.size(); ++k) {
                ReportTable reporttable = vector.elementAt(k);
                for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                    if (!reporttable.getColumn(i1).isVisible() && (this.report.getReportType() != 3 || !this.report.colInfo[i1].isMaster())) continue;
                    ReportTable tbl = reporttable;
                    while (tbl instanceof ReportTreeTable && ((ReportTreeTable)tbl).getSubTable() != null && ((ReportTreeTable)tbl).getSubTable().size() > 0) {
                        tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                    }
                    if (tbl.getColumn(i1).getData(0) instanceof ReportImage || tbl.getColumn(i1).getData(0) instanceof ReportDocument) continue;
                    this.columnList.addElement(reporttable.getColumn(i1));
                    box.addItem(reporttable.getColumn(i1).getText() + " Column");
                }
            }
        } else {
            ColInfo[] colInfo;
            for (ColInfo element : colInfo = this.report.colInfo) {
                if (!element.isVisible() || !element.isRowBreak()) continue;
                box.addItem(element.getName() + " Column");
            }
        }
        return box;
    }

    void updateZoomFactor() {
        this.zoomFactor.setValue(this.reportCanvas.getZoomFactor());
    }

    public void setEnabled() {
        if (this.backBut == null && this.reportCanvas.isBackButtonVisible()) {
            this.backBut = new CButton("Back");
            this.panel1.add(this.backBut);
            this.backBut.addActionListener(this);
            if (this.reportCanvas.isReportToolBarVisible()) {
                this.reportCanvas.setReportToolBarVisible(false);
                this.reportCanvas.setReportToolBarVisible(true);
            }
        }
        if (this.backBut != null) {
            this.backBut.setEnabled(this.reportCanvas.countLinkHistory() > 0);
        }
        this.lastPageBut.setEnabled(true);
        this.nextPageBut.setEnabled(this.reportCanvas.isNextAvailPageEnabled());
        this.prevPageBut.setEnabled(this.reportCanvas.isPrevAvailPageEnabled());
        this.firstPageBut.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.firstPageBut) {
            this.reportCanvas.setPage(1);
            this.reportCanvas.setSection(1);
        } else if (e.getSource() == this.lastPageBut) {
            this.reportCanvas.setPage(this.reportCanvas.getTotalPages());
            this.reportCanvas.setSection(this.reportCanvas.getTotalSections());
        } else if (e.getSource() == this.prevPageBut) {
            this.reportCanvas.goToPreviousAvailPage();
        } else if (e.getSource() == this.backBut) {
            this.reportCanvas.goBackHyperLink();
        } else if (e.getSource() == this.nextPageBut) {
            this.reportCanvas.goToNextAvailPage();
        } else if (e.getSource() == this.sortBut) {
            ReportTable table = this.report.getReportTables().elementAt(0);
            String colName = this.comboListBut.getSelectedItem().toString();
            int colIndex = 0;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                ReportColumn reportcolumn = table.getColumn(i);
                if (!colName.equals(reportcolumn.getText() + " Column") && !colName.equals(this.report.colInfo[i].getName() + " Column")) continue;
                colIndex = i;
                break;
            }
            boolean isAsc = this.dirBut.getSelectedIndex() == 0;
            table.createIndexArray(colIndex, isAsc, this.report, 0);
            if (this.reportCanvas.getReportMain() != null) {
                this.reportCanvas.getReportMain().setUpdateReport();
            }
            this.reportCanvas.setRepaint(this.report);
        } else if (e.getSource() == this.zoomBut) {
            int zoomFac = this.zoomFactor.getValue();
            if (zoomFac <= 0) {
                zoomFac = 100;
            }
            if (zoomFac > 200) {
                zoomFac = 200;
            }
            this.reportCanvas.setZoomFactor(zoomFac);
            this.reportCanvas.resetOffScreenImage();
        }
        this.reportCanvas.repaint();
        this.setEnabled();
    }
}

