/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.BarcodeFormat;

public class AlphanumericBarcodeDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(AlphanumericBarcodeDialog.class.getName());
    BarcodeFormat bf;
    JComboBox choiceBarcodeType;
    JButton btnOk;
    JButton btnCancel;
    int[] supportedFormat = new int[]{0, 1, 3, 4, 5, 13, 14, 15, 16, 21, 22, 23, 25, 26, 27, 28, 29, 30};

    public AlphanumericBarcodeDialog(JFrame frame, String title, BarcodeFormat bf) {
        super(frame, title, true);
        this.init(bf);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(BarcodeFormat bf) {
        this.bf = bf;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        plMain.setLayout(new BorderLayout());
        this.choiceBarcodeType = new JComboBox();
        plMain.add("North", this.labelComponent(LanguageEncoder.getText("BarCode type is:"), this.choiceBarcodeType));
        for (int element : this.supportedFormat) {
            this.choiceBarcodeType.addItem(BarcodeFormat.BARCODE_NAME[element]);
        }
        this.choiceBarcodeType.setSelectedIndex(this.getBarcodeIndex());
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
    }

    private int getBarcodeIndex() {
        if (this.bf == null) {
            return 0;
        }
        int type = this.bf.getformat();
        for (int i = 0; i < this.supportedFormat.length; ++i) {
            if (type != this.supportedFormat[i]) continue;
            return i;
        }
        return 0;
    }

    private int getBarcodeType() {
        return this.supportedFormat[this.choiceBarcodeType.getSelectedIndex()];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                this.bf = new BarcodeFormat(this.getBarcodeType());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Invalid barcode type", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Barcode type is not supported!"));
                return;
            }
        }
        this.dispose();
    }

    BarcodeFormat getFormat() {
        return this.bf;
    }

    private JPanel labelComponent(String label, Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new JLabel(label));
        panel.add(component);
        return panel;
    }
}

