/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ApplyTemplateDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ApplyTemplateDialog.class.getName());
    JTextField tf;
    JButton browseButton;
    JButton okButton;
    JButton cancelButton;
    JFileChooser fileChooser;
    BrowseDialog browseDialog;
    String selectedFile = "";
    JFrame frame;
    String[] ext;
    String currentDir = null;
    String defaultDir = "";
    boolean showBrowseButton = true;
    JCheckBox applyFormula;
    JCheckBox applyEmptySec;
    boolean isFormulaApplied = false;
    boolean isEmptySectionApplied = false;
    BrowseDirectories browseDir;
    boolean windowClosed = true;

    public ApplyTemplateDialog(JFrame frame, String title, String fileName, String[] ext) {
        this(frame, title, fileName, ext, null);
    }

    public ApplyTemplateDialog(JFrame frame, String title, String fileName, String[] ext, String currentDir) {
        this(frame, title, fileName, ext, currentDir, true);
    }

    public ApplyTemplateDialog(JFrame frame, String title, String fileName, String[] ext, String currentDir, boolean showBrowseButton) {
        super(frame, title, true);
        this.frame = frame;
        this.ext = ext;
        this.showBrowseButton = showBrowseButton;
        this.currentDir = currentDir;
        this.selectedFile = fileName;
        if (currentDir != null) {
            this.defaultDir = (currentDir = currentDir.replace('\\', '/')).endsWith("/") ? currentDir : currentDir + "/";
        }
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.tf = this.selectedFile != null && !this.selectedFile.equals("") ? new JTextField(this.selectedFile, 25) : new JTextField(this.defaultDir, 25);
        this.tf.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(1));
        p1.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        p1.add(this.tf);
        if (this.showBrowseButton) {
            this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
            this.browseButton.addActionListener(this);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.applyFormula = new JCheckBox(LanguageEncoder.getText("Apply Formula And Script"), false);
        this.applyEmptySec = new JCheckBox(LanguageEncoder.getText("Apply Empty Section"), false);
        p2.add(this.applyFormula);
        p2.add(this.applyEmptySec);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(2));
        if (this.showBrowseButton) {
            p3.add(this.browseButton);
        }
        p3.add(this.okButton);
        p3.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("North", p1);
        contentPane.add("Center", p2);
        contentPane.add("South", p3);
        this.pack();
        this.tf.requestFocus();
    }

    private String loadFile() {
        this.currentDir = this.browseDir.getApplyTemplateDir();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setCurrentDirectory(new File(this.currentDir));
            }
            this.fileChooser.showDialog(this.frame, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.browseDir.setApplyTemplateDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.frame, this.currentDir, this.ext);
        }
        this.browseDialog.setVisible(true);
        this.browseDir.setApplyTemplateDir(this.browseDialog.getCurrentDirectory());
        return this.browseDialog.getSelectedFile();
    }

    public boolean windowClosed() {
        return this.windowClosed;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public boolean isFormulaApplied() {
        return this.isFormulaApplied;
    }

    public boolean isEmptySectionApplied() {
        return this.isEmptySectionApplied;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.tf.getText();
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.tf.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.tf) {
            if (filename == null || filename.trim().equals("") || filename.trim().equals(this.defaultDir)) {
                new JMessageDialog((Frame)this.frame, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input a file name!"));
                return;
            }
            String fname = filename;
            if (filename.indexOf(46) > 0) {
                if (!(filename.toLowerCase().endsWith(".rpt") || filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".qrp") || filename.toLowerCase().endsWith(".pak"))) {
                    new JMessageDialog((Frame)this.frame, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please enter file with extension PAK, RPT, QRP or XML!"));
                    return;
                }
            } else {
                fname = filename + ".rpt";
            }
            try {
                FileInfo fInfo = new FileInfo(fname);
                if (!fInfo.exists()) {
                    new JMessageDialog((Frame)this.frame, LanguageEncoder.getText("Error"), fname + LanguageEncoder.getText("(The system cannot find the file specified)"));
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't check if file exists", ex);
            }
            this.selectedFile = filename;
            this.isFormulaApplied = this.applyFormula.isSelected();
            this.isEmptySectionApplied = this.applyEmptySec.isSelected();
        } else if (e.getSource() == this.cancelButton) {
            this.selectedFile = null;
        }
        this.windowClosed = false;
        this.setVisible(false);
        this.dispose();
    }

    public void setBrowseDirectories(BrowseDirectories browseDir) {
        this.browseDir = browseDir;
    }
}

