/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SmartGridLayout;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.designer.ImageListPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.YAImageCanvas;
import quadbase.reportdesigner.util.internal.ImageData;

public class BackgroundImageDialog
extends QbDialog
implements FilenameFilter,
ListSelectionListener,
ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(BackgroundImageDialog.class.getName());
    private YAImageCanvas imageCanvas;
    private JButton btnOK;
    private JButton btnCancel;
    private JButton defaultSize;
    private ImageListPanel extendchoice;
    private JLabel sizelabel;
    private JRadioButton ch_center;
    private JRadioButton ch_fit;
    private JRadioButton ch_tile;
    private JTextField radiusIncreaseTF;
    private JTextField widthField;
    private JTextField heightField;
    private JComboBox unitList;
    private ReportImage image;
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    public static final int NONE = 3;
    private int display_option = 0;
    private URL file_url;
    private JCheckBox enableBGImage;
    URL imageURL;
    String relativeURL = null;
    boolean isModified = false;
    boolean isBackgroundImage = true;
    private boolean setDisplayOption = false;
    private ReportMain parent;
    private int savedSelectedUnit;

    public BackgroundImageDialog(ReportMain parent, ReportImage image, boolean tileOption, String title) {
        super(parent, title, true);
        this.parent = parent;
        this.image = image;
        this.isBackgroundImage = title.equalsIgnoreCase(LanguageEncoder.getText("Choose A Background Image"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Color.lightGray);
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        imagePanel.setLayout(new BorderLayout());
        this.imageCanvas = new YAImageCanvas();
        imagePanel.add("Center", this.imageCanvas);
        this.sizelabel = new JLabel("                     ");
        imagePanel.add("South", this.sizelabel);
        imagePanel.setPreferredSize(new Dimension(350, 350));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.btnOK = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.btnOK);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.btnCancel);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.extendchoice = new ImageListPanel(this, parent, LanguageEncoder.getText("Image URL:"));
        this.extendchoice.setValue("");
        JPanel lpanel = new JPanel();
        lpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Location")));
        lpanel.setLayout(new BorderLayout());
        lpanel.add("Center", this.extendchoice);
        JPanel epanel = new JPanel();
        epanel.setLayout(new BorderLayout());
        this.enableBGImage = new JCheckBox(LanguageEncoder.getText("Enable Background Image"));
        epanel.add("Center", this.enableBGImage);
        this.enableBGImage.addItemListener(this);
        contentPane.add("Center", imagePanel);
        JPanel botpanel = new JPanel();
        botpanel.setLayout(new BorderLayout());
        botpanel.add("East", buttonPanel);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Display Option")));
        optionPanel.setLayout(new FlowLayout(0));
        if (!this.isBackgroundImage) {
            optionPanel.add(new JLabel(LanguageEncoder.getText("Radius (1 = 100% of Dial Chart Radius):")));
            this.radiusIncreaseTF = new JTextField("1");
            this.radiusIncreaseTF.setPreferredSize(new Dimension(80, 20));
            optionPanel.add(this.radiusIncreaseTF);
        }
        JPanel dpanel = new JPanel();
        dpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Dimension")));
        dpanel.setLayout(new SmartGridLayout(4, 2));
        String text = LanguageEncoder.getText("Width");
        JLabel widthLabel = new JLabel(text);
        dpanel.add(widthLabel);
        this.widthField = new JTextField(10);
        dpanel.add(this.widthField);
        String[] unitStrings = new String[]{LanguageEncoder.getText("inch"), LanguageEncoder.getText("pixel"), LanguageEncoder.getText("millimeter")};
        this.unitList = new JComboBox<String>(unitStrings);
        this.unitList.setSelectedIndex(0);
        this.unitList.addActionListener(this);
        dpanel.add(this.unitList);
        JLabel empty1 = new JLabel("");
        dpanel.add(empty1);
        text = LanguageEncoder.getText("Height");
        JLabel heightLabel = new JLabel(text);
        dpanel.add(heightLabel);
        this.heightField = new JTextField(10);
        dpanel.add(this.heightField);
        JLabel empty2 = new JLabel("");
        dpanel.add(empty2);
        this.defaultSize = new JButton(LanguageEncoder.getText("Calculate Default Size"));
        this.defaultSize.addActionListener(this);
        dpanel.add(this.defaultSize);
        ButtonGroup ckgroup = new ButtonGroup();
        this.ch_center = new JRadioButton(LanguageEncoder.getText("Center"), true);
        optionPanel.add(this.ch_center);
        if (this.isBackgroundImage) {
            this.ch_fit = new JRadioButton(LanguageEncoder.getText("Fit"), false);
            optionPanel.add(this.ch_fit);
            this.ch_tile = new JRadioButton(LanguageEncoder.getText("Tile"), false);
            optionPanel.add(this.ch_tile);
        }
        ckgroup.add(this.ch_center);
        this.ch_center.addItemListener(this);
        if (this.isBackgroundImage) {
            ckgroup.add(this.ch_fit);
            this.ch_fit.addItemListener(this);
            ckgroup.add(this.ch_tile);
            this.ch_tile.addItemListener(this);
        }
        this.setDisplayOption(this.display_option);
        if (tileOption) {
            contentPane.add("North", epanel);
            JPanel tpanel = new JPanel();
            tpanel.setLayout(new BorderLayout());
            tpanel.add("North", lpanel);
            JPanel dopanel = new JPanel();
            dopanel.setLayout(new BorderLayout());
            dopanel.add("North", dpanel);
            dopanel.add("Center", optionPanel);
            tpanel.add("Center", dopanel);
            tpanel.add("South", botpanel);
            contentPane.add("South", tpanel);
        } else {
            this.enableBGImage.setSelected(true);
            this.defaultSize.setText(LanguageEncoder.getText("Reset to Default"));
            JPanel tpanel = new JPanel();
            tpanel.setLayout(new BorderLayout());
            tpanel.add("North", lpanel);
            tpanel.add("Center", dpanel);
            tpanel.add("South", botpanel);
            contentPane.add("South", tpanel);
        }
        if (image != null) {
            this.enableBGImage.setSelected(true);
        }
        this.setValues(image);
        this.setPosition();
        this.extendchoice.btnRefresh.doClick();
    }

    public BackgroundImageDialog(ReportMain parent, ReportImage image) {
        this(parent, image, false, LanguageEncoder.getText("Insert Image"));
    }

    private void setValues(ReportImage image) {
        if (image == null) {
            return;
        }
        if (image.getImagePath() != null) {
            this.extendchoice.setValue(image.getImagePath());
        } else if (image.getImageURL() != null) {
            this.extendchoice.setValue(image.getImageURL().toString());
        } else {
            return;
        }
        if (this.parent.isCm) {
            this.widthField.setText(this.setFractionDigits((int)Math.round(image.getWidth() * 254.0)));
            this.heightField.setText(this.setFractionDigits((int)Math.round(image.getHeight() * 254.0)));
        } else {
            this.widthField.setText(this.setFractionDigits((int)Math.round(image.getWidth() * 100.0)));
            this.heightField.setText(this.setFractionDigits((int)Math.round(image.getHeight() * 100.0)));
        }
        if (image.getImageOption() == 1) {
            this.ch_fit.setSelected(true);
        } else if (image.getImageOption() == 2) {
            this.ch_tile.setSelected(true);
        } else {
            this.ch_center.setSelected(true);
        }
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void show(URL directory) {
        this.imageURL = directory;
        this.extendchoice.setValue(directory.toString());
        super.setVisible(true);
    }

    public void show(URL file_url, int display_option) {
        this.show(file_url, null, display_option);
    }

    public void show(URL file_url, String relativeURL, int display_option) {
        this.imageURL = file_url;
        String s = file_url.toString();
        this.file_url = file_url;
        this.imageCanvas.setImage(file_url);
        int index = s.lastIndexOf(47);
        this.enableBGImage.setSelected(display_option != 3 && this.imageCanvas.getImage() != null);
        if (index != -1) {
            s.substring(index + 1);
            this.extendchoice.setValue(s);
            this.setDisplayOption(display_option);
        }
        super.setVisible(true);
    }

    public void setRatio(double r) {
        this.radiusIncreaseTF.setText("" + r);
    }

    public void addChoice(URL s) {
        this.extendchoice.setValue(s.toString());
    }

    @Override
    public boolean accept(File dir, String name) {
        String filenameUpper = name.toUpperCase();
        return filenameUpper.endsWith(".GIF") || filenameUpper.endsWith(".PNG") || filenameUpper.endsWith(".JPG") || filenameUpper.endsWith(".JPEG");
    }

    public URL getImageURL() {
        if (this.imageURL != null && this.enableBGImage.isSelected()) {
            return this.imageURL;
        }
        return null;
    }

    public String getRelativeURL() {
        if (this.relativeURL != null) {
            return this.relativeURL;
        }
        return null;
    }

    public URL getDialogImageURL() {
        try {
            return new URL(this.extendchoice.getValue());
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINEST, "Failed to get image URL", t);
            return null;
        }
    }

    public int getDisplayOption() {
        return this.display_option;
    }

    public double getImageWidth() {
        if (this.parent.isCm) {
            if (this.savedSelectedUnit == 0) {
                return Double.parseDouble(this.widthField.getText()) / 2.54;
            }
            if (this.savedSelectedUnit == 1) {
                return QbUtil.toInch(Double.parseDouble(this.widthField.getText())) / 2.54;
            }
            if (this.savedSelectedUnit == 2) {
                return Double.parseDouble(this.widthField.getText()) / 10.0;
            }
            return -1.0;
        }
        if (this.savedSelectedUnit == 0) {
            return Double.parseDouble(this.widthField.getText());
        }
        if (this.savedSelectedUnit == 1) {
            return QbUtil.toInch(Double.parseDouble(this.widthField.getText()));
        }
        if (this.savedSelectedUnit == 2) {
            return Double.parseDouble(this.widthField.getText()) / 25.4;
        }
        return -1.0;
    }

    public double getImageHeight() {
        if (this.parent.isCm) {
            if (this.savedSelectedUnit == 0) {
                return Double.parseDouble(this.heightField.getText()) * 2.54;
            }
            if (this.savedSelectedUnit == 1) {
                return QbUtil.toInch(Double.parseDouble(this.heightField.getText())) * 2.54;
            }
            if (this.savedSelectedUnit == 2) {
                return Double.parseDouble(this.heightField.getText()) / 10.0;
            }
            return -1.0;
        }
        if (this.savedSelectedUnit == 0) {
            return Double.parseDouble(this.heightField.getText());
        }
        if (this.savedSelectedUnit == 1) {
            return QbUtil.toInch(Double.parseDouble(this.heightField.getText()));
        }
        if (this.savedSelectedUnit == 2) {
            return Double.parseDouble(this.heightField.getText()) / 25.4;
        }
        return -1.0;
    }

    private void setDisplayOption(int option) {
        if (!this.isBackgroundImage && option != 3) {
            option = 0;
        }
        this.setDisplayOption = true;
        this.display_option = option;
        this.imageCanvas.setDisplayOption(option);
        switch (option) {
            case 0: {
                this.ch_center.setSelected(true);
                break;
            }
            case 2: {
                if (this.ch_tile != null) {
                    this.ch_tile.setSelected(true);
                    break;
                }
                this.ch_center.setSelected(true);
                break;
            }
            case 1: {
                if (this.ch_fit != null) {
                    this.ch_fit.setSelected(true);
                    break;
                }
                this.ch_center.setSelected(true);
                break;
            }
            default: {
                this.enableBGImage.setSelected(false);
            }
        }
        if (this.extendchoice != null) {
            this.extendchoice.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_center != null) {
            this.ch_center.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_fit != null) {
            this.ch_fit.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_tile != null) {
            this.ch_tile.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.radiusIncreaseTF != null) {
            this.radiusIncreaseTF.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.widthField != null) {
            this.widthField.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.heightField != null) {
            this.heightField.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.unitList != null) {
            this.unitList.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.defaultSize != null) {
            this.defaultSize.setEnabled(this.enableBGImage.isSelected());
        }
        this.setDisplayOption = false;
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.file_url != null) {
            Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
            if (d.width != 0) {
                this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
                if (this.image == null) {
                    this.defaultSize.doClick();
                } else {
                    this.widthField.setText(this.setFractionDigits((int)Math.round(this.image.getWidth() * 100.0)));
                    this.heightField.setText(this.setFractionDigits((int)Math.round(this.image.getHeight() * 100.0)));
                    this.unitList.setSelectedIndex(0);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.btnOK) {
            if (!this.enableBGImage.isSelected()) {
                this.imageURL = null;
            } else {
                this.extendchoice.btnRefresh.doClick();
                if (this.display_option != 3 && this.imageCanvas.getImage() == null) {
                    String msg = LanguageEncoder.getText("Please choose an image!");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (!this.isBackgroundImage && (this.getRatio() < 0.0 || this.getRatio() > 5.0)) {
                    String msg = LanguageEncoder.getText("Gauge radius must be between 0 and 5!");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (this.display_option != 3 && !this.checkRelativeURL()) {
                    String msg = LanguageEncoder.getText("Cannot use relative path for this directory!");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (this.getImageURL() != null) {
                    this.fireEvent(this, 0);
                }
                if (this.widthField.getText().trim().equals("") || this.getImageWidth() <= 0.0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please specify the width of this image."));
                    return;
                }
                if (this.heightField.getText().trim().equals("") || this.getImageHeight() <= 0.0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please specify the height of this image."));
                    return;
                }
            }
            this.isModified = true;
            this.setVisible(false);
        } else if (target == this.btnCancel) {
            this.setVisible(false);
        } else if (target == this.unitList) {
            if (this.unitList.getSelectedIndex() == 2) {
                if (this.savedSelectedUnit == 0) {
                    this.widthField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(QbUtil.toPixel(Double.parseDouble(this.widthField.getText())) * 2540))));
                    this.heightField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(QbUtil.toPixel(Double.parseDouble(this.heightField.getText())) * 2540))));
                } else if (this.savedSelectedUnit == 1) {
                    this.widthField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(Double.parseDouble(this.widthField.getText())) * 2540.0)));
                    this.heightField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) * 2540.0)));
                }
            } else if (this.unitList.getSelectedIndex() == 1) {
                if (this.savedSelectedUnit == 0) {
                    this.widthField.setText(QbUtil.toPixel(Double.parseDouble(this.widthField.getText())) + "");
                    this.heightField.setText(QbUtil.toPixel(Double.parseDouble(this.heightField.getText())) + "");
                } else if (this.savedSelectedUnit == 2) {
                    this.widthField.setText(QbUtil.toPixel(Double.parseDouble(this.widthField.getText()) / 25.4) + "");
                    this.heightField.setText(QbUtil.toPixel(Double.parseDouble(this.heightField.getText()) / 25.4) + "");
                }
            } else if (this.savedSelectedUnit == 1) {
                this.widthField.setText(this.setFractionDigits((int)(QbUtil.toInch(Double.parseDouble(this.widthField.getText())) * 100.0)));
                this.heightField.setText(this.setFractionDigits((int)(QbUtil.toInch(Double.parseDouble(this.heightField.getText())) * 100.0)));
            } else if (this.savedSelectedUnit == 2) {
                this.widthField.setText(this.setFractionDigits((int)(Double.parseDouble(this.widthField.getText()) * 100.0 / 25.4)));
                this.heightField.setText(this.setFractionDigits((int)(Double.parseDouble(this.heightField.getText()) * 100.0 / 25.4)));
            }
            this.savedSelectedUnit = this.unitList.getSelectedIndex();
        } else if (target == this.defaultSize && !this.extendchoice.getValue().trim().equals("")) {
            try {
                Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
                if (d != null) {
                    if (d.getWidth() < 0.0 || d.getHeight() < 0.0) {
                        throw new Exception("Failed to retrieve image.");
                    }
                    if (this.unitList.getSelectedIndex() == 0) {
                        this.widthField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(d.width) * 100.0)));
                        this.heightField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(d.height) * 100.0)));
                    } else if (this.unitList.getSelectedIndex() == 1) {
                        this.widthField.setText(d.width + "");
                        this.heightField.setText(d.height + "");
                    } else if (this.unitList.getSelectedIndex() == 2) {
                        this.widthField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(d.width) * 2540.0)));
                        this.heightField.setText(this.setFractionDigits((int)Math.round(QbUtil.toInch(d.height) * 2540.0)));
                    }
                } else {
                    this.sizelabel.setText("                    ");
                    this.widthField.setText("");
                    this.heightField.setText("");
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to calculate default size for this image", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to calculate default size for this image.") + "\n" + ex.toString());
            }
        }
    }

    void changeDirectory(boolean resetImageSize) {
        this.imageCanvas.setImage((Image)null);
        this.sizelabel.setText("                    ");
        try {
            String s = this.extendchoice.getValue();
            if (s != null) {
                if (QbUtil.isImageFile(s)) {
                    this.sizelabel.setText(LanguageEncoder.getText("Loading..."));
                    this.repaint();
                    this.imageURL = this.getURL(s);
                    this.imageCanvas.setImage(this.imageURL);
                    this.sizelabel.setText("                    ");
                    Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
                    if (d.width != 0) {
                        this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
                        if (this.image == null || QbUtil.isNullOrEmpty(this.widthField.getText()) && QbUtil.isNullOrEmpty(this.heightField.getText())) {
                            this.defaultSize.doClick();
                        } else if (resetImageSize) {
                            if (this.image.getImageURL() != null) {
                                this.widthField.setText(this.setFractionDigits((int)Math.round(this.image.getWidth() * 100.0)));
                                this.heightField.setText(this.setFractionDigits((int)Math.round(this.image.getHeight() * 100.0)));
                                this.savedSelectedUnit = 0;
                                this.unitList.setSelectedIndex(0);
                            } else {
                                this.defaultSize.doClick();
                            }
                        }
                    }
                } else if (!s.endsWith("/")) {
                    s = s + "/";
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot change directory", ex);
        }
    }

    private URL getURL(String s) throws MalformedURLException {
        if (s == null) {
            return null;
        }
        String path = "";
        if (!s.toLowerCase().startsWith("file") && !s.toLowerCase().startsWith("http")) {
            try {
                this.relativeURL = s;
                path = new FileInfo(s).getAbsolutePath();
                if (!(QbUtil.isImageFile(s) || path.endsWith("/") || path.endsWith("\\"))) {
                    path = path + "/";
                }
                return new URL(IOUtil.nameToURL3(path));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't get relative URL", ex);
                return new URL(s);
            }
        }
        this.relativeURL = null;
        return new URL(QbUtil.fixUrlString(s));
    }

    private String setFractionDigits(int v) {
        String t = Integer.toString(v);
        if (t.endsWith("0")) {
            double d = (double)v / 100.0;
            t = Double.toString(d).concat("0");
            return t;
        }
        double d = (double)v / 100.0;
        t = Double.toString(d);
        return t;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setImage();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.setDisplayOption) {
            return;
        }
        if (!this.enableBGImage.isSelected()) {
            this.setDisplayOption(3);
            this.sizelabel.setVisible(false);
        } else if (this.ch_center.isSelected()) {
            this.setDisplayOption(0);
            this.sizelabel.setVisible(true);
        } else if (this.ch_tile.isSelected()) {
            this.setDisplayOption(2);
            this.sizelabel.setVisible(true);
        } else if (this.ch_fit.isSelected()) {
            this.setDisplayOption(1);
            this.sizelabel.setVisible(true);
        }
    }

    private void setImage() {
        URL url = this.getDialogImageURL();
        if (url != null) {
            this.sizelabel.setText(LanguageEncoder.getText("Loading..."));
            this.repaint();
            this.imageCanvas.setImage(url);
            this.sizelabel.setText("                    ");
            Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
            this.imageURL = url;
            if (d.width != 0) {
                this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
                if (this.image == null) {
                    this.defaultSize.doClick();
                } else {
                    this.widthField.setText(this.setFractionDigits((int)Math.round(this.image.getWidth() * 100.0)));
                    this.heightField.setText(this.setFractionDigits((int)Math.round(this.image.getHeight() * 100.0)));
                    this.unitList.setSelectedIndex(0);
                }
            }
        }
    }

    private boolean checkRelativeURL() {
        boolean relative = true;
        if (this.imageURL != null && (this.imageURL.toString().toUpperCase().startsWith("HTTP://") || this.imageURL.toString().toUpperCase().startsWith("HTTPS://"))) {
            relative = false;
        }
        if (!relative) {
            this.relativeURL = null;
            return true;
        }
        if (this.relativeURL != null) {
            return true;
        }
        try {
            String curLoc = new FileInfo("/").getAbsolutePath().replaceAll("\\\\", "/");
            if (!curLoc.endsWith("/")) {
                curLoc = curLoc + "/";
            }
            curLoc = this.frame instanceof ReportMain && ((ReportMain)this.frame).getURL(curLoc) != null ? ((ReportMain)this.frame).getURL(curLoc) : IOUtil.nameToURL3(curLoc);
            String urlStr = this.imageURL.toString().replaceAll("\\\\", "/");
            LOGGER.finest("CUR LOC = " + curLoc);
            LOGGER.finest("URL STR = " + urlStr);
            if (urlStr.startsWith(curLoc)) {
                this.relativeURL = urlStr.substring(curLoc.length());
                return true;
            }
            if (urlStr.replaceAll("file:/", "").startsWith(curLoc)) {
                this.relativeURL = urlStr.replaceAll("file:/", "").substring(curLoc.length() + 1);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to check relative URL", e);
        }
        this.relativeURL = null;
        return true;
    }

    public double getRatio() {
        double result;
        String ratio = this.radiusIncreaseTF.getText();
        try {
            result = Double.parseDouble(ratio);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, "Cannot get ratio value: Invalid number, using 1", e);
            result = 1.0;
        }
        return result;
    }
}

