/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTree;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.DrillDownTreeModel;
import quadbase.chart.designer.QbChartDesigner;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.IChangeDataRegistry;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.EmptyGlassPane;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.Report;
import quadbase.reportorganizer.manager.OrganizerClient;
import quadbase.util.internal.TransposeRS;

public class ChartEditor
extends ChartMain {
    private static final Logger LOGGER = Logger.getLogger(ChartEditor.class.getName());
    private static boolean isWarningShown = false;
    boolean reopenMasterSection = false;
    JPanel masterSectionParentPanel;
    ReportChartObject reportChartObject;
    ReportElementPanel reportChartPanel;
    private ReportMain reportMain;
    private boolean iconified = false;
    private boolean useReportData = true;
    private boolean createFile = false;
    private Chart reloadFile = null;
    private Component oldGlassPane = null;
    private boolean updatePanelSize = false;
    private boolean updateRptEltSize = false;
    private ColData[] rptColData = null;

    private ChartEditor(ReportMain reportMain, Report report, ReportTable tbl, ReportCell[] cells, boolean useSummaryData, String[] colDataMapping, String fileName, byte[] bytes, boolean createFile, boolean importExistingChart) throws Exception {
        super(new ChartPanel(null));
        this.setPresetDataRegistry(reportMain.getPresetDataRegistry());
        this.setBrowseDirectories(reportMain.getBrowseDirectories());
        this.setDataRegistryHiddenNodes(reportMain.getDataRegistryHiddenNodes());
        this.useReportData = tbl != null;
        this.reportMain = reportMain;
        this.createFile = createFile;
        this.init();
        this.processQbChartDesigner();
        if (createFile) {
            this.createChart(report, tbl, cells, useSummaryData, fileName, importExistingChart);
        } else {
            this.openChart(report, tbl, cells, useSummaryData, colDataMapping, fileName, bytes);
        }
    }

    static Object loadChartEditor(ReportMain reportMain, Report report, ReportTable tbl, ReportCell[] cells, boolean useSummaryData, String[] colDataMapping, Object editorObject, String fileName, byte[] bytes, boolean createFile, boolean importExistingChart) {
        try {
            ChartEditor editor = null;
            if (editorObject != null && ((ChartEditor)editorObject).isVisible()) {
                editor = (ChartEditor)editorObject;
                editor.createFile = createFile;
                editor.setReportMain(reportMain);
                editor.useReportData = tbl != null;
                editor.do_CloseChart();
                if (editor.useReportData) {
                    if (createFile) {
                        editor.createChart(report, tbl, cells, useSummaryData, fileName, false);
                    } else {
                        editor.openChart(report, tbl, cells, useSummaryData, colDataMapping, fileName, bytes);
                    }
                }
                if (editor.iconified) {
                    editor.reloadFile = editor.getChart();
                }
            } else {
                editor = new ChartEditor(reportMain, report, tbl, cells, useSummaryData, colDataMapping, fileName, bytes, createFile, importExistingChart);
            }
            editor.oldGlassPane = reportMain.getGlassPane();
            editor.setRecentColors(reportMain.getRecentColors());
            EmptyGlassPane p = new EmptyGlassPane();
            reportMain.setGlassPane(p);
            p.setVisible(true);
            editor.setVisible(true);
            editor.toFront();
            if (editor.chartWizard != null) {
                editor.chartWizard.toFront();
            }
            return editor;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load chart editor", ex);
            if (ex.getMessage().equals("CANCEL")) {
                return null;
            }
            new JMessageDialog((Frame)reportMain, LanguageEncoder.getText("Warning"), ex.toString());
            return null;
        }
    }

    @Override
    protected void setPosition() {
        super.setPosition();
        this.setLocationRelativeTo(this.reportMain);
    }

    private void processQbChartDesigner() {
        if (this.reportMain.getChartHandle() != null) {
            this.reportMain.getChartHandle().processDesigner(new QbChartDesigner(null, this));
        }
    }

    @Override
    public void toFront() {
        if (this.isVisible()) {
            super.toFront();
        }
        if (this.chartWizard != null) {
            this.chartWizard.toFront();
        }
    }

    private void setReportMain(ReportMain main) {
        if (main != null) {
            this.reportMain = main;
        }
    }

    private void createChart(Report report, ReportTable tbl, ReportCell[] cells, boolean useSummaryData, String fileName, boolean importExistingChart) {
        this.updatePanelSize = true;
        if (fileName != null && !fileName.equals("")) {
            this.setFileName(fileName);
        }
        if (this.useReportData) {
            this.chartWizard = new ChartWizard(this, LanguageEncoder.getText("Insert Chart"));
            this.rptColData = ChartObject.getColData(report, tbl, cells, useSummaryData, null);
            this.chartWizard.newchartType(this.rptColData, 3);
            this.chartWizard.setVisible(true);
            if (this.chartPanel.chart != null) {
                this.chartPanel.chart.sourceData = 0;
                this.chartPanel.chart.originalColDataFromMemSource = this.rptColData;
            }
        } else {
            this.setVisible(true);
            this.chartWizard = new ChartWizard(this);
            this.chartWizard.init();
            if (importExistingChart) {
                this.do_Open();
            } else {
                this.chartWizard.newChart(true, false);
            }
        }
    }

    private void openChart(Report report, ReportTable tbl, ReportCell[] cells, boolean useSummaryData, String[] colDataMapping, String fileName, byte[] bytes) throws Exception {
        Chart chart = null;
        if (this.useReportData) {
            if (bytes != null) {
                this.rptColData = ChartObject.getColData(report, tbl, cells, useSummaryData, colDataMapping);
                chart = ChartObject.openChart(new ByteArrayInputStream(bytes), this.rptColData, true, null);
            } else {
                this.rptColData = ChartObject.getColData(report, tbl, cells, useSummaryData, colDataMapping);
                chart = ChartObject.openChart(report.getSubFilesTable(), fileName, this.rptColData, null);
            }
            ColData[] reportColData = ChartObject.getUnmappedColData(report, tbl, cells, useSummaryData);
            ColData[] chartColData = chart.colData;
            ColData[] colData = chart.isTransposed ? ColData.getColData(TransposeRS.doTranspose(reportColData, chart.transposeCol)) : reportColData;
            boolean colDataCompatible = ColData.isColDataCompatible(colData, chartColData);
            if (!colDataCompatible) {
                chart = chart.setNewData(colData, true);
                chart.originalColDataFromMemSource = reportColData;
            }
            chart.setSubFilesTable(report.getSubFilesTable());
            this.openNewChart(chart, fileName, !colDataCompatible);
            this.setDrillDownTree(new JTree(new DrillDownTreeModel(this.getChart().currentNode)));
            this.do_enable();
        } else if (report.getSubFilesTable() != null && report.getSubFilesTable().containsKey(fileName)) {
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream in = readfile.getInputStream(report.getSubFilesTable(), fileName);
            LoadChart loadChart = new LoadChart();
            chart = loadChart.load(null, in, fileName.toLowerCase().endsWith(".tpl"), null);
            this.openNewChart(chart, fileName);
            chart.setSubFilesTable(report.getSubFilesTable());
            this.setDrillDownTree(new JTree(new DrillDownTreeModel(this.getChart().currentNode)));
            this.do_enable();
        } else if (this.do_openChart(fileName, bytes)) {
            this.do_enable();
        } else {
            throw new Exception("CANCEL");
        }
    }

    @Override
    public void do_New() {
        super.do_New();
        this.updatePanelSize = true;
    }

    @Override
    public void do_Open() {
        this.updatePanelSize = false;
        super.do_Open();
        this.updateRptEltSize = true;
        this.updateRptEltSize();
    }

    @Override
    protected void do_disable() {
        super.do_disable();
        if (!this.useReportData) {
            return;
        }
        this.newitem.setEnabled(false);
        this.openitem.setEnabled(false);
    }

    @Override
    protected void do_enable() {
        super.do_enable();
        this.saveasitem.setEnabled(true);
        this.exportitem.setEnabled(true);
        this.allowOpeningSaveAsDialogForSaveColorsForCategories = true;
        if (!this.useReportData) {
            return;
        }
        this.modifydataitem.setEnabled(false);
        this.modifyparamitem.setEnabled(false);
        this.newitem.setEnabled(false);
        this.openitem.setEnabled(false);
        this.closeitem.setEnabled(false);
        this.refreshitem.setEnabled(false);
        this.schedulerefreshitem.setEnabled(false);
        this.histogramitem.setEnabled(false);
        this.aggregationItem.setEnabled(false);
        this.zoomitem.setEnabled(false);
        this.aboutitem.setEnabled(false);
        this.drillDownmenu.setEnabled(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        if (ServerMessage.getApplet() != null) {
            this.iconified = true;
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        if (this.reloadFile != null && this.iconified && ServerMessage.getApplet() != null) {
            this.do_CloseChart();
            this.setNewChart(this.reloadFile);
            this.reloadFile = null;
            this.iconified = false;
        }
    }

    public void launchNewDataReg(String dataReg, Vector<String> invisibleNodes) {
        this.setPresetDataRegistry(dataReg);
        this.setDataRegistryHiddenNodes(invisibleNodes);
        this.toFront();
        if (this.chartWizard != null) {
            this.chartWizard.toFront();
            this.chartWizard.newChart();
        }
    }

    @Override
    public void dispose() {
        try {
            Chart chart;
            String chtName;
            if (this.reportMain == null) {
                try {
                    super.dispose();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Can't dispose of ChartMain", ex);
                }
                return;
            }
            this.reportMain.setPresetDataRegistry(this.getPresetDataRegistry());
            this.reportMain.setDataRegistryHiddenNodes(this.getDataRegistryHiddenNodes());
            this.setVisible(false);
            this.reportMain.getGlassPane().setVisible(false);
            this.reportMain.setGlassPane(this.oldGlassPane);
            if (this.reopenMasterSection) {
                try {
                    this.reportMain.selectedObject = this.reportChartObject;
                    this.reportMain.selectedPanel = this.reportMain.designPanel.rulerPanel.getMasterSectionPanel();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Cannot select the chart", e);
                }
            }
            if (this.createFile) {
                Chart chart2;
                chtName = this.getChartFile();
                if (chtName != null && (OrgUtil.isPackChartData(chtName) || this.reportMain.isReportOpenedInPakFormat() || this.reportMain.getFileName() != null && this.reportMain.getFileName().toUpperCase().endsWith(".PAK")) && (chart2 = this.getChart()) != null) {
                    this.reportMain.mergeSubFilesTable(chart2.getSubFilesTable());
                }
                if (chtName == null || !this.reportMain.fileExists(chtName)) {
                    if (this.reportMain.selectedObject == null) {
                        this.reportMain.setInsertChart(true);
                        this.reportMain.deleteElt(this.reportChartObject, this.reportChartPanel, false, 0, null);
                        this.reportMain.setInsertChart(false);
                    } else {
                        this.reportMain.setInsertChart(true);
                        this.reportMain.deleteElt();
                        this.reportMain.setInsertChart(false);
                    }
                } else {
                    this.reportMain.setModified(true);
                    this.reportChartObject.setText(chtName);
                    chart2 = this.getChart();
                    if (!this.isShowReportDataHasChangedDialog() && chart2 != null) {
                        this.rptColData = !chart2.isTransposed ? chart2.colData : chart2.originalColDataFromMemSource;
                    }
                    if (chart2 != null && this.rptColData != null) {
                        String[] colDataMap = new String[this.rptColData.length];
                        for (int i = 0; i < this.rptColData.length; ++i) {
                            colDataMap[i] = this.rptColData[i].getName();
                        }
                        this.reportChartObject.setColDataMapping(colDataMap);
                    }
                    this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                }
            } else {
                chtName = this.getChartFile();
                Chart chart3 = this.getChart();
                if (chart3 != null) {
                    this.reportMain.mergeSubFilesTable(chart3.getSubFilesTable());
                }
                if (this.reportChartObject == null && this.reportMain.selectedObject instanceof ReportChartObject) {
                    this.reportChartObject = (ReportChartObject)this.reportMain.selectedObject;
                }
                if (chart3 != null && this.rptColData != null) {
                    if (!this.isShowReportDataHasChangedDialog()) {
                        this.rptColData = !chart3.isTransposed ? chart3.colData : chart3.originalColDataFromMemSource;
                    }
                    String[] colDataMap = new String[this.rptColData.length];
                    for (int i = 0; i < this.rptColData.length; ++i) {
                        colDataMap[i] = this.rptColData[i].getName();
                    }
                    this.reportChartObject.setColDataMapping(colDataMap);
                }
                if (!chtName.equals(this.reportChartObject.getText())) {
                    this.reportChartObject.setText(chtName);
                    this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                }
                if (this.reportChartObject.getBytes() != null && chart3 != null) {
                    this.reportChartObject.setBytes(chart3.getSubFilesTable().get(chtName));
                }
                if (!this.reportMain.fileExists(chtName)) {
                    this.reportMain.deleteElt();
                }
            }
            if (this.reportChartObject != null && (chart = this.getChart()) != null) {
                this.reportChartObject.setWidth(QbUtil.toInch(chart.getSize().getWidth()));
                this.reportChartObject.setHeight(QbUtil.toInch(chart.getSize().getHeight()));
            }
            this.reportMain.setInsertChart(false);
            if (this.reopenMasterSection) {
                try {
                    this.reportMain.selectedObject = this.reportMain.designPanel.rulerPanel.getMasterSectionPanel().getElement();
                    this.reportMain.setEltText(this.masterSectionParentPanel);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Cannot select the master section", e);
                }
                this.reopenMasterSection = false;
                this.masterSectionParentPanel = null;
                this.reportChartObject = null;
            }
            this.reportMain = null;
            super.dispose();
            Runtime.getRuntime().gc();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't dispose of ChartEditor", ex);
        }
    }

    @Override
    protected boolean isReportVersion() {
        return true;
    }

    @Override
    protected boolean isUsingReportToolBar() {
        return this.useReportData;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (this.reportMain != null) {
            this.reportMain.bringChartEditorToFront = true;
        }
    }

    @Override
    public void updatePanelSize() {
        if (!this.updatePanelSize) {
            return;
        }
        this.updatePanelSize = false;
        if (this.reportChartObject == null && this.reportMain.selectedObject instanceof ReportChartObject) {
            this.reportChartObject = (ReportChartObject)this.reportMain.selectedObject;
        }
        if (this.chartPanel == null || this.reportChartObject == null) {
            return;
        }
        if (!isWarningShown) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Chart canvas size is going to change base on the size of chart cell in the report."));
            isWarningShown = true;
        }
        this.chartPanel.setSize(this.reportChartObject.getWidthOfElement(), this.reportChartObject.getHeightOfElement(), true);
        if (this.chartPanel.chart != null) {
            this.chartPanel.setRecompute();
            this.chartPanel.paint(this.chartPanel.getGraphics());
        }
    }

    private void updateRptEltSize() {
        if (!this.updateRptEltSize) {
            return;
        }
        this.updateRptEltSize = false;
        if (this.reportChartObject == null && this.reportMain.selectedObject instanceof ReportChartObject) {
            this.reportChartObject = (ReportChartObject)this.reportMain.selectedObject;
        }
        if (this.chartPanel == null || this.reportChartObject == null || this.chartPanel.chart == null) {
            return;
        }
        this.reportChartObject.setWidth(QbUtil.toInch(this.chartPanel.chart.getSize().getWidth()));
        this.reportChartObject.setHeight(QbUtil.toInch(this.chartPanel.chart.getSize().getHeight()));
    }

    @Override
    public String getLoginUser() {
        return this.reportMain.getLoginUser();
    }

    @Override
    public boolean isChangeDataRegistryEnabled() {
        return this.reportMain.isChangeDataRegistryEnabled();
    }

    @Override
    public IChangeDataRegistry getChangeDataRegObj() {
        return this.reportMain.getChangeDataRegObj(this);
    }

    @Override
    public IChangeDataRegistryPlus getChangeDataRegPlusObj() {
        return this.reportMain.getChangeDataRegPlusObj();
    }

    @Override
    public boolean canModify() {
        return this.reportMain.canModify();
    }

    @Override
    public boolean isReportPakFile() {
        return this.reportMain.getSubFilesTable() != null && this.reportMain.getSubFilesTable().size() > 0;
    }

    @Override
    public boolean useReportData() {
        return this.useReportData;
    }

    @Override
    public boolean isFromOrganizer() {
        return this.getChangeDataRegPlusObj() != null;
    }

    @Override
    public void setModified() {
        if (this.isFromOrganizer()) {
            OrganizerClient.resetJavaScriptSessionTimeout();
        }
        super.setModified();
    }

    @Override
    public boolean isSaas() {
        if (this.isFromOrganizer()) {
            return ServerMessage.isSaas();
        }
        return false;
    }
}

