/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import quadbase.chart.Chart;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.designer.DrillDownColumnMapDialog;
import quadbase.reportdesigner.designer.InternalListItem;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.Report;

public class ChartParameterMappingDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ChartParameterMappingDialog.class.getName());
    private Report report = null;
    private JCheckBox[][] map = null;
    private Object[][] defValue = null;
    private JComboBox[][] columnChoices = null;
    private ReportChartObject[] selectedCharts = null;
    private JButton okButton;
    private JButton cancelButton;
    private boolean modified = false;

    public ChartParameterMappingDialog(JFrame parent, Report r) throws Exception {
        super((Frame)parent, true);
        this.report = r;
        this.init();
    }

    private void init() throws Exception {
        Vector<ReportChartObject> allCharts = this.report.getAllCharts();
        Vector<QueryInParamSet> paramsets = new Vector<QueryInParamSet>();
        Vector<Integer> indices = new Vector<Integer>();
        if (allCharts != null) {
            for (int i = 0; i < allCharts.size(); ++i) {
                ReportChartObject rptChart = allCharts.elementAt(i);
                Chart chart = ChartObject.getIndependentChart(this.report, rptChart, null);
                if (chart == null || !ChartObject.isParamChart(chart)) continue;
                paramsets.addElement(chart.getQueryFileInfo().getInSet());
                indices.addElement(i + 1);
            }
        }
        if (paramsets.size() <= 0) {
            throw new Exception(LanguageEncoder.getText("This report does not contain any parameterized charts."));
        }
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Chart Parameters"));
        this.setDefaultCloseOperation(2);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.map = new JCheckBox[paramsets.size()][];
        this.defValue = new Object[paramsets.size()][];
        this.columnChoices = new JComboBox[paramsets.size()][];
        JPanel[] topPanel = new JPanel[paramsets.size()];
        this.selectedCharts = new ReportChartObject[paramsets.size()];
        for (int j = 0; j < paramsets.size(); ++j) {
            QueryInParam[] params = ((QueryInParamSet)paramsets.elementAt(j)).getParameter();
            this.map[j] = new JCheckBox[params.length];
            this.defValue[j] = new Object[params.length];
            JComboBox[] boxes = new JComboBox[params.length];
            this.columnChoices[j] = boxes;
            this.selectedCharts[j] = allCharts.elementAt((Integer)indices.elementAt(j) - 1);
            topPanel[j] = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            topPanel[j].setLayout(gbl);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.anchor = 18;
            for (int i = 0; i < params.length; ++i) {
                gbc.gridx = 0;
                gbc.gridy = i;
                QueryInParam currP = params[i];
                this.map[j][i] = new JCheckBox(currP.getPromptName());
                this.defValue[j][i] = currP.getDefaultValue();
                gbl.setConstraints(this.map[j][i], gbc);
                topPanel[j].add(this.map[j][i]);
                Vector<InternalListItem> compColumns = DrillDownColumnMapDialog.getCompatibleColumns(currP.getSqlType(), this.report);
                JComboBox choice = null;
                if (compColumns == null) {
                    choice = new JComboBox(new String[]{"No match, use default."});
                    choice.setEnabled(false);
                    this.columnChoices[j][i] = null;
                } else {
                    boxes[i] = new JComboBox<InternalListItem>(compColumns);
                    int def = -2;
                    try {
                        for (int k = 0; k < compColumns.size(); ++k) {
                            if (!compColumns.elementAt((int)k).column_id.equals(this.selectedCharts[j].getParameterMap()[i])) continue;
                            def = k;
                            k = compColumns.size();
                        }
                        boxes[i].setSelectedIndex(def);
                        this.map[j][i].setSelected(true);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to set selected index", ex);
                    }
                    choice = boxes[i];
                }
                gbc.gridx = 1;
                gbl.setConstraints(choice, gbc);
                topPanel[j].add(choice);
            }
            topPanel[j].setBorder(new TitledBorder("Parameter Mapping"));
            tabbedPane.addTab("Chart_" + indices.elementAt(j).toString(), topPanel[j]);
        }
        tabbedPane.setSelectedIndex(paramsets.size() - 1);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)tabbedPane, "Center");
        contentPanel.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        if (height < 200) {
            height = 200;
        }
        if (width < 300) {
            width = 300;
        }
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
        this.setSize(width, height);
        tabbedPane.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                for (int i = 0; i < this.selectedCharts.length; ++i) {
                    String[] params = new String[this.columnChoices[i].length];
                    for (int j = 0; j < params.length; ++j) {
                        params[j] = this.columnChoices[i][j] == null || !this.map[i][j].isSelected() ? (this.defValue[i][j] == null ? null : this.defValue[i][j].toString()) : ((InternalListItem)this.columnChoices[i][j].getSelectedItem()).column_id;
                    }
                    this.selectedCharts[i].setParameterMap(params);
                    if (this.selectedCharts[i].getText() == null) continue;
                    this.report.setChartParameterMap(this.selectedCharts[i].getText(), params);
                }
                this.modified = true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to perform action", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An unexpected error has occured.\nPlease cancel and try again."));
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }
}

