/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ColInfoResultPanel;
import quadbase.reportdesigner.designer.ReportMain;

public class ColInfoFrame
extends JFrame
implements ActionListener {
    JButton okButton;
    ReportMain reportMain;

    public ColInfoFrame(ReportMain reportMain, String title) {
        super(title);
        this.reportMain = reportMain;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Color.lightGray);
        contentPane.setLayout(new BorderLayout());
        ReportTable table = reportMain.report.getReportTables().elementAt(0);
        ColInfoResultPanel colInfoPanel = new ColInfoResultPanel(reportMain.report, table);
        contentPane.add("North", new JLabel("  "));
        contentPane.add("Center", colInfoPanel);
        this.okButton = new JButton(LanguageEncoder.getText("Close"));
        this.okButton.addActionListener(this);
        contentPane.add("South", this.okButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColInfoFrame.this.close();
            }
        });
        this.centerFrame();
    }

    private void centerFrame() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.close();
    }

    private void close() {
        this.reportMain.colInfoFrame = null;
        this.setVisible(false);
        this.dispose();
    }
}

