/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.PreSelectReportElement;
import quadbase.reportdesigner.designer.ReportMapping;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ColInfo;

public class ColInfoMappingPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ColInfoMappingPanel.class.getName());
    public static final String ROW_AGGREGATION = LanguageEncoder.getText("Row Aggregation");
    public static final String HIDE = LanguageEncoder.getText("Hide");
    public static final String LEFT = LanguageEncoder.getText("Left");
    public static final String RIGHT = LanguageEncoder.getText("Right");
    public static final String ROW_AGGREGATION_GRAND_TOTAL = LanguageEncoder.getText("Show Column Aggregation Grand Total");
    public static final String RE_ORDER_COLUMNS = LanguageEncoder.getText("Reorder Columns");
    public static final String ROW_AGGREGATION_SUBTOTAL = LanguageEncoder.getText("Column Aggregation Subtotal");
    public static final String HEADER = LanguageEncoder.getText("Header");
    public static final String FOOTER = LanguageEncoder.getText("Footer");
    public static final String VERTICAL = LanguageEncoder.getText("Vertical");
    public static final String HORIZONTAL = LanguageEncoder.getText("Horizontal");
    public static final String ALIGN_COLUMN_BREAK_VALUE = LanguageEncoder.getText("Align Column Break Value");
    private JButton next;
    private JButton cancel;
    private JButton back;
    private JButton done;
    private ReportWizard reportWizard;
    private JPanel prevPanel;
    private JPanel nextPanel;
    private JTable table;
    private int defaultAGGR = 7;
    private JComboBox primaryKey;
    private JComboBox topNColumn;
    private JComboBox topNOrder;
    private boolean isRedoDataMappingOp = false;
    private boolean enableApplyTemplate = false;
    private JCheckBox performAgg;
    private JCheckBox keepDataSourceOrder;
    private JCheckBox sideBySide;
    private JCheckBox applyTemplate;
    private JCheckBox applyFormula;
    private JCheckBox topN;
    private JCheckBox checkBoxReOrderColumns;
    private JCheckBox showRowAggregationGrandTotal;
    private JRadioButton rowAggregationGrandTotalOnLeft;
    private JRadioButton rowAggregationGrandTotalOnRight;
    private JRadioButton rowAggregationSubtotalHidden;
    private JRadioButton rowAggregationSubtotalOnLeft;
    private JRadioButton rowAggregationSubtotalOnRight;
    private JRadioButton columnAggregationHidden;
    private JRadioButton columnAggregationInHeader;
    private JRadioButton columnAggregationInFooter;
    private JRadioButton alignCrossTabColBkValVert;
    private JRadioButton alignCrossTabColBkValHori;
    private JTextField topNumber;
    private String[] orderText = new String[]{"not sorted", "ascending", "descending"};

    public ColInfoMappingPanel(ReportWizard reportWizard, JPanel prevPanel) {
        this(reportWizard, prevPanel, false);
    }

    public ColInfoMappingPanel(ReportWizard reportWizard, JPanel prevPanel, boolean enableApplyTemplate) {
        this.reportWizard = reportWizard;
        this.prevPanel = prevPanel;
        this.enableApplyTemplate = enableApplyTemplate;
        this.init();
    }

    public ColInfoMappingPanel(ReportWizard reportWizard, boolean isReDoDataMappingOp) {
        this.reportWizard = reportWizard;
        this.isRedoDataMappingOp = isReDoDataMappingOp;
        this.init();
    }

    private void init() {
        int i;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Column Information")));
        topPanel.setLayout(new BorderLayout());
        int primaryColumn = 0;
        int topNColumnIdx = 0;
        int nCol = 3;
        if (this.isMasterDetails()) {
            nCol = 4;
        } else if (this.isSummary()) {
            nCol = 6;
        } else if (this.isCrossTab()) {
            nCol = 8;
        }
        Object[][] data = new Object[this.reportWizard.colInfo.length][nCol];
        String[] dataName = new String[this.reportWizard.colInfo.length];
        int[] dataType = new int[this.reportWizard.colInfo.length];
        boolean perform_aggregation = false;
        int firstVarCharCol = -1;
        int lastVarCharCol = -1;
        int lastNumericCol = -1;
        for (i = 0; i < data.length; ++i) {
            if (this.reportWizard.colInfo[i].getMapping() == -1) continue;
            ColData tmpCol = this.reportWizard.colData[this.reportWizard.colInfo[i].getMapping()];
            data[i][0] = tmpCol.getName();
            dataName[i] = tmpCol.getName();
            data[i][1] = DataType.getTypeName(tmpCol.getOriginalDataType());
            dataType[i] = tmpCol.getDataType();
            if (!DataType.isDateTime(dataType[i]) && !DataType.isNumeric(dataType[i])) {
                if (firstVarCharCol == -1) {
                    firstVarCharCol = i;
                }
                lastVarCharCol = i;
            }
            if (!DataType.isNumeric(dataType[i])) continue;
            lastNumericCol = i;
        }
        if (this.isSummary() && firstVarCharCol == -1) {
            firstVarCharCol = 0;
        }
        if (this.isCrossTab()) {
            if (firstVarCharCol == -1) {
                firstVarCharCol = 0;
            }
            if (lastNumericCol == -1) {
                lastNumericCol = dataName.length - 1;
            }
            if (lastVarCharCol == -1 || lastVarCharCol == firstVarCharCol || lastVarCharCol == lastNumericCol) {
                for (i = dataName.length - 1; i >= 0; ++i) {
                    if (i == firstVarCharCol || i == lastNumericCol) continue;
                    lastVarCharCol = i;
                }
            }
            if (lastVarCharCol < firstVarCharCol) {
                int tmp = firstVarCharCol;
                firstVarCharCol = lastVarCharCol;
                lastVarCharCol = tmp;
            }
        }
        for (i = 0; i < data.length; ++i) {
            if (this.reportWizard.colInfo[i].getMapping() == -1) continue;
            data[i][2] = this.isRedoDataMappingOp ? Boolean.valueOf(this.reportWizard.colInfo[i].isVisible()) : Boolean.TRUE;
            if (this.isRedoDataMappingOp && this.reportWizard.report.isTopNReport() && this.reportWizard.colInfo[i].isTopN()) {
                topNColumnIdx = i;
            }
            if (this.isMasterDetails()) {
                if (this.isRedoDataMappingOp) {
                    data[i][3] = this.reportWizard.colInfo[i].isMaster();
                    if (!this.reportWizard.colInfo[i].isPrimaryKey()) continue;
                    primaryColumn = i;
                    continue;
                }
                data[i][3] = i == 0;
                continue;
            }
            if (this.isSummary()) {
                if (this.isRedoDataMappingOp) {
                    data[i][3] = this.reportWizard.colInfo[i].isRowBreak();
                    data[i][4] = ColInfo.AGGR[this.reportWizard.colInfo[i].getAggregation()];
                    data[i][5] = this.reportWizard.colInfo[i].isRepeatBreakField();
                    if (!this.reportWizard.colInfo[i].isAggregatedColumn()) continue;
                    perform_aggregation = true;
                    continue;
                }
                data[i][3] = i == firstVarCharCol;
                data[i][4] = ColInfo.AGGR[this.getDefaultAggregationType(dataType[i])];
                data[i][5] = Boolean.FALSE;
                continue;
            }
            if (!this.isCrossTab()) continue;
            if (this.isRedoDataMappingOp) {
                data[i][3] = this.reportWizard.colInfo[i].isRowBreak() && !this.reportWizard.colInfo[i].isColumnBreak();
                data[i][4] = this.reportWizard.colInfo[i].isColumnBreak();
                data[i][5] = this.reportWizard.colInfo[i].isColumnBreakValue();
                data[i][6] = ColInfo.AGGR[this.reportWizard.colInfo[i].getAggregation()];
                data[i][7] = this.getOrderText(this.reportWizard.colInfo[i].getOrderInfo());
                continue;
            }
            data[i][3] = i == firstVarCharCol;
            data[i][4] = i == lastVarCharCol;
            data[i][5] = i == lastNumericCol;
            data[i][6] = ColInfo.AGGR[this.getDefaultAggregationType(dataType[i])];
        }
        Object[] header = new String[]{LanguageEncoder.getText("Column Name"), LanguageEncoder.getText("Data Type"), LanguageEncoder.getText("Visible")};
        if (this.isMasterDetails()) {
            header = new String[]{LanguageEncoder.getText("Column Name"), LanguageEncoder.getText("Data Type"), LanguageEncoder.getText("Visible"), LanguageEncoder.getText("Master Field")};
        } else if (this.isSummary()) {
            header = new String[]{LanguageEncoder.getText("Column Name"), LanguageEncoder.getText("Data Type"), LanguageEncoder.getText("Visible"), LanguageEncoder.getText("Row Break"), LanguageEncoder.getText("Aggregation"), LanguageEncoder.getText("Repeat break field")};
        } else if (this.isCrossTab()) {
            header = new String[]{LanguageEncoder.getText("Column Name"), LanguageEncoder.getText("Data Type"), LanguageEncoder.getText("Visible"), LanguageEncoder.getText("Row Break"), LanguageEncoder.getText("Column Break"), LanguageEncoder.getText("Column Break Value"), LanguageEncoder.getText("Aggregation"), LanguageEncoder.getText("Order")};
        }
        this.table = new JTable(new MyTableModel(data, header));
        this.table.setGridColor(Color.lightGray);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        JTextField editableField = new JTextField();
        editableField.setHorizontalAlignment(2);
        DefaultCellEditor textEditor = new DefaultCellEditor(editableField);
        JTextField nonEditableField = new JTextField();
        nonEditableField.setEditable(false);
        nonEditableField.setHorizontalAlignment(2);
        DefaultCellEditor labelEditor = new DefaultCellEditor(nonEditableField);
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        DefaultCellEditor checkBoxEditor = new DefaultCellEditor(checkBox);
        checkBox.addItemListener(this);
        JComboBox<String> comboBox = new JComboBox<String>(ColInfo.AGGR);
        DefaultCellEditor comboBoxEditor = new DefaultCellEditor(comboBox);
        comboBox.addItemListener(this);
        JComboBox<String> orderComboBox = new JComboBox<String>(this.orderText);
        DefaultCellEditor orderComboBoxEditor = new DefaultCellEditor(orderComboBox);
        orderComboBox.addItemListener(this);
        MyRenderer myRenderer = new MyRenderer();
        for (int i2 = 0; i2 < nCol; ++i2) {
            this.table.getColumnModel().getColumn(i2).setCellRenderer(myRenderer);
        }
        this.table.getColumnModel().getColumn(0).setCellEditor(textEditor);
        this.table.getColumnModel().getColumn(1).setCellEditor(labelEditor);
        this.table.getColumnModel().getColumn(2).setCellEditor(checkBoxEditor);
        this.table.getColumnModel().getColumn(2).setMinWidth(30);
        if (this.isMasterDetails()) {
            this.table.getColumnModel().getColumn(3).setCellEditor(checkBoxEditor);
        } else if (this.isSummary()) {
            this.table.getColumnModel().getColumn(3).setCellEditor(checkBoxEditor);
            this.table.getColumnModel().getColumn(4).setCellEditor(comboBoxEditor);
            this.table.getColumnModel().getColumn(5).setCellEditor(checkBoxEditor);
        } else if (this.isCrossTab()) {
            this.table.getColumnModel().getColumn(3).setCellEditor(checkBoxEditor);
            this.table.getColumnModel().getColumn(4).setCellEditor(checkBoxEditor);
            this.table.getColumnModel().getColumn(5).setCellEditor(checkBoxEditor);
            this.table.getColumnModel().getColumn(6).setCellEditor(comboBoxEditor);
            this.table.getColumnModel().getColumn(7).setCellEditor(orderComboBoxEditor);
            this.table.getColumnModel().getColumn(3).setMinWidth(50);
            this.table.getColumnModel().getColumn(4).setMinWidth(50);
            this.table.getColumnModel().getColumn(5).setMinWidth(100);
        }
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.table);
        scroller.getViewport().setBackground(this.table.getBackground());
        topPanel.add("Center", scroller);
        if (this.isColumnar()) {
            JPanel columnarPanel = new JPanel();
            columnarPanel.setLayout(new FlowLayout(0));
            this.topN = new JCheckBox(LanguageEncoder.getText("Top N Report"), false);
            columnarPanel.add(this.topN);
            this.topN.addItemListener(this);
            columnarPanel.add(new JLabel(LanguageEncoder.getText("Column")));
            this.topNColumn = new JComboBox<String>(dataName);
            columnarPanel.add(this.topNColumn);
            columnarPanel.add(new JLabel(LanguageEncoder.getText("Number")));
            this.topNumber = new JTextField(5);
            columnarPanel.add(this.topNumber);
            this.topNOrder = new JComboBox<String>(new String[]{"Ascending", "Descending"});
            columnarPanel.add(this.topNOrder);
            if (this.isRedoDataMappingOp) {
                this.topN.setSelected(this.reportWizard.report.isTopNReport());
            }
            this.topNColumn.setEnabled(this.topN.isSelected());
            this.topNumber.setEnabled(this.topN.isSelected());
            this.topNOrder.setEnabled(this.topN.isSelected());
            if (this.topN.isSelected()) {
                this.topNColumn.setSelectedIndex(topNColumnIdx);
                this.topNumber.setText(this.reportWizard.report.getTopN() + "");
                this.topNOrder.setSelectedIndex(this.reportWizard.report.isAscending() ? 0 : 1);
            }
            topPanel.add("South", columnarPanel);
        } else if (this.isMasterDetails()) {
            JPanel mdPanel = new JPanel(new BorderLayout());
            JPanel pkPanel = new JPanel(new FlowLayout(0));
            pkPanel.add(new JLabel(LanguageEncoder.getText("Primary Key")));
            this.primaryKey = new JComboBox<String>(dataName);
            pkPanel.add(this.primaryKey);
            this.primaryKey.setSelectedIndex(primaryColumn);
            this.table.setValueAt(Boolean.TRUE, primaryColumn, 3);
            this.primaryKey.addItemListener(this);
            JPanel sbsPanel = new JPanel(new FlowLayout(0));
            this.sideBySide = new JCheckBox(LanguageEncoder.getText("Side-By-Side Layout"), false);
            if (this.isRedoDataMappingOp) {
                this.sideBySide.setSelected(this.reportWizard.sideBySide);
            }
            sbsPanel.add(this.sideBySide);
            JPanel topNPanel = new JPanel(new FlowLayout(0));
            this.topN = new JCheckBox(LanguageEncoder.getText("Top N Report"), false);
            topNPanel.add(this.topN);
            this.topN.addItemListener(this);
            topNPanel.add(new JLabel(LanguageEncoder.getText("Column")));
            this.topNColumn = new JComboBox<String>(dataName);
            topNPanel.add(this.topNColumn);
            topNPanel.add(new JLabel(LanguageEncoder.getText("Number")));
            this.topNumber = new JTextField(5);
            topNPanel.add(this.topNumber);
            this.topNOrder = new JComboBox<String>(new String[]{"Ascending", "Descending"});
            topNPanel.add(this.topNOrder);
            if (this.isRedoDataMappingOp) {
                this.topN.setSelected(this.reportWizard.report.isTopNReport());
            }
            this.topNColumn.setEnabled(this.topN.isSelected());
            this.topNumber.setEnabled(this.topN.isSelected());
            this.topNOrder.setEnabled(this.topN.isSelected());
            if (this.topN.isSelected()) {
                this.topNColumn.setSelectedIndex(topNColumnIdx);
                this.topNumber.setText(this.reportWizard.report.getTopN() + "");
                this.topNOrder.setSelectedIndex(this.reportWizard.report.isAscending() ? 0 : 1);
            }
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add("North", pkPanel);
            mdPanel.add("North", sbsPanel);
            mdPanel.add("Center", this.createKeepDataSourceOrderPanel());
            mdPanel.add("South", topNPanel);
            bottomPanel.add("South", mdPanel);
            topPanel.add("South", bottomPanel);
        } else if (this.isSummary()) {
            JPanel sbPanel = new JPanel(new BorderLayout());
            JPanel summaryPanel = new JPanel(new FlowLayout(0));
            this.performAgg = new JCheckBox(LanguageEncoder.getText("Perform Column Aggregation"), false);
            summaryPanel.add(this.performAgg);
            if (this.isRedoDataMappingOp) {
                this.performAgg.setSelected(perform_aggregation);
            }
            JPanel topNPanel = new JPanel(new FlowLayout(0));
            this.topN = new JCheckBox(LanguageEncoder.getText("Top N Report"), false);
            topNPanel.add(this.topN);
            this.topN.addItemListener(this);
            topNPanel.add(new JLabel(LanguageEncoder.getText("Column")));
            this.topNColumn = new JComboBox<String>(dataName);
            topNPanel.add(this.topNColumn);
            topNPanel.add(new JLabel(LanguageEncoder.getText("Number")));
            this.topNumber = new JTextField(5);
            topNPanel.add(this.topNumber);
            this.topNOrder = new JComboBox<String>(new String[]{"Ascending", "Descending"});
            topNPanel.add(this.topNOrder);
            if (this.isRedoDataMappingOp) {
                this.topN.setSelected(this.reportWizard.report.isTopNReport());
            }
            this.topNColumn.setEnabled(this.topN.isSelected());
            this.topNumber.setEnabled(this.topN.isSelected());
            this.topNOrder.setEnabled(this.topN.isSelected());
            if (this.topN.isSelected()) {
                this.topNColumn.setSelectedIndex(topNColumnIdx);
                this.topNumber.setText(this.reportWizard.report.getTopN() + "");
                this.topNOrder.setSelectedIndex(this.reportWizard.report.isAscending() ? 0 : 1);
            }
            sbPanel.add("North", summaryPanel);
            sbPanel.add("Center", this.createKeepDataSourceOrderPanel());
            sbPanel.add("South", topNPanel);
            topPanel.add("South", sbPanel);
        } else if (this.isCrossTab()) {
            JPanel reOrderColumns = new JPanel(new FlowLayout(0));
            this.checkBoxReOrderColumns = new JCheckBox(LanguageEncoder.getText(RE_ORDER_COLUMNS), true);
            reOrderColumns.add(this.checkBoxReOrderColumns);
            this.checkBoxReOrderColumns.addItemListener(this);
            JPanel rowAggregationGrandTotalPanel = new JPanel(new FlowLayout(0));
            this.showRowAggregationGrandTotal = new JCheckBox(ROW_AGGREGATION_GRAND_TOTAL, true);
            this.rowAggregationGrandTotalOnLeft = new JRadioButton(LEFT);
            this.rowAggregationGrandTotalOnRight = new JRadioButton(RIGHT);
            this.rowAggregationGrandTotalOnRight.setSelected(true);
            rowAggregationGrandTotalPanel.add(this.showRowAggregationGrandTotal);
            JPanel totalColumnPositionPanel = new JPanel(new FlowLayout(0));
            totalColumnPositionPanel.add(new JLabel(LanguageEncoder.getText(ROW_AGGREGATION_SUBTOTAL)));
            this.rowAggregationSubtotalHidden = new JRadioButton(HIDE);
            this.rowAggregationSubtotalOnLeft = new JRadioButton(LEFT);
            this.rowAggregationSubtotalOnRight = new JRadioButton(RIGHT);
            this.rowAggregationSubtotalOnRight.setSelected(true);
            ButtonGroup bg9 = new ButtonGroup();
            bg9.add(this.rowAggregationSubtotalHidden);
            bg9.add(this.rowAggregationSubtotalOnLeft);
            bg9.add(this.rowAggregationSubtotalOnRight);
            totalColumnPositionPanel.add(this.rowAggregationSubtotalHidden);
            totalColumnPositionPanel.add(this.rowAggregationSubtotalOnLeft);
            totalColumnPositionPanel.add(this.rowAggregationSubtotalOnRight);
            JPanel formulaPositionPanel = new JPanel(new FlowLayout(0));
            formulaPositionPanel.add(new JLabel(LanguageEncoder.getText(ROW_AGGREGATION)));
            this.columnAggregationHidden = new JRadioButton(LanguageEncoder.getText(HIDE));
            this.columnAggregationInHeader = new JRadioButton(HEADER);
            this.columnAggregationInFooter = new JRadioButton(FOOTER);
            this.columnAggregationInFooter.setSelected(true);
            ButtonGroup bg10 = new ButtonGroup();
            bg10.add(this.columnAggregationHidden);
            bg10.add(this.columnAggregationInHeader);
            bg10.add(this.columnAggregationInFooter);
            formulaPositionPanel.add(this.columnAggregationHidden);
            formulaPositionPanel.add(this.columnAggregationInHeader);
            formulaPositionPanel.add(this.columnAggregationInFooter);
            JPanel alignColumnBreakValuePanel = new JPanel(new FlowLayout(0));
            alignColumnBreakValuePanel.add(new JLabel(ALIGN_COLUMN_BREAK_VALUE));
            this.alignCrossTabColBkValVert = new JRadioButton(VERTICAL);
            this.alignCrossTabColBkValHori = new JRadioButton(HORIZONTAL);
            this.alignCrossTabColBkValHori.setSelected(true);
            ButtonGroup bg11 = new ButtonGroup();
            bg11.add(this.alignCrossTabColBkValVert);
            bg11.add(this.alignCrossTabColBkValHori);
            alignColumnBreakValuePanel.add(this.alignCrossTabColBkValVert);
            alignColumnBreakValuePanel.add(this.alignCrossTabColBkValHori);
            if (this.isRedoDataMappingOp) {
                this.setReOrderColumns();
                this.setRowAggregationGrandTotal();
                this.setRowAggregationSubtotal();
                if (this.reportWizard.isShowColumnAggregation()) {
                    if (this.reportWizard.isColumnAggregationInFooter()) {
                        this.columnAggregationInFooter.setSelected(true);
                    } else {
                        this.columnAggregationInHeader.setSelected(true);
                    }
                } else {
                    this.columnAggregationHidden.setSelected(true);
                }
                if (this.reportWizard.isAlignCrossTabColBkValHori()) {
                    this.alignCrossTabColBkValHori.setSelected(true);
                } else {
                    this.alignCrossTabColBkValVert.setSelected(true);
                }
            }
            JPanel crosstabPanel = new JPanel(new GridLayout(-1, 1));
            crosstabPanel.add(reOrderColumns);
            crosstabPanel.add(rowAggregationGrandTotalPanel);
            crosstabPanel.add(totalColumnPositionPanel);
            crosstabPanel.add(formulaPositionPanel);
            crosstabPanel.add(alignColumnBreakValuePanel);
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.add("North", this.createKeepDataSourceOrderPanel());
            bottomPanel.add("South", crosstabPanel);
            topPanel.add("South", bottomPanel);
        }
        this.add("Center", topPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        this.applyTemplate = new JCheckBox(LanguageEncoder.getText("Apply Template"), !this.isCrossTab() && !this.isMasterDetails());
        this.applyTemplate.setHorizontalTextPosition(2);
        this.applyTemplate.addItemListener(this);
        this.applyFormula = new JCheckBox(LanguageEncoder.getText("Apply Formula And Script"), false);
        this.applyFormula.setEnabled(this.applyTemplate.isSelected());
        this.applyFormula.setHorizontalTextPosition(2);
        this.done = new JButton(LanguageEncoder.getText("Done"));
        this.next = new JButton(LanguageEncoder.getText("Next >>"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.back = new JButton(LanguageEncoder.getText("<< Back"));
        if (this.isRedoDataMappingOp || this.enableApplyTemplate) {
            buttonPanel.add(this.applyTemplate);
            buttonPanel.add(this.applyFormula);
        }
        buttonPanel.add(this.back);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.done);
        if (!this.reportWizard.reportmain.isSkipPredefinedTemplatesStep()) {
            buttonPanel.add(this.next);
        }
        this.cancel.addActionListener(this);
        this.back.addActionListener(this);
        this.done.addActionListener(this);
        this.next.addActionListener(this);
        if (this.isMailingLabels()) {
            this.next.setEnabled(false);
        }
        this.add("South", buttonPanel);
    }

    private void setRowAggregationSubtotal() {
        if (this.reportWizard.isShowRowAggregationSubtotal()) {
            if (this.reportWizard.isRowAggregationSubtotalOnLeft()) {
                this.rowAggregationSubtotalOnLeft.setSelected(true);
            } else {
                this.rowAggregationSubtotalOnRight.setSelected(true);
            }
        } else {
            this.rowAggregationSubtotalHidden.setSelected(true);
        }
    }

    private void setRowAggregationGrandTotal() {
        this.showRowAggregationGrandTotal.setSelected(this.reportWizard.isShowRowAggregationGrandTotal());
    }

    private void setReOrderColumns() {
        this.checkBoxReOrderColumns.setSelected(this.reportWizard.isReOrderColumns());
    }

    private JPanel createKeepDataSourceOrderPanel() {
        JPanel keepPanel = new JPanel(new FlowLayout(0));
        this.keepDataSourceOrder = new JCheckBox(LanguageEncoder.getText("Keep Data Source Order"), true);
        keepPanel.add(this.keepDataSourceOrder);
        this.keepDataSourceOrder.addItemListener(this);
        if (this.isRedoDataMappingOp) {
            this.keepDataSourceOrder.setSelected(this.reportWizard.report.isKeepDataSourceOrder());
        }
        if (this.isCrossTab()) {
            this.keepDataSourceOrder.setHorizontalTextPosition(2);
        }
        return keepPanel;
    }

    private int getDefaultAggregationType(int datatype) {
        if (!this.isCrossTab()) {
            return 0;
        }
        if (DataType.isNumeric(datatype)) {
            return 1;
        }
        return 7;
    }

    private boolean isColumnar() {
        return this.reportWizard.reportType == 0;
    }

    private boolean isMailingLabels() {
        return this.reportWizard.reportType == 4;
    }

    private boolean isSummary() {
        return this.reportWizard.reportType == 1;
    }

    private boolean isCrossTab() {
        return this.reportWizard.reportType == 2;
    }

    private boolean isMasterDetails() {
        return this.reportWizard.reportType == 3;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.topN) {
            this.topNColumn.setEnabled(this.topN.isSelected());
            this.topNumber.setEnabled(this.topN.isSelected());
            this.topNOrder.setEnabled(this.topN.isSelected());
        } else if (e.getSource() == this.keepDataSourceOrder && this.topN != null) {
            this.topN.setEnabled(!this.keepDataSourceOrder.isSelected());
            if (this.keepDataSourceOrder.isSelected()) {
                this.topN.setSelected(false);
            }
        } else if (e.getSource() == this.applyTemplate) {
            this.applyFormula.setEnabled(this.applyTemplate.isSelected());
        } else if (e.getSource() instanceof JCheckBox) {
            int row = 0;
            int column = 0;
            if (this.table.isEditing()) {
                row = this.table.getEditingRow();
                column = this.table.getEditingColumn();
            }
            try {
                this.table.editCellAt(-1, -1);
                this.table.clearSelection();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot reset selection", ex);
            }
            this.table.repaint();
            if ((column == 3 || column == 4 || column == 5) && ((Boolean)this.table.getValueAt(row, column)).booleanValue() && this.isCrossTab()) {
                this.table.setValueAt(Boolean.FALSE, row, (column - 3 + 1) % 3 + 3);
                this.table.setValueAt(Boolean.FALSE, row, (column - 3 + 2) % 3 + 3);
                this.table.repaint();
            }
            if (this.isCrossTab()) {
                boolean check;
                if ((column == 4 || column == 5) && (check = ((Boolean)this.table.getValueAt(row, column)).booleanValue())) {
                    this.table.setValueAt(Boolean.TRUE, row, 2);
                }
                if (column == 2 && !(check = ((Boolean)this.table.getValueAt(row, column)).booleanValue())) {
                    this.table.setValueAt(Boolean.FALSE, row, 3);
                    this.table.setValueAt(Boolean.FALSE, row, 4);
                    this.table.setValueAt(Boolean.FALSE, row, 5);
                }
                this.table.repaint();
            }
        } else if (e.getSource() instanceof JComboBox && this.isCrossTab()) {
            int column = 0;
            if (this.table.isEditing()) {
                column = this.table.getEditingColumn();
            }
            if (column == 7) {
                return;
            }
            JComboBox combobox = (JComboBox)e.getSource();
            if (combobox.getItemCount() == ColInfo.AGGR.length && combobox.getSelectedIndex() == 0) {
                combobox.setSelectedIndex(this.defaultAGGR);
            }
        } else if (e.getSource() instanceof JComboBox && this.isMasterDetails()) {
            try {
                this.table.editCellAt(-1, -1);
                this.table.clearSelection();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot reset selection", ex);
            }
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        }
    }

    private boolean isAggCol() {
        if (this.performAgg == null) {
            return true;
        }
        return this.performAgg.isSelected();
    }

    public void setNextPanel(JPanel nextPanel) {
        this.nextPanel = nextPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.reportWizard.cancel();
        }
        if (target == this.back) {
            if (this.isRedoDataMappingOp) {
                this.reportWizard.swapPanel(this, new ReportMapping(this.reportWizard, this.isRedoDataMappingOp));
            } else {
                this.reportWizard.swapPanel(this, this.prevPanel);
            }
        } else if (target == this.done || target == this.next) {
            try {
                int i;
                if (!(!this.isRedoDataMappingOp && !this.enableApplyTemplate || target != this.next && this.applyTemplate.isSelected())) {
                    int selection = -1;
                    if (target == this.done && !this.applyTemplate.isSelected()) {
                        selection = JOptionPane.showConfirmDialog(this, LanguageEncoder.getText("Format and options will be lost if you choose to not apply template.  Would you like to continue?"), LanguageEncoder.getText("Warning!"), 0, 3);
                    } else if (target == this.next) {
                        selection = JOptionPane.showConfirmDialog(this, LanguageEncoder.getText("Format and options will be lost.  Would you like to continue?"), LanguageEncoder.getText("Warning!"), 0, 3);
                    }
                    if (selection != 0) {
                        return;
                    }
                }
                TableModel model = this.table.getModel();
                short colBreakValAggr = 7;
                ColInfo[] newcolInfo = new ColInfo[this.reportWizard.colInfo.length];
                for (i = 0; i < newcolInfo.length; ++i) {
                    newcolInfo[i] = (ColInfo)this.reportWizard.colInfo[i].clone();
                }
                for (i = 0; i < model.getRowCount(); ++i) {
                    ColData coldata = this.reportWizard.colData[newcolInfo[i].getMapping()];
                    newcolInfo[i].setDBTableName(coldata.getTableName());
                    newcolInfo[i].setName((String)model.getValueAt(i, 0));
                    newcolInfo[i].setVisible((Boolean)model.getValueAt(i, 2));
                    if (this.isColumnar() || this.isMailingLabels()) {
                        newcolInfo[i].setMaster(false);
                        newcolInfo[i].setRowBreak(false);
                        newcolInfo[i].setColumnBreak(false);
                        newcolInfo[i].setColumnBreakValue(false);
                        newcolInfo[i].setAggregation(false, (short)0);
                        continue;
                    }
                    if (this.isMasterDetails()) {
                        newcolInfo[i].setRowBreak(false);
                        newcolInfo[i].setColumnBreak(false);
                        newcolInfo[i].setColumnBreakValue(false);
                        newcolInfo[i].setAggregation(false, (short)0);
                        newcolInfo[i].setMaster((Boolean)model.getValueAt(i, 3));
                        continue;
                    }
                    if (this.isCrossTab() && ((Boolean)model.getValueAt(i, 4)).booleanValue()) {
                        newcolInfo[i].setColumnBreakValue(false);
                        newcolInfo[i].setRowBreak(false);
                        newcolInfo[i].setColumnBreak(true);
                        colBreakValAggr = (short)this.getAggrIndex((String)model.getValueAt(i, 6));
                        newcolInfo[i].setAggregation(colBreakValAggr);
                        newcolInfo[i].setOrderInfo(this.getOrderIndex((String)model.getValueAt(i, 7)));
                        continue;
                    }
                    if (this.isCrossTab() && ((Boolean)model.getValueAt(i, 5)).booleanValue()) {
                        colBreakValAggr = (short)this.getAggrIndex((String)model.getValueAt(i, 6));
                        newcolInfo[i].setColumnBreak(false);
                        newcolInfo[i].setRowBreak(false);
                        newcolInfo[i].setColumnBreakValue(true);
                        newcolInfo[i].setAggregation(colBreakValAggr);
                        continue;
                    }
                    if (((Boolean)model.getValueAt(i, 3)).booleanValue()) {
                        newcolInfo[i].setColumnBreak(false);
                        newcolInfo[i].setColumnBreakValue(false);
                        newcolInfo[i].setRowBreak(true);
                        if (!this.isSummary()) continue;
                        newcolInfo[i].setRepeatBreakField((Boolean)model.getValueAt(i, 5));
                        continue;
                    }
                    newcolInfo[i].setColumnBreak(false);
                    newcolInfo[i].setColumnBreakValue(false);
                    newcolInfo[i].setRowBreak(false);
                    if (this.isCrossTab()) {
                        newcolInfo[i].setAggregation(this.isAggCol(), (short)this.getAggrIndex((String)model.getValueAt(i, 6)));
                        continue;
                    }
                    newcolInfo[i].setAggregation(this.isAggCol(), (short)this.getAggrIndex((String)model.getValueAt(i, 4)));
                }
                if (this.isMasterDetails()) {
                    newcolInfo[this.primaryKey.getSelectedIndex()].setPrimaryKey(true);
                    if (this.isRedoDataMappingOp && !this.reportWizard.isModified() && this.reportWizard.sideBySide != this.sideBySide.isSelected()) {
                        this.reportWizard.setModified();
                    }
                    this.reportWizard.sideBySide = this.sideBySide.isSelected();
                }
                boolean crossTabAttrChanged = false;
                if (this.isCrossTab()) {
                    if (this.checkBoxReOrderColumns.isSelected()) {
                        newcolInfo = this.reorderColInfoForCrosstabs(newcolInfo);
                    }
                    this.reportWizard.setModified();
                    crossTabAttrChanged = true;
                    this.reportWizard.setReOrderColumns(this.checkBoxReOrderColumns.isSelected());
                    this.reportWizard.setShowRowAggregationGrandTotal(this.showRowAggregationGrandTotal.isSelected());
                    this.reportWizard.setShowRowAggregationSubtotal(!this.rowAggregationSubtotalHidden.isSelected());
                    this.reportWizard.setRowAggregationSubtotalOnLeft(this.rowAggregationSubtotalOnLeft.isSelected());
                    this.reportWizard.setRowAggregationGrandTotalOnLeft(this.rowAggregationGrandTotalOnLeft.isSelected());
                    this.reportWizard.setShowColumnAggregation(!this.columnAggregationHidden.isSelected());
                    this.reportWizard.setColumnAggregationInFooter(this.columnAggregationInFooter.isSelected());
                    this.reportWizard.setAlignCrossTabColBkValHori(this.alignCrossTabColBkValHori.isSelected());
                }
                if (this.keepDataSourceOrder != null) {
                    this.reportWizard.keepDataSourceOrder = this.keepDataSourceOrder.isSelected();
                }
                boolean keepDataSourceOrderChanged = false;
                if (this.isRedoDataMappingOp) {
                    if (!this.reportWizard.isModified()) {
                        for (int i2 = 0; i2 < newcolInfo.length; ++i2) {
                            if (newcolInfo[i2].equals(this.reportWizard.colInfo[i2])) continue;
                            this.reportWizard.setModified();
                        }
                    }
                    if (this.topN != null) {
                        for (ColInfo element : newcolInfo) {
                            element.setTopN(false);
                            this.reportWizard.report.setTopN(0);
                            this.reportWizard.setModified();
                        }
                    }
                    if (this.keepDataSourceOrder != null && this.keepDataSourceOrder.isSelected() != this.reportWizard.report.isKeepDataSourceOrder()) {
                        this.reportWizard.report.setKeepDataSourceOrder(this.keepDataSourceOrder.isSelected());
                        keepDataSourceOrderChanged = true;
                        this.reportWizard.setModified();
                    }
                    if (this.reportWizard.report.getQueryParameters() != null && this.reportWizard.report.getQueryParameters().size() > 0) {
                        this.reportWizard.queryParameters = this.reportWizard.report.getQueryParameters();
                        this.reportWizard.setModified();
                    }
                }
                if (this.isRedoDataMappingOp || this.enableApplyTemplate) {
                    this.reportWizard.setApplyTemplate(this.applyTemplate.isSelected());
                    if (this.applyTemplate.isSelected()) {
                        this.reportWizard.setApplyFormula(this.applyFormula.isSelected());
                    } else {
                        this.reportWizard.setApplyFormula(false);
                    }
                    if (!this.applyTemplate.isSelected() || !this.applyFormula.isSelected()) {
                        this.reportWizard.setModified();
                    }
                }
                if (this.topN != null && this.topN.isSelected()) {
                    int number = 0;
                    try {
                        number = Integer.parseInt(this.topNumber.getText());
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.FINEST, "Top N: Invalid number", ex);
                        new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Top N number must be an integer greater than 0"));
                        return;
                    }
                    if (number <= 0) {
                        new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Top N number must be an integer greater than 0"));
                        return;
                    }
                    newcolInfo[this.topNColumn.getSelectedIndex()].setTopN(true);
                    this.reportWizard.setTopN(Integer.parseInt(this.topNumber.getText()));
                    this.reportWizard.setAscending(this.topNOrder.getSelectedIndex() == 0);
                    this.reportWizard.setModified();
                }
                boolean redoColInfo = true;
                if (!crossTabAttrChanged && this.isRedoDataMappingOp && !this.reportWizard.redoReport()) {
                    redoColInfo = this.reportWizard.redoColInfo(newcolInfo);
                }
                if (redoColInfo) {
                    this.reportWizard.colInfo = newcolInfo;
                }
                Report report = null;
                int style = -1;
                if (this.reportWizard.report != null) {
                    this.reportWizard.allowPreviewEdit = this.reportWizard.report.allowPreviewEdit;
                    style = this.reportWizard.report.reportStyle;
                }
                if (redoColInfo || keepDataSourceOrderChanged || this.isMasterDetails()) {
                    report = this.reportWizard.createReport(style);
                    if (this.reportWizard.applyFormula && this.reportWizard.report != null) {
                        Vector<Formula> formulas;
                        report.formulas = formulas = this.reportWizard.report.formulas;
                    }
                } else {
                    report = this.reportWizard.reUseReport();
                    report.reportStyle = style;
                }
                if (this.reportWizard.report != null) {
                    int tc1 = report.getReportTables().elementAt(0).getColumnCount();
                    int tc2 = this.reportWizard.report.getReportTables().elementAt(0).getColumnCount();
                    for (int i3 = 0; i3 < tc1; ++i3) {
                        for (int j = 0; j < tc2; ++j) {
                            if (this.reportWizard.report.getReportTables().elementAt(0).getColumn(j).getDrillDownName() == null || !report.getReportTables().elementAt(0).getColumn(i3).getText().equalsIgnoreCase(this.reportWizard.report.getReportTables().elementAt(0).getColumn(j).getText())) continue;
                            report.getReportTables().elementAt(0).getColumn(i3).setDrillDownName(this.reportWizard.report.getReportTables().elementAt(0).getColumn(j).getDrillDownName());
                        }
                    }
                }
                this.reportWizard.report = report;
                if (target == this.next) {
                    this.reportWizard.applyTemplate = false;
                    if (this.nextPanel == null) {
                        this.nextPanel = new PreSelectReportElement(this.reportWizard, this);
                    }
                    this.reportWizard.swapPanel(this, this.nextPanel);
                } else if (this.isRedoDataMappingOp && !this.reportWizard.isModified()) {
                    LOGGER.finest("Cancel report wizard");
                    this.reportWizard.cancel();
                } else if (!this.isRedoDataMappingOp && !(this.reportWizard instanceof UpdateDataSourceWizard)) {
                    this.reportWizard.doneWizard(report, false);
                    this.reportWizard.formatReport(report.reportStyle);
                    this.reportWizard.reportmain.autoFitColumns();
                } else {
                    this.reportWizard.doneWizard(report);
                    if (!this.reportWizard.reportmain.isDesignMode() && this.reportWizard.reportmain.report.isCrossTabFixedField()) {
                        this.reportWizard.reportmain.do_retrieveWithoutDataUpdate(false);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Cannot create report", ex);
                this.resetColInfo();
                String str = LanguageEncoder.getText("Cannot create report!") + " " + ex.getMessage();
                new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                return;
            }
        }
    }

    private ColInfo[] reorderColInfoForCrosstabs(ColInfo[] newcolInfo) {
        int numberOfRowBreaks = 0;
        int numberOfColBreaks = 0;
        ArrayList<ColInfo> colInfos = new ArrayList<ColInfo>();
        for (ColInfo clInfo : newcolInfo) {
            if (clInfo.isRowBreak()) {
                colInfos.add(numberOfRowBreaks, clInfo);
                ++numberOfRowBreaks;
                continue;
            }
            if (clInfo.isColumnBreak()) {
                colInfos.add(numberOfRowBreaks + numberOfColBreaks, clInfo);
                ++numberOfColBreaks;
                continue;
            }
            colInfos.add(clInfo);
        }
        newcolInfo = colInfos.toArray(new ColInfo[0]);
        return newcolInfo;
    }

    private void resetColInfo() {
        for (ColInfo element : this.reportWizard.colInfo) {
            element.setName(this.reportWizard.colData[element.getMapping()].getName());
            element.setMaster(false);
            element.setVisible(true);
            element.setRowBreak(false);
            element.setColumnBreak(false);
            element.setColumnBreakValue(false);
            element.setAggregation(false, (short)0);
        }
    }

    private int getAggrIndex(String str) {
        if (this.isCrossTab() && ColInfo.AGGR[0].equals(str)) {
            return this.defaultAGGR;
        }
        for (int i = 0; i < ColInfo.AGGR.length; ++i) {
            if (!ColInfo.AGGR[i].equals(str)) continue;
            return i;
        }
        return this.defaultAGGR;
    }

    private int getOrderIndex(String str) {
        if (str == null || str.equals("not sorted")) {
            return 0;
        }
        if (str.equals("ascending")) {
            return 1;
        }
        return 2;
    }

    private String getOrderText(int i) {
        if (i == 0) {
            return "not sorted";
        }
        if (i == 1) {
            return "ascending";
        }
        return "descending";
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private boolean[][] editableMap;

        public MyTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
            this.editableMap = new boolean[data.length][data[0].length];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.editableMap[row][column];
        }

        public void setCellEditable(boolean state, int row, int column) {
            this.editableMap[row][column] = state;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
        }
    }

    private class MyRenderer
    implements TableCellRenderer {
        private JTextField text = new JTextField("TEMP");

        private MyRenderer() {
        }

        private boolean setEnabled(JComponent comp, int row, int col) {
            if (ColInfoMappingPanel.this.isMasterDetails()) {
                if ((col == 2 || col == 3) && ColInfoMappingPanel.this.primaryKey.getSelectedIndex() == row) {
                    comp.setEnabled(false);
                    return false;
                }
                if (col == 2 && ((Boolean)ColInfoMappingPanel.this.table.getModel().getValueAt(row, 3)).booleanValue()) {
                    comp.setEnabled(false);
                    return false;
                }
            }
            return true;
        }

        private String getName(Object obj, int col) {
            if (!ColInfoMappingPanel.this.isCrossTab() || col != 0) {
                if (obj != null) {
                    return obj.toString();
                }
                return "null";
            }
            return obj.toString();
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 2 || column == 3 || column == 5 || column == 4 && ColInfoMappingPanel.this.isCrossTab()) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setOpaque(true);
                checkBox.setHorizontalAlignment(0);
                checkBox.setSelected((Boolean)value);
                if (isSelected) {
                    checkBox.setBackground(this.text.getSelectionColor());
                    checkBox.setForeground(this.text.getSelectedTextColor());
                } else {
                    checkBox.setBackground(this.text.getBackground());
                    checkBox.setForeground(this.text.getForeground());
                }
                if (ColInfoMappingPanel.this.table.getModel() instanceof MyTableModel) {
                    ((MyTableModel)ColInfoMappingPanel.this.table.getModel()).setCellEditable(this.setEnabled(checkBox, row, column), row, column);
                } else {
                    this.setEnabled(checkBox, row, column);
                }
                return checkBox;
            }
            if (column == 7) {
                JComboBox<String> comboBox = new JComboBox<String>(ColInfoMappingPanel.this.orderText);
                comboBox.setSelectedIndex(ColInfoMappingPanel.this.getOrderIndex((String)value));
                if (isSelected) {
                    comboBox.setBackground(this.text.getSelectionColor());
                    comboBox.setForeground(this.text.getForeground());
                } else {
                    comboBox.setBackground(this.text.getBackground());
                    comboBox.setForeground(this.text.getForeground());
                }
                boolean enabled = false;
                enabled = (Boolean)ColInfoMappingPanel.this.table.getModel().getValueAt(row, 4);
                comboBox.setEnabled(enabled);
                if (ColInfoMappingPanel.this.table.getModel() instanceof MyTableModel) {
                    ((MyTableModel)ColInfoMappingPanel.this.table.getModel()).setCellEditable(enabled, row, column);
                    if (!this.setEnabled(comboBox, row, column)) {
                        ((MyTableModel)ColInfoMappingPanel.this.table.getModel()).setCellEditable(false, row, column);
                    }
                } else {
                    this.setEnabled(comboBox, row, column);
                }
                return comboBox;
            }
            if (column == 4 || column == 6) {
                JComboBox<String> comboBox = new JComboBox<String>(ColInfo.AGGR);
                comboBox.setSelectedIndex(ColInfoMappingPanel.this.getAggrIndex((String)value));
                if (isSelected) {
                    comboBox.setBackground(this.text.getSelectionColor());
                    comboBox.setForeground(this.text.getForeground());
                } else {
                    comboBox.setBackground(this.text.getBackground());
                    comboBox.setForeground(this.text.getForeground());
                }
                boolean enabled = false;
                enabled = ColInfoMappingPanel.this.isCrossTab() ? (Boolean)ColInfoMappingPanel.this.table.getModel().getValueAt(row, 3) == false && (Boolean)ColInfoMappingPanel.this.table.getModel().getValueAt(row, 4) == false : (Boolean)ColInfoMappingPanel.this.table.getModel().getValueAt(row, 3) == false;
                comboBox.setEnabled(enabled);
                if (ColInfoMappingPanel.this.table.getModel() instanceof MyTableModel) {
                    ((MyTableModel)ColInfoMappingPanel.this.table.getModel()).setCellEditable(enabled, row, column);
                    if (!this.setEnabled(comboBox, row, column)) {
                        ((MyTableModel)ColInfoMappingPanel.this.table.getModel()).setCellEditable(false, row, column);
                    }
                } else {
                    this.setEnabled(comboBox, row, column);
                }
                return comboBox;
            }
            JLabel label = new JLabel(this.getName(value, column));
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(this.text.getSelectionColor());
                label.setForeground(this.text.getSelectedTextColor());
            } else {
                label.setBackground(ColInfoMappingPanel.this.table.getBackground());
                label.setForeground(ColInfoMappingPanel.this.table.getForeground());
            }
            return label;
        }
    }
}

