/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IReportTypeConstants;

public class ColInfoResultPanel
extends JPanel
implements IReportTypeConstants {
    JScrollPane scroller;

    public ColInfoResultPanel(Report report, ReportTable rtable) {
        Object[] title = new String[]{LanguageEncoder.getText("Index"), LanguageEncoder.getText("Column ID"), LanguageEncoder.getText("Column Name"), LanguageEncoder.getText("Data Type"), LanguageEncoder.getText("Column Type"), LanguageEncoder.getText("Visible")};
        Object[][] data = new String[rtable.getColumnCount()][6];
        for (int i = 0; i < rtable.getColumnCount(); ++i) {
            ReportColumn col = rtable.getColumn(i);
            int colInfoIndex = report.getColInfoIndex(col);
            data[i][0] = i + "";
            data[i][1] = col.getID();
            data[i][2] = col.getText();
            data[i][3] = DataType.getTypeName(report.getSQLType(colInfoIndex));
            data[i][4] = report.getColumnType(colInfoIndex);
            data[i][5] = col.isVisible() ? LanguageEncoder.getText("Yes") : LanguageEncoder.getText("No");
        }
        JTable table = new JTable(data, title);
        table.setGridColor(Color.lightGray);
        table.setCellSelectionEnabled(true);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor noEditor = new DefaultCellEditor(notEditableField);
        table.setCellEditor(noEditor);
        MyRenderer myRenderer = new MyRenderer();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).setCellRenderer(myRenderer);
            table.getColumnModel().getColumn(i).setCellEditor(noEditor);
        }
        this.scroller = new JScrollPane();
        this.scroller.getViewport().add(table);
        this.scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", this.scroller);
    }

    private class MyRenderer
    implements TableCellRenderer {
        private JTextField text = new JTextField(LanguageEncoder.getText("TEMP"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                return new JButton(value.toString());
            }
            JLabel label = new JLabel(value.toString());
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(this.text.getSelectionColor());
                label.setForeground(this.text.getSelectedTextColor());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            return label;
        }
    }
}

