/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.HexPanel;
import quadbase.common.swing.HexUpdateEvent;
import quadbase.common.swing.HexUpdateEventListener;
import quadbase.common.swing.JRGBChooserPanel;
import quadbase.common.swing.JSwatchChooserPanel;
import quadbase.common.swing.color.DefaultHSBChooserPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ColorDialog
extends JDialog
implements ActionListener,
ItemListener,
HexUpdateEventListener {
    private static final Logger LOGGER = Logger.getLogger(ColorDialog.class.getName());
    ColorButton colorButton;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox transparentCheck;
    private HexPanel hexPanel;
    private ReportMain reportMain;
    private boolean isTransparentEnabled = false;
    private Color initColor;
    private Color currentColor;
    private boolean isTransparent = false;
    private int option;
    private int row = 0;
    private Vector<Integer> tree;
    private boolean modified = false;
    private boolean forLine = false;

    public ColorDialog(ReportMain reportMain, boolean isTransparentEnabled, int option, Color initColor) {
        this(reportMain, isTransparentEnabled, option, initColor, 0, null);
    }

    public ColorDialog(ReportMain reportMain, boolean isTransparentEnabled, int option, Color initColor, int row, Vector<Integer> tree) {
        this(reportMain, isTransparentEnabled, option, initColor, row, tree, false);
    }

    public ColorDialog(ReportMain reportMain, boolean isTransparentEnabled, int option, Color initColor, int row, Vector<Integer> tree, boolean forLine) {
        super(reportMain, LanguageEncoder.getText("Set Color ..."), true);
        this.reportMain = reportMain;
        this.isTransparentEnabled = isTransparentEnabled;
        this.option = option;
        this.initColor = initColor;
        this.row = row;
        this.tree = tree;
        this.forLine = forLine;
        Color color = this.currentColor = initColor == null ? null : new Color(initColor.getRGB());
        if (option == 2) {
            Color color2 = this.currentColor = initColor == null ? Color.black : new Color(initColor.getRGB());
        }
        if (isTransparentEnabled) {
            this.init();
            this.setPosition();
        }
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BorderLayout());
        colorPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Set Color ...")));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Current Color :")));
        this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
        p1.add(this.colorButton);
        this.colorButton.addActionListener(this);
        this.hexPanel = new HexPanel(this.currentColor);
        this.hexPanel.addHexUpdateEventListener(this);
        boolean bl = this.isTransparent = this.currentColor == null;
        if (!this.isTransparent) {
            this.setColor(this.currentColor);
        }
        this.transparentCheck = new JCheckBox(LanguageEncoder.getText("Transparent"), this.isTransparent);
        p1.add(this.transparentCheck);
        this.transparentCheck.addItemListener(this);
        this.colorButton.setEnabled(!this.isTransparent);
        this.hexPanel.getTxtHexCode().setEnabled(!this.isTransparent);
        colorPanel.add("Center", p1);
        colorPanel.add("South", this.hexPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", colorPanel);
        contentPane.add("South", p2);
        this.pack();
    }

    public Color getColor() {
        if (this.isTransparent) {
            return null;
        }
        return this.currentColor;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.setButtonColor(color);
        if (!this.hexPanel.isHexField() && !color.equals(this.hexPanel.getUpdatedColor())) {
            this.hexPanel.updateTxtHexcode(color);
        }
    }

    private Color getButtonColor() {
        return this.colorButton.getColor();
    }

    private void setButtonColor(Color color) {
        this.colorButton.setColor(color);
    }

    public void setDialogVisible(boolean b) {
        if (this.isTransparentEnabled) {
            super.setVisible(b);
        } else {
            this.currentColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Color ..."), this.currentColor);
            if (this.currentColor == null) {
                this.currentColor = this.initColor;
            }
            if (this.reportMain.groupFormatFlag()) {
                this.reportMain.designPanel.rulerPanel.groupFormatSetFontColor(this.getColor());
                this.reportMain.setModified();
            } else {
                this.reportMain.selectedObject.setFontColor(this.getColor());
                this.reportMain.setModified();
                this.reportMain.selectedPanel.repaintPanel();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.colorButton.setEnabled(!this.transparentCheck.isSelected());
        this.hexPanel.getTxtHexCode().setEnabled(!this.transparentCheck.isSelected());
        this.isTransparent = this.transparentCheck.isSelected();
        if (!this.isTransparent && !this.getButtonColor().equals(this.hexPanel.getUpdatedColor())) {
            this.hexPanel.updateTxtHexcode(this.getButtonColor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hexPanel.setIsHexField(false);
        if (e.getSource() == this.colorButton) {
            this.currentColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Color ..."), this.getButtonColor());
            this.setColor(this.currentColor);
        }
        if (e.getSource() == this.okButton) {
            this.isTransparent = this.transparentCheck.isSelected();
            this.currentColor = this.getButtonColor();
            this.reportMain.addRecentColor(this.currentColor);
            if (this.option == 2) {
                if (this.reportMain.groupFormatFlag()) {
                    if (this.reportMain.isDesignMode) {
                        this.reportMain.designPanel.rulerPanel.groupFormatSetFontColor(this.getColor());
                    }
                    this.reportMain.setModified();
                } else {
                    if (this.reportMain.isDesignMode) {
                        this.reportMain.selectedObject.setFontColor(this.getColor());
                    } else if (this.reportMain.selectedObject instanceof ReportCell) {
                        ReportElement elt = this.reportMain.selectedPanel.getElement();
                        if (elt instanceof ReportTable) {
                            this.reportMain.selectedObject.setFontColor(this.getColor());
                        } else if (elt instanceof ReportSection) {
                            if (((ReportSection)elt).hasSectionCell((ReportCell)this.reportMain.selectedObject, this.tree) || ((ReportSection)elt).hasFormattedCell((ReportCell)this.reportMain.selectedObject, this.tree)) {
                                this.reportMain.selectedObject.setFontColor(this.getColor());
                            } else if (this.reportMain.selectedObject instanceof ColumnHeader) {
                                ColumnHeader newCell = new ColumnHeader();
                                newCell.copy((ColumnHeader)this.reportMain.selectedObject);
                                newCell.setFontColor(this.getColor());
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            } else {
                                ReportCell newCell = new ReportCell();
                                newCell.copy((ReportCell)this.reportMain.selectedObject);
                                newCell.setFontColor(this.getColor());
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            }
                        }
                    } else if (this.reportMain.selectedObject instanceof ReportColumn) {
                        try {
                            ReportElement relt = ((ReportColumn)this.reportMain.selectedObject).getFormatCell(this.row);
                            if (relt instanceof ReportCell) {
                                int i;
                                ReportTable mainTable;
                                FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                                cell.setFontColor(this.getColor());
                                ((ReportColumn)this.reportMain.selectedObject).addFormattedCell(cell);
                                ReportTable table = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                                for (i = 0; i < this.tree.size(); ++i) {
                                    if (!(table instanceof ReportTreeTable)) continue;
                                    table = ((ReportTreeTable)table).getSubTable(this.tree.elementAt(i));
                                }
                                for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.reportMain.selectedObject; ++i) {
                                }
                                mainTable.getColumn(i).addFormattedCell(this.row, this.tree, cell);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to perform action with report column", ex);
                        }
                    }
                    this.reportMain.setModified();
                    this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                }
            } else if (this.option == 1) {
                if (this.reportMain.groupFormatFlag()) {
                    if (this.reportMain.isDesignMode) {
                        this.reportMain.designPanel.rulerPanel.groupFormatSetBackgroundColor(this.getColor(), this.forLine);
                    }
                    this.reportMain.setModified();
                } else {
                    if (this.reportMain.isDesignMode) {
                        ReportUtil.setBgColor(this.reportMain.selectedObject, this.getColor(), this.forLine);
                    } else if (this.reportMain.selectedObject instanceof ReportCell) {
                        ReportElement elt = this.reportMain.selectedPanel.getElement();
                        if (elt instanceof ReportTable) {
                            ReportUtil.setBgColor(this.reportMain.selectedObject, this.getColor(), this.forLine);
                        } else if (elt instanceof ReportSection) {
                            if (((ReportSection)elt).hasSectionCell((ReportCell)this.reportMain.selectedObject, this.tree) || ((ReportSection)elt).hasFormattedCell((ReportCell)this.reportMain.selectedObject, this.tree)) {
                                ReportUtil.setBgColor(this.reportMain.selectedObject, this.getColor(), this.forLine);
                            } else if (this.reportMain.selectedObject instanceof ColumnHeader) {
                                ColumnHeader newCell = new ColumnHeader();
                                newCell.copy((ColumnHeader)this.reportMain.selectedObject);
                                ReportUtil.setBgColor(newCell, this.getColor(), this.forLine);
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            } else {
                                ReportCell newCell = new ReportCell();
                                newCell.copy((ReportCell)this.reportMain.selectedObject);
                                ReportUtil.setBgColor(newCell, this.getColor(), this.forLine);
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            }
                        }
                    } else if (this.reportMain.selectedObject instanceof ReportColumn) {
                        try {
                            ReportElement relt = ((ReportColumn)this.reportMain.selectedObject).getFormatCell(this.row);
                            if (relt instanceof ReportCell) {
                                int i;
                                ReportTable mainTable;
                                FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                                ReportUtil.setBgColor(cell, this.getColor(), this.forLine);
                                ((ReportColumn)this.reportMain.selectedObject).addFormattedCell(cell);
                                ReportTable table = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                                for (i = 0; i < this.tree.size(); ++i) {
                                    if (!(table instanceof ReportTreeTable)) continue;
                                    table = ((ReportTreeTable)table).getSubTable(this.tree.elementAt(i));
                                }
                                for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.reportMain.selectedObject; ++i) {
                                }
                                mainTable.getColumn(i).addFormattedCell(this.row, this.tree, cell);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to perform action with report column", ex);
                        }
                    }
                    this.reportMain.setModified();
                    this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                }
            } else if (this.option == 3) {
                if (this.reportMain.groupFormatFlag()) {
                    if (this.reportMain.isDesignMode) {
                        this.reportMain.designPanel.rulerPanel.groupFormatSetBorderColor(this.getColor());
                    }
                    this.reportMain.setModified();
                } else {
                    if (this.reportMain.isDesignMode) {
                        this.reportMain.selectedObject.setBorderColor(this.getColor());
                    } else if (this.reportMain.selectedObject instanceof ReportCell) {
                        ReportElement elt = this.reportMain.selectedPanel.getElement();
                        if (elt instanceof ReportTable) {
                            this.reportMain.selectedObject.setBorderColor(this.getColor());
                        } else if (elt instanceof ReportSection) {
                            if (((ReportSection)elt).hasSectionCell((ReportCell)this.reportMain.selectedObject, this.tree) || ((ReportSection)elt).hasFormattedCell((ReportCell)this.reportMain.selectedObject, this.tree)) {
                                this.reportMain.selectedObject.setBorderColor(this.getColor());
                            } else if (this.reportMain.selectedObject instanceof ColumnHeader) {
                                ColumnHeader newCell = new ColumnHeader();
                                newCell.copy((ColumnHeader)this.reportMain.selectedObject);
                                newCell.setBorderColor(this.getColor());
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            } else {
                                ReportCell newCell = new ReportCell();
                                newCell.copy((ReportCell)this.reportMain.selectedObject);
                                newCell.setBorderColor(this.getColor());
                                ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.reportMain.selectedObject, this.tree);
                            }
                        }
                    } else if (this.reportMain.selectedObject instanceof ReportColumn) {
                        try {
                            ReportElement relt = ((ReportColumn)this.reportMain.selectedObject).getFormatCell(this.row);
                            if (relt instanceof ReportCell) {
                                int i;
                                ReportTable mainTable;
                                FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                                cell.setBorderColor(this.getColor());
                                ((ReportColumn)this.reportMain.selectedObject).addFormattedCell(cell);
                                ReportTable table = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                                for (i = 0; i < this.tree.size(); ++i) {
                                    if (!(table instanceof ReportTreeTable)) continue;
                                    table = ((ReportTreeTable)table).getSubTable(this.tree.elementAt(i));
                                }
                                for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.reportMain.selectedObject; ++i) {
                                }
                                mainTable.getColumn(i).addFormattedCell(this.row, this.tree, cell);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to perform action with report column", ex);
                        }
                    }
                    this.reportMain.setModified();
                    this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                }
            }
            this.setVisible(false);
            if (this.reportMain.isDesignMode) {
                if (this.reportMain.groupFormatFlag()) {
                    this.reportMain.setIsUndoEnabled(true);
                } else {
                    this.reportMain.menuBar.setUndoEnabled(true);
                }
            }
            this.modified = true;
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.isTransparent = false;
            this.currentColor = this.initColor;
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private static JColorChooser getColorChooser(ReportMain reportMain, Color initColor) {
        JColorChooser colorChooser = new JColorChooser();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[]{new JSwatchChooserPanel(reportMain.getRecentColorArray()), new DefaultHSBChooserPanel(), new JRGBChooserPanel()};
        colorChooser.setChooserPanels(newPanels);
        colorChooser.setColor(initColor);
        return colorChooser;
    }

    public static Color showDialog(ReportMain reportMain, String title, Color initColor) {
        JColorChooser pane = ColorDialog.getColorChooser(reportMain, initColor);
        ColorTracker okTracker = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(reportMain, title, true, pane, okTracker, null);
        dialog.setVisible(true);
        return okTracker.getColor();
    }

    @Override
    public void hexUpdated(HexUpdateEvent evt) {
        this.hexPanel.setIsHexField(true);
        this.setColor(this.hexPanel.getUpdatedColor());
    }

    static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

