/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import quadbase.common.util.internal.LanguageEncoder;

public class ColorRenderer
extends BasicComboBoxRenderer {
    Icon[] icons;
    String[] colors;
    Hashtable<Object, Object[]> colorTable = new Hashtable();

    public ColorRenderer() {
        this.setOpaque(true);
        this.icons = new Icon[]{new ColorIcon(Color.red), new ColorIcon(Color.blue)};
        this.colors = new String[]{LanguageEncoder.getText("Red"), LanguageEncoder.getText("Blue")};
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Object[] item = this.colorTable.get(value);
        if (item == null) {
            item = new Object[]{this.getColorText(value), new ColorIcon((Color)value)};
            this.colorTable.put(value, item);
        }
        this.setText((String)item[0]);
        this.setIcon((Icon)item[1]);
        return this;
    }

    private String getColorText(Object color) {
        if (Color.black.equals(color)) {
            return LanguageEncoder.getText("Black");
        }
        if (Color.blue.equals(color)) {
            return LanguageEncoder.getText("Blue");
        }
        if (Color.cyan.equals(color)) {
            return LanguageEncoder.getText("Cyan");
        }
        if (Color.darkGray.equals(color)) {
            return LanguageEncoder.getText("Dark Gray");
        }
        if (Color.gray.equals(color)) {
            return LanguageEncoder.getText("Gray");
        }
        if (Color.green.equals(color)) {
            return LanguageEncoder.getText("Green");
        }
        if (Color.lightGray.equals(color)) {
            return LanguageEncoder.getText("Light Gray");
        }
        if (Color.magenta.equals(color)) {
            return LanguageEncoder.getText("Magenta");
        }
        if (Color.orange.equals(color)) {
            return LanguageEncoder.getText("Orange");
        }
        if (Color.pink.equals(color)) {
            return LanguageEncoder.getText("Pink");
        }
        if (Color.red.equals(color)) {
            return LanguageEncoder.getText("Red");
        }
        if (Color.white.equals(color)) {
            return LanguageEncoder.getText("White");
        }
        if (Color.yellow.equals(color)) {
            return LanguageEncoder.getText("Yellow");
        }
        return LanguageEncoder.getText("Custom");
    }

    private class ColorIcon
    implements Icon {
        private Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 20, 10);
        }
    }
}

