/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.util.IAggregateConstants;

public class ColumnFieldDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JComboBox nameList;
    JComboBox aggrList;
    String formula;
    String formulaName;
    int sqlType;
    ReportTable tbl;
    boolean isModified = false;
    private boolean useColIndex = false;

    public ColumnFieldDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Insert Column Field"), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Insert Column Field")));
        p1.setLayout(new FlowLayout(0));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Column Name")));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Aggregation")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.nameList = new JComboBox();
        this.tbl = this.reportMain.report.getReportTables().elementAt(0);
        int count = this.tbl.getColumnCount();
        Vector<String> save = new Vector<String>();
        for (int i = 0; i < count; ++i) {
            String tablename = this.tbl.getColumn(i).getDBTableName();
            String referencename = this.tbl.getColumn(i).getText();
            if (tablename != null && !tablename.equals("")) {
                referencename = tablename + "." + referencename;
            }
            if (save.contains(referencename)) {
                int ct = 0;
                while (save.contains(referencename + "_" + ct)) {
                    ++ct;
                }
                referencename = referencename + "_" + ct;
                this.useColIndex = true;
            }
            save.add(referencename);
            this.nameList.addItem(referencename);
        }
        this.aggrList = new JComboBox();
        for (String element : IAggregateConstants.AGGR) {
            this.aggrList.addItem(element);
        }
        mainPanel.add(this.nameList);
        mainPanel.add(this.aggrList);
        p1.add(labelPanel);
        p1.add(mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int colIndex = this.nameList.getSelectedIndex();
            short aggr = (short)this.aggrList.getSelectedIndex();
            this.formula = "";
            this.formulaName = "";
            this.sqlType = this.reportMain.report.getSQLType(this.reportMain.report.getColInfoIndex(this.tbl.getColumn(colIndex)));
            if (aggr != 0) {
                this.formula = IAggregateConstants.AGGR[aggr] + "(";
                this.formulaName = IAggregateConstants.AGGR[aggr] + "_";
                if (!(DataType.isNumeric(DataType.mapType(this.sqlType)) || aggr != 4 && aggr != 11)) {
                    this.sqlType = 4;
                }
            }
            if (this.useColIndex) {
                this.formula = this.formula + "COL(" + colIndex + ")";
                this.formulaName = this.formulaName + "COL" + colIndex;
            } else {
                String tablename = this.tbl.getColumn(colIndex).getDBTableName();
                String referencename = this.tbl.getColumn(colIndex).getText();
                this.formulaName = this.formulaName + referencename;
                if (tablename != null && !tablename.equals("")) {
                    referencename = tablename + "." + referencename;
                }
                this.formula = this.formula + "{" + referencename + "}";
            }
            if (aggr != 0) {
                this.formula = this.formula + ")";
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

