/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;

public class ColumnHeaderDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private ReportMain reportMain;
    private JComboBox nameList;
    private String columnHeaderString;
    private int sqlType;
    private ReportTable tbl;
    private boolean isModified = false;

    public ColumnHeaderDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Insert Column Header"), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Insert Column Header")));
        p1.setLayout(new FlowLayout(0));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Column Name")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.nameList = new JComboBox();
        this.tbl = this.reportMain.report.getReportTables().elementAt(0);
        int count = this.tbl.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.nameList.addItem(this.tbl.getColumn(i).getText());
        }
        mainPanel.add(this.nameList);
        p1.add(labelPanel);
        p1.add(mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getColumnHeaderString() {
        return this.columnHeaderString;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int colIndex = this.nameList.getSelectedIndex();
            this.sqlType = this.reportMain.report.getSQLType(this.reportMain.report.getColInfoIndex(this.tbl.getColumn(colIndex)));
            this.columnHeaderString = "getHeader({" + this.tbl.getColumn(colIndex).getText() + "})";
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

