/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;

public class ColumnPropertiesDialog
extends JDialog
implements ActionListener {
    JButton closeButton;
    ReportMain reportMain;
    ReportElement elt;

    public ColumnPropertiesDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Cell Properties"), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Properties")));
        p1.setLayout(new FlowLayout(0));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("ID :")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        mainPanel.add(new JLabel(this.elt.getID()));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Custom ID :")));
        mainPanel.add(new JLabel(this.elt.getCustomID()));
        if (this.elt instanceof ReportColumn) {
            ReportColumn col = (ReportColumn)this.elt;
            labelPanel.add(new JLabel(LanguageEncoder.getText("Index :")));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Column Name :")));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Data Type :")));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Column Type :")));
            mainPanel.add(new JLabel(this.reportMain.report.getColumnIndex(col) + ""));
            mainPanel.add(new JLabel(col.getText()));
            int colInfoIdx = this.reportMain.report.getColInfoIndex(col);
            mainPanel.add(new JLabel(DataType.getTypeName(this.reportMain.report.getSQLType(colInfoIdx))));
            mainPanel.add(new JLabel(this.reportMain.report.getColumnType(colInfoIdx)));
        }
        p1.add(labelPanel);
        p1.add(mainPanel);
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        this.closeButton.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", this.closeButton);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

