/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class ColumnWrapDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ColumnWrapDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JTextField xField;
    JTextField countField;

    public ColumnWrapDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Column Wrap ..."), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Column Wrap...")));
        p1.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        if (!this.reportMain.isCm) {
            labelPanel.add(new JLabel(LanguageEncoder.getText("X Position (in inches)")));
        } else {
            labelPanel.add(new JLabel(LanguageEncoder.getText("X Position (in cms)")));
        }
        labelPanel.add(new JLabel(LanguageEncoder.getText("Repeat Wrap")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.xField = new JTextField();
        mainPanel.add(this.xField);
        this.countField = new JTextField();
        mainPanel.add(this.countField);
        p1.add("Center", labelPanel);
        p1.add("East", mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setField();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    private void setField() {
        if (!this.reportMain.isCm) {
            this.xField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getColumnWrap().getX() * 100.0)) + "");
        } else {
            this.xField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getColumnWrap().getX() * 2.54 * 100.0)) + "");
        }
        this.countField.setText(this.reportMain.report.getColumnWrap().getWrapCount() + "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            double x = 0.0;
            int ct = -1;
            String msg = null;
            try {
                x = !this.reportMain.isCm ? Double.parseDouble(this.xField.getText()) : Double.parseDouble(this.xField.getText()) / 2.54;
                ct = Integer.parseInt(this.countField.getText());
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Count & Position: Invalid number", ex);
                msg = LanguageEncoder.getText("Count & Position : Numeric Only!");
            }
            double pageW = this.reportMain.report.getActualPageWidth();
            if (msg == null && x > pageW) {
                msg = LanguageEncoder.getText("Column wrap position cannot exceed 1/2 page!");
            }
            if (msg == null && (double)ct >= pageW / x) {
                int times = (int)Math.floor(pageW / x);
                String timeMsg = times > 1 ? LanguageEncoder.getText("times!") : LanguageEncoder.getText("time!");
                msg = LanguageEncoder.getText("Column wrap cannot repeat more than") + " " + times + " " + timeMsg;
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.report.getColumnWrap().setX(x);
            this.reportMain.report.getColumnWrap().setWrapCount(ct);
            this.reportMain.setModified();
            this.reportMain.clearAllDraggedObjects();
            this.reportMain.repaintPanel();
        }
        this.setVisible(false);
        this.dispose();
    }

    private String setFractionDigits(int v) {
        String t = Integer.toString(v);
        if (t.endsWith("0")) {
            double d = (double)v / 100.0;
            t = Double.toString(d).concat("0");
            return t;
        }
        double d = (double)v / 100.0;
        t = Double.toString(d);
        return t;
    }
}

