/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;

public class CrossTabDrillDownDialog
extends JDialog
implements ActionListener {
    JRadioButton crosstab;
    JRadioButton column;
    JButton okButton;
    boolean crosstab_drilldown = false;

    public CrossTabDrillDownDialog(JFrame parent) {
        super(parent, LanguageEncoder.getText("Drill-Down"), true);
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(new TitledBorder(LanguageEncoder.getText("Select an option")));
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        this.column = new JRadioButton("Column linking drill-down", true);
        mainPanel.add(this.column);
        this.crosstab = new JRadioButton("Crosstab drill-down", false);
        mainPanel.add(this.crosstab);
        ButtonGroup group = new ButtonGroup();
        group.add(this.crosstab);
        group.add(this.column);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.crosstab_drilldown = this.crosstab.isSelected();
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean getCrossTabDrillDown() {
        return this.crosstab_drilldown;
    }
}

