/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class DataSourceInfoFrame
extends JFrame
implements ActionListener {
    ReportMain reportMain;
    JButton closeBtn;

    public DataSourceInfoFrame(ReportMain reportMain, String title) {
        super(title);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(3, 1, 5, 5));
        JPanel typePanel = new JPanel(new FlowLayout(0));
        typePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Type")));
        typePanel.add(new Label(LanguageEncoder.getText("Data Source:")));
        int sourceData = this.reportMain.report.sourceData;
        if (sourceData == 0 && this.reportMain.report.getOriginalSourceData() > 0) {
            sourceData = this.reportMain.report.getOriginalSourceData();
        }
        switch (sourceData) {
            case 1: {
                typePanel.add(new Label(LanguageEncoder.getText("Database")));
                break;
            }
            case 2: {
                typePanel.add(new Label(LanguageEncoder.getText("Text File")));
                break;
            }
            case 4: {
                typePanel.add(new Label(LanguageEncoder.getText("Xml File")));
                break;
            }
            case 7: {
                typePanel.add(new Label(LanguageEncoder.getText("Xml File Query")));
                break;
            }
            case 8: {
                typePanel.add(new Label(LanguageEncoder.getText("Xml DB Query")));
                break;
            }
            case 5: {
                typePanel.add(new Label(LanguageEncoder.getText("EJB")));
                break;
            }
            case 6: {
                typePanel.add(new Label(LanguageEncoder.getText("Class File")));
                break;
            }
            case 12: {
                typePanel.add(new Label(LanguageEncoder.getText("Web Service (SOAP)")));
                break;
            }
            case 9: {
                typePanel.add(new Label(LanguageEncoder.getText("Old SOAP data source")));
                break;
            }
            case 3: {
                typePanel.add(new Label(LanguageEncoder.getText("Multi data source")));
                break;
            }
            case 11: {
                typePanel.add(new Label(LanguageEncoder.getText("SalesForce")));
                break;
            }
            case 13: {
                typePanel.add(new Label(LanguageEncoder.getText("Excel data source")));
                break;
            }
            case 0: {
                typePanel.add(new Label(LanguageEncoder.getText("None")));
                break;
            }
        }
        mainPanel.add(typePanel);
        JPanel locPanel = new JPanel();
        locPanel.setLayout(new FlowLayout(0));
        locPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Location")));
        switch (sourceData) {
            case 1: {
                JPanel p2;
                JPanel p1;
                if (!this.reportMain.report.dbInfo.isUseJNDIDataSource()) {
                    p1 = new JPanel(new GridLayout(2, 1, 5, 5));
                    p1.add(new Label(LanguageEncoder.getText("URL:")));
                    p1.add(new Label(LanguageEncoder.getText("Driver:")));
                    locPanel.add(p1);
                    p2 = new JPanel(new GridLayout(2, 1, 5, 5));
                    p2.add(new Label(this.reportMain.report.dbInfo.getURLString()));
                    p2.add(new Label(this.reportMain.report.dbInfo.getDriverName()));
                    locPanel.add(p2);
                    break;
                }
                p1 = new JPanel(new GridLayout(3, 1, 5, 5));
                p1.add(new Label(LanguageEncoder.getText("JNDI lookup name:")));
                p1.add(new Label(LanguageEncoder.getText("INITIAL_CONTEXT_FACTORY:")));
                p1.add(new Label(LanguageEncoder.getText("PROVIDER_URL")));
                locPanel.add(p1);
                p2 = new JPanel(new GridLayout(3, 1, 5, 5));
                p2.add(new Label(this.reportMain.report.dbInfo.getJNDIName()));
                p2.add(new Label(this.reportMain.report.dbInfo.getContextFactory()));
                p2.add(new Label(this.reportMain.report.dbInfo.getProviderURL()));
                locPanel.add(p2);
                break;
            }
            case 2: 
            case 4: {
                locPanel.add(new Label(LanguageEncoder.getText("File:")));
                locPanel.add(new Label(this.reportMain.report.sourceFile));
                break;
            }
            case 6: {
                locPanel.add(new Label(LanguageEncoder.getText("Class:")));
                locPanel.add(new Label(this.reportMain.report.sourceFile));
                break;
            }
            case 7: 
            case 8: {
                locPanel.add(new Label(LanguageEncoder.getText("File:")));
                locPanel.add(new Label(this.reportMain.report.xmlFileQueryInfo.getFileName()));
                break;
            }
            case 9: {
                locPanel.add(new Label(LanguageEncoder.getText("This data source is no longer support. Please update your data source.")));
            }
            case 12: {
                JPanel p3 = new JPanel(new GridLayout(4, 1, 5, 5));
                p3.add(new Label(LanguageEncoder.getText("WSDL URI:")));
                p3.add(new Label(LanguageEncoder.getText("Service Name:")));
                p3.add(new Label(LanguageEncoder.getText("Port Name:")));
                p3.add(new Label(LanguageEncoder.getText("Operation Name:")));
                locPanel.add(p3);
                JPanel p4 = new JPanel(new GridLayout(4, 1, 5, 5));
                p4.add(new Label(this.reportMain.report.soapInfo.getWsdlUri()));
                p4.add(new Label(this.reportMain.report.soapInfo.getServiceName().toString()));
                p4.add(new Label(this.reportMain.report.soapInfo.getPortName()));
                p4.add(new Label(this.reportMain.report.soapInfo.getOperationName()));
                locPanel.add(p4);
                break;
            }
            case 13: {
                locPanel.add(new Label(LanguageEncoder.getText("File:")));
                locPanel.add(new Label(this.reportMain.report.excelInfo.getFilename()));
                break;
            }
            case 5: {
                JPanel p3 = new JPanel(new GridLayout(3, 1, 5, 5));
                p3.add(new Label(LanguageEncoder.getText("JNDI:")));
                p3.add(new Label(LanguageEncoder.getText("Home:")));
                p3.add(new Label(LanguageEncoder.getText("Remote:")));
                locPanel.add(p3);
                JPanel p4 = new JPanel(new GridLayout(3, 1, 5, 5));
                p4.add(new Label(this.reportMain.report.jndiName));
                p4.add(new Label(this.reportMain.report.homeName));
                p4.add(new Label(this.reportMain.report.remoteName));
                locPanel.add(p4);
                break;
            }
            case 0: 
            case 3: 
            case 11: {
                locPanel.add(new Label(LanguageEncoder.getText("N/A")));
                break;
            }
        }
        mainPanel.add(locPanel);
        JPanel regPanel = new JPanel(new FlowLayout(0));
        regPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Registry Info")));
        regPanel.add(new Label(LanguageEncoder.getText("Data registry:")));
        String registry = this.reportMain.report.dataSourceLoc;
        if (registry == null || registry.equals("")) {
            registry = LanguageEncoder.getText("Unavailable");
        }
        regPanel.add(new Label(registry));
        mainPanel.add(regPanel);
        this.closeBtn = new JButton(LanguageEncoder.getText("CLOSE"));
        this.closeBtn.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(LanguageEncoder.getText("North"), mainPanel);
        contentPane.add(LanguageEncoder.getText("South"), this.closeBtn);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataSourceInfoFrame.this.close();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeBtn) {
            this.close();
        }
    }

    private void close() {
        this.reportMain.dataSourceInfoFrame = null;
        this.setVisible(false);
        this.dispose();
    }
}

