/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ReadDatabase;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.util.IAggregateConstants;

public class DatabaseFieldDialog
extends JFrame
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DatabaseFieldDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JTree tableTree;
    JTree dbAggrTree;
    JTree colAggrTree;
    ReportTable tbl;
    boolean isModified = false;
    DBInfoBasic dbInfo;
    String[] tableName;
    String[] aliasName;
    boolean isGroupByPresent = false;
    Vector[] displayName;
    ReadDatabase readDB;
    public static String[] DBAGGR = new String[]{"Group By", "Sum", "Avg", "Min", "Max", "Count", "stDev", "Var", "First", "Last"};
    public static int GROUPBY = 0;
    int databaseType = -1;
    Vector<String> existingColumnNames = null;
    JSplitPane splitPane = null;
    JComponent aggrPane = null;

    public DatabaseFieldDialog(ReportMain reportMain) throws Exception {
        super(LanguageEncoder.getText("Insert Database Field"));
        this.reportMain = reportMain;
        this.dbInfo = reportMain.report.dbInfo;
        this.isGroupByPresent = QueryParser.isGroupByPresent(this.dbInfo.getQuery());
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (dim.width < 600) {
            dim.width = 600;
        }
        if (dim.height < 400) {
            dim.height = 400;
        }
        this.setSize(dim);
        if (this.aggrPane instanceof JSplitPane) {
            ((JSplitPane)this.aggrPane).resetToPreferredSizes();
            ((JSplitPane)this.aggrPane).setDividerLocation(0.5);
            this.splitPane.setDividerLocation(0.33);
        } else {
            this.splitPane.setDividerLocation(0.5);
        }
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() throws Exception {
        this.readDB = this.dbInfo.isUseJNDIDataSource() ? new ReadDatabase(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties()) : new ReadDatabase(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword());
        this.tableName = QueryParser.getAllTableNames(this.dbInfo.getQuery(), true, true, false);
        this.aliasName = QueryParser.getAllTableNames(this.dbInfo.getQuery(), true, false, false);
        Vector tempDisplayName = new Vector();
        for (String element : this.tableName) {
            try {
                String cloneTBLName = this.reportMain.report.cloneSQLWithFixParameters(element);
                Object[][] colInfo = this.readDB.getTableInfo(cloneTBLName, false);
                Vector<String> temp = new Vector<String>();
                for (Object[] element2 : colInfo) {
                    temp.add(element2[0].toString() + " (" + element2[2].toString() + ")");
                }
                tempDisplayName.add(temp);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to read list of display names", ex);
            }
        }
        if (tempDisplayName.isEmpty()) {
            throw new Exception("No tables found.");
        }
        this.displayName = new Vector[tempDisplayName.size()];
        for (int i = 0; i < this.displayName.length; ++i) {
            this.displayName[i] = (Vector)tempDisplayName.elementAt(i);
        }
        ReportTable tbl = this.reportMain.report.getReportTables().elementAt(0);
        int count = tbl.getColumnCount();
        this.existingColumnNames = new Vector();
        for (int i = 0; i < count; ++i) {
            String tablename = tbl.getColumn(i).getDBTableName();
            String referencename = tbl.getColumn(i).getText();
            if (tablename != null) {
                referencename = tablename + "." + referencename;
            }
            this.existingColumnNames.add(referencename);
        }
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Insert Database Field")));
        p1.setLayout(new BorderLayout());
        if (this.isGroupByPresent) {
            this.aggrPane = new JSplitPane(1, false);
            ((JSplitPane)this.aggrPane).setLeftComponent(this.getDBAggrPanel());
            ((JSplitPane)this.aggrPane).setRightComponent(this.getColAggrPanel());
        } else {
            this.aggrPane = this.getColAggrPanel();
        }
        this.splitPane = new JSplitPane(1, false);
        this.splitPane.setLeftComponent(this.getTablePanel());
        this.splitPane.setRightComponent(this.aggrPane);
        p1.add("Center", this.splitPane);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("Insert"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Close"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    private JScrollPane getTablePanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Columns");
        for (int i = 0; i < this.tableName.length; ++i) {
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(this.aliasName[i]);
            for (int j = 0; j < this.displayName[i].size(); ++j) {
                tableNode.add(new DefaultMutableTreeNode(this.displayName[i].elementAt(j)));
            }
            root.add(tableNode);
        }
        this.tableTree = new JTree(root);
        this.tableTree.getSelectionModel().setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tableTree);
        return scrollPane;
    }

    private JScrollPane getDBAggrPanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Database Aggregation");
        for (String element : DBAGGR) {
            root.add(new DefaultMutableTreeNode(element));
        }
        this.dbAggrTree = new JTree(root);
        this.dbAggrTree.getSelectionModel().setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.dbAggrTree);
        return scrollPane;
    }

    private JScrollPane getColAggrPanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Column Aggregation");
        for (String element : IAggregateConstants.AGGR) {
            root.add(new DefaultMutableTreeNode(element));
        }
        this.colAggrTree = new JTree(root);
        this.colAggrTree.getSelectionModel().setSelectionMode(1);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.colAggrTree);
        return scrollPane;
    }

    public boolean isModified() {
        return this.isModified;
    }

    private short getColAggrIndex() {
        if (this.colAggrTree.isSelectionEmpty()) {
            return 0;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.colAggrTree.getSelectionPath().getLastPathComponent();
        if (!node.isLeaf()) {
            return 0;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        return (short)parent.getIndex(node);
    }

    private String getDBAggrIndex() {
        if (this.dbAggrTree == null || this.dbAggrTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.dbAggrTree.getSelectionPath().getLastPathComponent();
        if (!node.isLeaf()) {
            return null;
        }
        return node.getUserObject().toString();
    }

    private String[] getColumnName() {
        if (this.tableTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tableTree.getSelectionPath().getLastPathComponent();
        if (!node.isLeaf()) {
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        String[] tmp = new String[]{parent.getUserObject().toString(), node.getUserObject().toString()};
        int idx = tmp[1].lastIndexOf(" (");
        tmp[1] = tmp[1].substring(0, idx);
        return tmp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            short colAggr = this.getColAggrIndex();
            String[] tmp = this.getColumnName();
            if (tmp == null) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a column first!"));
                return;
            }
            String dbAggr = null;
            if (this.isGroupByPresent && (dbAggr = this.getDBAggrIndex()) == null) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Database aggregation is required!"));
                return;
            }
            this.reportMain.setSelectedDatabaseField(tmp);
            this.reportMain.setSelectedDatabaseFieldAggr(dbAggr);
            this.reportMain.setSelectedColumnAggrIndex(colAggr);
            this.setVisible(false);
            this.isModified = true;
            this.reportMain.toFront();
            this.reportMain.insertDatabaseField = true;
        } else {
            this.reportMain.dbFieldDialog = null;
            this.setVisible(false);
            this.dispose();
        }
    }
}

