/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.LocaleDateTimeDialog;
import quadbase.reportdesigner.designer.PanelAction;
import quadbase.reportdesigner.designer.StandardDateTimeDialog;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;

public class DateTimePanel
extends PanelAction
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DateTimePanel.class.getName());
    static Timestamp timestamp_demo = new Timestamp(97, 10, 10, 22, 19, 4, 2000);
    static Time time_demo = new Time(22, 19, 4);
    static Date date_demo = new Date(97, 10, 1);
    JFrame frame;
    ButtonGroup group;
    JRadioButton chkLocale;
    JRadioButton chkStandard;
    JButton btnFormat;
    boolean showDate;
    boolean showTime;
    boolean showHide;
    DateTimeFormat dtf;
    LocaleDateTimeFormat ldtf;

    public DateTimePanel(JFrame frame, IFormat format, boolean showDate, boolean showTime, boolean showHide) {
        this.frame = frame;
        this.showDate = showDate;
        this.showTime = showTime;
        this.showHide = showHide;
        this.init(format);
    }

    private void init(IFormat format) {
        this.group = new ButtonGroup();
        JPanel plLocale = new JPanel(new FlowLayout(0));
        this.chkLocale = new JRadioButton(LanguageEncoder.getText("Locale-specific"), true);
        plLocale.add(this.chkLocale);
        this.chkLocale.addItemListener(this);
        Panel plBottom = new Panel(new BorderLayout());
        Panel plStandard = new Panel(new FlowLayout(0));
        this.chkStandard = new JRadioButton(LanguageEncoder.getText("Standard"), false);
        plStandard.add(this.chkStandard);
        this.chkStandard.addItemListener(this);
        this.group.add(this.chkLocale);
        this.group.add(this.chkStandard);
        JPanel plFormat = new JPanel(new FlowLayout(2));
        this.btnFormat = new JButton(LanguageEncoder.getText("Format..."));
        this.btnFormat.addActionListener(this);
        plFormat.add(this.btnFormat);
        plBottom.add("West", plStandard);
        plBottom.add("East", plFormat);
        this.setLayout(new BorderLayout());
        this.add("North", plLocale);
        this.add("South", plBottom);
        if (format instanceof DateTimeFormat) {
            this.dtf = (DateTimeFormat)format;
            this.chkStandard.setSelected(true);
        } else if (format instanceof LocaleDateTimeFormat) {
            this.ldtf = (LocaleDateTimeFormat)format;
            this.chkLocale.setSelected(true);
        } else {
            LOGGER.warning("DateTimePanel: should not happen");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.chkStandard.isSelected()) {
            if (this.dtf == null) {
                this.dtf = new DateTimeFormat();
            }
        } else if (this.chkLocale.isSelected() && this.ldtf == null) {
            if (this.showDate && !this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getDateInstance();
            } else if (!this.showDate && this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getTimeInstance();
            } else if (this.showDate && this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getDateTimeInstance();
            }
        }
        this.fireEvent(this, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showFormatDialog();
        this.fireEvent(this, 0);
    }

    private void showFormatDialog() {
        if (this.chkLocale.isSelected()) {
            LocaleDateTimeDialog ldtd = new LocaleDateTimeDialog(this.frame, LanguageEncoder.getText("Locale-specific..."), this.ldtf);
            ldtd.setVisible(true);
            this.ldtf = ldtd.getFormat();
        } else if (this.chkStandard.isSelected()) {
            StandardDateTimeDialog sdtd = new StandardDateTimeDialog(this.frame, LanguageEncoder.getText("Standard..."), this.dtf, this.showDate, this.showTime, this.showHide);
            sdtd.setVisible(true);
            this.dtf = sdtd.getFormat();
        }
    }

    private String formatValue(Date value) {
        if (this.getFormat() != null) {
            return this.getFormat().format(value);
        }
        return null;
    }

    private String formatValue(Time value) {
        if (this.getFormat() != null) {
            return this.getFormat().format(value);
        }
        return null;
    }

    private String formatValue(Timestamp value) {
        if (this.getFormat() != null) {
            return this.getFormat().format(value);
        }
        return null;
    }

    public IFormat getFormat() {
        if (this.chkLocale.isSelected()) {
            return this.ldtf;
        }
        if (this.chkStandard.isSelected()) {
            return this.dtf;
        }
        return null;
    }

    public String getSampleText() {
        if (this.showTime) {
            if (this.showDate) {
                return this.formatValue(timestamp_demo);
            }
            return this.formatValue(time_demo);
        }
        return this.formatValue(date_demo);
    }
}

