/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;

public class DefaultReportStyle
extends ReportStyle {
    private static final Logger LOGGER = Logger.getLogger(DefaultReportStyle.class.getName());
    Report report;
    String globalFormatXml = null;

    public DefaultReportStyle() {
        try {
            this.globalFormatXml = ServerMessage.getDefaultGlobalFormat();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Cannot get default global format", e);
        }
    }

    @Override
    public void applyFormat(ReportMain reportmain, boolean changingStyle) {
        if (this.globalFormatXml == null || this.globalFormatXml.trim().length() == 0) {
            return;
        }
        super.applyFormat(reportmain, changingStyle);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.importGlobalFormat(reportmain.report);
        if (this.globalFormatXml != null) {
            ImportGlobalFormat import_xml = new ImportGlobalFormat(reportmain);
            import_xml.importXML(this.globalFormatXml);
        }
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }
}

