/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Graphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.designer.RulerPanel;

public class DesignGraphics {
    private static double gridStepSize = 0.1;
    private static double cmGridStepSize = 0.25;

    public static void setGridStepSize(double gridStepSize) {
        DesignGraphics.gridStepSize = gridStepSize;
    }

    public static void setCmGridStepSize(double cmGridStepSize) {
        DesignGraphics.cmGridStepSize = cmGridStepSize;
    }

    public static void drawGrid(Graphics g, double width, double height, boolean metric) {
        g.setColor(Color.lightGray);
        if (!metric) {
            int y2 = QbUtil.toPixel(height);
            for (double i = 1.0; i < width; i += 1.0) {
                int x = QbUtil.toPixel(i);
                g.drawLine(x, 0, x, y2);
            }
            int x2 = QbUtil.toPixel(width);
            for (double i = 1.0; i < height; i += 1.0) {
                int y = QbUtil.toPixel(i);
                g.drawLine(0, y, x2, y);
            }
        } else {
            int x2 = QbUtil.toPixel(width);
            int y2 = QbUtil.toPixel(height);
            int PIXEL_PER_CM = (int)((double)QbUtil.toPixel(1.0) / 2.54);
            width *= 2.54;
            height *= 2.54;
            int i = 3;
            while ((double)i < width + 1.0) {
                int x = PIXEL_PER_CM * i;
                g.drawLine(x, 0, x, y2);
                i += 3;
            }
            i = 3;
            while ((double)i < height + 1.0) {
                int y = PIXEL_PER_CM * i;
                g.drawLine(0, y, x2, y);
                i += 3;
            }
        }
    }

    public static void drawPoint(Graphics g, double width, double height, boolean metric) {
        g.setColor(Color.black);
        if (!metric) {
            for (double i = gridStepSize; i < width; i += gridStepSize) {
                int x = QbUtil.toPixel(i);
                for (double j = gridStepSize; j < height; j += gridStepSize) {
                    g.fillRect(x, QbUtil.toPixel(j), 1, 1);
                }
            }
        } else {
            int PIXEL_PER_CM = (int)((double)QbUtil.toPixel(1.0) / 2.54);
            width *= 2.54;
            height *= 2.54;
            double cmUnit = (double)PIXEL_PER_CM * cmGridStepSize;
            int ct = (int)Math.round(1.0 / cmGridStepSize);
            int i = 1;
            while ((double)i < width + 1.0) {
                int x = PIXEL_PER_CM * i;
                int j = 1;
                while ((double)j < height + 1.0) {
                    int y = PIXEL_PER_CM * j;
                    for (int k = 0; k < ct; ++k) {
                        for (int l = 0; l < ct; ++l) {
                            g.fillRect((int)((double)x - (double)k * cmUnit), (int)((double)y - cmUnit * (double)l), 1, 1);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void drawLine(Graphics g, double xPts, double height) {
        int x;
        int h = QbUtil.toPixel(height);
        int max = QbUtil.toPixel(RulerPanel.MAX_XWIDTH);
        int w = x;
        for (x = QbUtil.toPixel(xPts); x < max; x += w) {
            g.setColor(Color.lightGray);
            g.fillRect(x - 1, 0, 3, h);
        }
    }
}

