/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import quadbase.reportdesigner.designer.DesignToolBar;
import quadbase.reportdesigner.designer.DesignToolBar2;
import quadbase.reportdesigner.designer.EditPanel;
import quadbase.reportdesigner.designer.ReportExplorer;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.RulerPanel;

public class DesignPanel
extends JPanel {
    ReportMain reportMain;
    DesignToolBar designToolBar;
    DesignToolBar2 designToolBar2;
    JSplitPane designPanel;
    JSplitPane labelSectionPane;
    JSplitPane designSectionPane;
    JSplitPane explorerSplitPane;
    ReportExplorer explorer;
    JPanel[] labelSection;
    JPanel[] designSection;
    public RulerPanel rulerPanel;
    JPanel mainPanel;
    int expDevider = 150;
    protected EditPanel editPanel;

    public DesignPanel(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BorderLayout());
        toolbarPanel.add((Component)this.getDesignToolBar(), "Center");
        toolbarPanel.add((Component)this.getDesignToolBar2(), "South");
        this.add((Component)toolbarPanel, "North");
        this.initMainPanel();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.editPanel = this.reportMain.getEditPanel();
        this.mainPanel.add((Component)this.editPanel, "North");
        this.rulerPanel = new RulerPanel(this.reportMain);
        this.initExplorer(null);
    }

    private void initExplorer(ReportExplorer exp) {
        this.reportMain.explorer = this.explorer = exp == null ? new ReportExplorer(this.reportMain) : exp;
        if (this.reportMain.isExplorerVisible) {
            this.explorerSplitPane = new JSplitPane(1, this.explorer.getMainPane(), this.rulerPanel);
            this.explorerSplitPane.setDividerLocation(this.expDevider);
            this.mainPanel.add((Component)this.explorerSplitPane, "Center");
        } else {
            this.mainPanel.add((Component)this.rulerPanel, "Center");
        }
    }

    public void updatePanel() {
        this.updatePanel(true);
    }

    public void updatePanel(boolean createNewExplorer) {
        if (!this.reportMain.isUpdateReport()) {
            return;
        }
        if (this.explorerSplitPane != null) {
            this.expDevider = this.explorerSplitPane.getDividerLocation();
            this.mainPanel.remove(this.explorerSplitPane);
        }
        this.mainPanel.remove(this.rulerPanel);
        this.rulerPanel = new RulerPanel(this.reportMain);
        this.initExplorer(createNewExplorer ? null : this.explorer);
        this.validate();
        this.repaint();
    }

    public DesignToolBar getDesignToolBar() {
        if (this.designToolBar != null) {
            return this.designToolBar;
        }
        this.designToolBar = new DesignToolBar(this.reportMain);
        this.designToolBar.setEnabled(false);
        return this.designToolBar;
    }

    public DesignToolBar2 getDesignToolBar2() {
        if (this.designToolBar2 != null) {
            return this.designToolBar2;
        }
        this.designToolBar2 = new DesignToolBar2(this.reportMain);
        this.designToolBar2.setEnabled(false);
        return this.designToolBar2;
    }
}

