/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class DesignToolBar
extends JToolBar
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DesignToolBar.class.getName());
    private ReportMain reportMain;
    private JButton newBt;
    private JButton openBt;
    private JButton exportBt;
    private JButton applyTemplateBt;
    private JButton cutBt;
    private JButton copyBt;
    private JButton pasteBt;
    private JButton deleteBt;
    private JButton insertLabelBt;
    private JButton insertFormulaBt;
    private JButton insertColumnFieldBt;
    private JButton insertRichTextFieldBt;
    private JButton insertSubReportBt;
    private JButton insertHorizontalLineBt;
    private JButton insertVerticalLineBt;
    private JButton insertGridBt;
    private JButton insertChartBt;
    private JButton insertImageBt;
    private JButton insertCurrentDateBt;
    private JButton insertPageNumberBt;
    private JButton changeDataMappingBt;
    private JButton changeDataSourceBt;
    private JButton editQueryBt;
    JButton saveBt;
    JButton redoBt;
    JButton undoBt;

    public DesignToolBar(ReportMain reportMain) {
        this.setFloatable(false);
        this.reportMain = reportMain;
        this.setBorder(new TitledBorder(""));
        this.newBt = new JButton();
        this.addNewButton(this.newBt, LanguageEncoder.getText("New File"), "NEW", "NewIcon.png");
        this.openBt = new JButton();
        this.addNewButton(this.openBt, LanguageEncoder.getText("Open File"), "OPEN", "OpenIcon.png");
        this.saveBt = new JButton();
        this.addNewButton(this.saveBt, LanguageEncoder.getText("Save File"), "SAVE", "SaveIcon.png");
        this.exportBt = new JButton();
        if (!reportMain.isSaas()) {
            this.addNewButton(this.exportBt, LanguageEncoder.getText("Export File"), "EXPORT", "ExportIcon.png");
        }
        this.applyTemplateBt = new JButton();
        this.addNewButton(this.applyTemplateBt, LanguageEncoder.getText("Apply Template"), "APPLY_TEMPLATE", "ApplyTemplateIcon.png");
        this.addSeparator();
        this.undoBt = new JButton();
        this.undoBt.setEnabled(false);
        this.addNewButton(this.undoBt, LanguageEncoder.getText("Undo"), "UNDO", "UndoIcon.png");
        this.redoBt = new JButton();
        this.redoBt.setEnabled(false);
        this.addNewButton(this.redoBt, LanguageEncoder.getText("Redo"), "REDO", "RedoIcon.png");
        this.addSeparator();
        this.cutBt = new JButton();
        this.addNewButton(this.cutBt, LanguageEncoder.getText("Cut"), "CUT", "CutIcon.png");
        this.copyBt = new JButton();
        this.addNewButton(this.copyBt, LanguageEncoder.getText("Copy"), "COPY", "CopyIcon.png");
        this.pasteBt = new JButton();
        this.addNewButton(this.pasteBt, LanguageEncoder.getText("Paste"), "PASTE", "PasteIcon.png");
        this.deleteBt = new JButton();
        this.addNewButton(this.deleteBt, LanguageEncoder.getText("Delete"), "DELETE", "DeleteIcon.png");
        this.addSeparator();
        this.insertLabelBt = new JButton();
        this.addNewButton(this.insertLabelBt, LanguageEncoder.getText("Insert Label"), "INSERT_LABEL", "InsertLabelIcon.png");
        this.insertFormulaBt = new JButton();
        this.addNewButton(this.insertFormulaBt, LanguageEncoder.getText("Insert Formula"), "INSERT_FORMULA", "InsertFormulaIcon.png");
        this.insertColumnFieldBt = new JButton();
        this.addNewButton(this.insertColumnFieldBt, LanguageEncoder.getText("Insert Column Field"), "INSERT_COLUMN_FIELD", "InsertColumnFieldIcon.png");
        this.insertRichTextFieldBt = new JButton();
        this.addNewButton(this.insertRichTextFieldBt, LanguageEncoder.getText("Insert Rich Text Field"), "INSERT_RICH_TEXT_FIELD", "InsertRichTextFieldIcon.png");
        this.insertSubReportBt = new JButton();
        this.addNewButton(this.insertSubReportBt, LanguageEncoder.getText("Insert Sub-Report"), "INSERT_SUBREPORT", "InsertSubReportIcon.png");
        this.insertHorizontalLineBt = new JButton();
        this.addNewButton(this.insertHorizontalLineBt, LanguageEncoder.getText("Insert Horizontal Line"), "INSERT_HORIZONTAL_LINE", "InsertHorizontalLineIcon.png");
        this.insertVerticalLineBt = new JButton();
        this.addNewButton(this.insertVerticalLineBt, LanguageEncoder.getText("Insert Vertical Line"), "INSERT_VERTICAL_LINE", "InsertVerticalLineIcon.png");
        this.insertGridBt = new JButton();
        this.addNewButton(this.insertGridBt, LanguageEncoder.getText("Insert Rectangle"), "INSERT_GRID", "InsertGridIcon.png");
        this.insertChartBt = new JButton();
        this.addNewButton(this.insertChartBt, LanguageEncoder.getText("Insert Chart"), "INSERT_CHART", "InsertChartIcon.png");
        this.insertImageBt = new JButton();
        this.addNewButton(this.insertImageBt, LanguageEncoder.getText("Insert Image"), "INSERT_IMAGE", "AddBackgroundImageIcon.png");
        this.insertCurrentDateBt = new JButton();
        this.addNewButton(this.insertCurrentDateBt, LanguageEncoder.getText("Insert Current Date"), "INSERT_CURRENT_DATE", "InsertCurrentDateIcon.png");
        this.insertPageNumberBt = new JButton();
        this.addNewButton(this.insertPageNumberBt, LanguageEncoder.getText("Insert Page Number"), "INSERT_PAGE_NUMBER", "InsertPageNumberIcon.png");
        this.addSeparator();
        this.changeDataMappingBt = new JButton();
        this.addNewButton(this.changeDataMappingBt, LanguageEncoder.getText("Change Data Mapping"), "CHANGE_DATA_MAPPING", "DataMappingIcon.png");
        this.changeDataSourceBt = new JButton();
        this.addNewButton(this.changeDataSourceBt, LanguageEncoder.getText("Change Data Source"), "CHANGE_DATA_SOURCE", "ChangeDataSourceIcon.png");
        this.editQueryBt = new JButton();
        this.addNewButton(this.editQueryBt, LanguageEncoder.getText("Edit Query"), "EDIT_QUERY", "EditQueryIcon.png");
    }

    private void addNewButton(JButton newBtn, String tip, String command, String img) {
        img = ServerMessage.reportImagesPath + img;
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading image icon [" + img, e);
        }
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    private void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    @Override
    public void setEnabled(boolean b) {
        this.saveBt.setEnabled(b && this.reportMain.isSaveItemEnabled());
        this.exportBt.setEnabled(b);
        this.deleteBt.setEnabled(b);
        this.reportMain.enableUndoRedoButtons();
        this.insertLabelBt.setEnabled(b);
        this.insertFormulaBt.setEnabled(b);
        this.insertColumnFieldBt.setEnabled(b);
        this.insertRichTextFieldBt.setEnabled(b);
        this.insertHorizontalLineBt.setEnabled(b);
        this.insertVerticalLineBt.setEnabled(b);
        this.insertGridBt.setEnabled(b);
        if (!LCKey.isFree()) {
            this.insertChartBt.setEnabled(b);
        } else {
            this.insertChartBt.setToolTipText(LanguageEncoder.getText("Insert Chart --") + " " + "This feature is only included in full version, please contact sales@quadbase.com for more information.");
            this.insertChartBt.setEnabled(false);
        }
        this.insertImageBt.setEnabled(b);
        this.insertCurrentDateBt.setEnabled(b);
        this.insertPageNumberBt.setEnabled(b);
        this.changeDataMappingBt.setEnabled(b);
        this.changeDataSourceBt.setEnabled(b);
        this.editQueryBt.setEnabled(b);
        if (b) {
            this.reportMain.setCopyCutEnabled();
            this.setPasteEnabled(false);
            if (!LCKey.isFree()) {
                this.insertSubReportBt.setEnabled(b);
            } else {
                this.insertSubReportBt.setToolTipText(LanguageEncoder.getText("Insert Sub-Report --") + " " + "This feature is only included in full version, please contact sales@quadbase.com for more information.");
                this.insertSubReportBt.setEnabled(false);
            }
        } else {
            this.cutBt.setEnabled(false);
            this.copyBt.setEnabled(false);
            this.pasteBt.setEnabled(false);
            this.insertSubReportBt.setEnabled(false);
        }
        boolean securityState2 = b && !this.reportMain.isSecurityLevelApplied();
        this.applyTemplateBt.setEnabled(securityState2);
        this.changeDataMappingBt.setEnabled(securityState2);
        this.changeDataSourceBt.setEnabled(securityState2);
        this.editQueryBt.setEnabled(securityState2);
        this.setToolbarForSTL();
    }

    public void setToolbarForDrillDown() {
    }

    public void setToolbarForSubReport() {
        this.setEnabled(true);
        this.insertSubReportBt.setEnabled(false);
    }

    public void setToolbarForSTL() {
        if (!this.reportMain.getTitle().toUpperCase().endsWith(".STL")) {
            return;
        }
        this.exportBt.setEnabled(false);
        this.insertSubReportBt.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reportMain.isDesignMode = true;
        this.reportMain.createBackupReport();
        String command = e.getActionCommand();
        if (command.equals("NEW")) {
            this.reportMain.newFile();
        } else if (command.equals("OPEN")) {
            this.reportMain.openFile();
        } else if (command.equals("SAVE")) {
            this.reportMain.saveFromReportDesigner();
        } else if (command.equals("EXPORT")) {
            this.reportMain.export();
        } else if (command.equals("APPLY_TEMPLATE")) {
            this.reportMain.applyTemplate();
        } else if (command.equals("UNDO")) {
            this.reportMain.do_undo();
        } else if (command.equals("REDO")) {
            this.reportMain.do_redo();
        } else if (command.equals("DELETE")) {
            this.reportMain.deleteElt();
        } else if (command.equals("INSERT_LABEL")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertLabel(true);
        } else if (command.equals("INSERT_FORMULA")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertFormula(true);
        } else if (command.equals("INSERT_COLUMN_FIELD")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertColumnField();
        } else if (command.equals("INSERT_IMAGE")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertImage(true);
        } else if (command.equals("INSERT_CHART")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertChart(true);
        } else if (command.equals("INSERT_RICH_TEXT_FIELD")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertRichTextField(true);
        } else if (command.equals("INSERT_SUBREPORT")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.addSubReport();
        } else if (command.equals("INSERT_HORIZONTAL_LINE")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertLine(true);
        } else if (command.equals("INSERT_VERTICAL_LINE")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertLine(true);
            this.reportMain.setVerticalLine(true);
        } else if (command.equals("INSERT_GRID")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertGrid(true);
        } else if (command.equals("SELECTION_BOX")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertBoundingBox(true);
        } else if (command.equals("CHANGE_DATA_MAPPING")) {
            this.reportMain.redoDataMapping();
        } else if (command.equals("CHANGE_DATA_SOURCE")) {
            this.reportMain.updateDataSource();
        } else if (command.equals("EDIT_QUERY")) {
            this.reportMain.updateQuery();
        } else if (command.equals("INSERT_CURRENT_DATE")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertFormula(true, "todaysDate", "getCurrentDate()", 91);
        } else if (command.equals("INSERT_PAGE_NUMBER")) {
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setInsertFormula(true, "currentpage", "strcat(\"page \", getPage())", 12);
        } else if (command.equals("COPY")) {
            this.reportMain.designPanel.rulerPanel.copyToClipBoard();
        } else if (command.equals("CUT")) {
            this.reportMain.designPanel.rulerPanel.cutToClipBoard();
        } else if (command.equals("PASTE")) {
            this.reportMain.setIsPasteOp(true);
        } else {
            LOGGER.warning("Unknown command: " + command);
        }
    }

    void setCopyCutEnabled(boolean flag) {
        this.copyBt.setEnabled(flag);
        this.cutBt.setEnabled(flag);
    }

    void setPasteEnabled(boolean flag) {
        this.pasteBt.setEnabled(flag);
    }
}

