/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.designer.ReportMain;

public class DesignToolBar2
extends JToolBar
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DesignToolBar2.class.getName());
    private ReportMain reportMain;
    private JComboBox fontFaceBox;
    private SpinBox fontSizeBox;
    private JToggleButton boldBt;
    private JToggleButton italicBt;
    private JToggleButton underlineBt;
    private JToggleButton hAlignLeftBt;
    private JToggleButton hAlignCenterBt;
    private JToggleButton hAlignRightBt;
    private JButton editBt;
    private JButton dataFormatBt;
    private JButton scriptingBt;
    private JButton fontColorBt;
    private JButton bgColorBt;
    private JButton borderBt;
    private JButton dualColorsBt;
    private JButton boundsBt;
    private JButton pageSetupBt;
    private JButton previewDisplayRowsBt;
    private String[] fontList;
    private ButtonGroup horizAlign = new ButtonGroup();
    private boolean setSelectingObject = false;

    public DesignToolBar2(ReportMain reportMain) {
        this.setFloatable(false);
        this.reportMain = reportMain;
        this.setBorder(new TitledBorder(""));
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String[] displayFontName = new String[this.fontList.length];
        for (int i = 0; i < this.fontList.length; ++i) {
            displayFontName[i] = this.getDisplayName(this.fontList[i]);
        }
        this.fontFaceBox = new JComboBox<String>(displayFontName);
        this.fontFaceBox.setSelectedIndex(0);
        this.fontFaceBox.addItemListener(this);
        this.fontSizeBox = new SpinBox(3, 99);
        boolean isAdjustFont = reportMain.report == null ? true : reportMain.report.isAdjustFont();
        this.fontSizeBox.setValue(QbUtil.getAdjustedFont(12, isAdjustFont));
        this.fontSizeBox.addActionListener(this);
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.add((Component)this.fontFaceBox, "Center");
        fontPanel.add((Component)this.fontSizeBox, "East");
        fontPanel.setMaximumSize(new Dimension(228, 35));
        fontPanel.setMinimumSize(new Dimension(228, 35));
        this.add(fontPanel);
        this.addSeparator();
        this.boldBt = new JToggleButton();
        this.addNewButton(this.boldBt, LanguageEncoder.getText("Bold"), "BOLD", "BoldIcon.png");
        this.italicBt = new JToggleButton();
        this.addNewButton(this.italicBt, LanguageEncoder.getText("Italic"), "ITALIC", "ItalicIcon.png");
        this.underlineBt = new JToggleButton();
        this.addNewButton(this.underlineBt, LanguageEncoder.getText("Underline"), "UNDERLINE", "UnderlineIcon.png");
        this.hAlignLeftBt = new JToggleButton();
        this.addNewButton(this.hAlignLeftBt, LanguageEncoder.getText("Horizontal Align Left"), "H_ALIGN_LEFT", "LeftAlignIcon.png");
        this.hAlignCenterBt = new JToggleButton();
        this.addNewButton(this.hAlignCenterBt, LanguageEncoder.getText("Horizontal Align Center"), "H_ALIGN_CENTER", "CenterAlignIcon.png");
        this.hAlignRightBt = new JToggleButton();
        this.addNewButton(this.hAlignRightBt, LanguageEncoder.getText("Horizontal Align Right"), "H_ALIGN_RIGHT", "RightAlignIcon.png");
        this.horizAlign.add(this.hAlignLeftBt);
        this.horizAlign.add(this.hAlignCenterBt);
        this.horizAlign.add(this.hAlignRightBt);
        this.addSeparator();
        this.editBt = new JButton();
        this.addNewButton(this.editBt, LanguageEncoder.getText("Edit Selected Object"), "EDIT", "EditIcon.png");
        this.dataFormatBt = new JButton();
        this.addNewButton(this.dataFormatBt, LanguageEncoder.getText("Data Format"), "DATA_FORMAT", "DataFormatIcon.png");
        this.scriptingBt = new JButton();
        this.addNewButton(this.scriptingBt, LanguageEncoder.getText("Scripting"), "SCRIPTING", "ScriptingIcon.png");
        this.fontColorBt = new JButton();
        this.addNewButton(this.fontColorBt, LanguageEncoder.getText("Font Style and Size"), "FONT STYLE AND SIZE", "FontColorIcon.png");
        this.bgColorBt = new JButton();
        this.addNewButton(this.bgColorBt, LanguageEncoder.getText("Background Color"), "BG_COLOR", "BackgroundColorIcon.png");
        this.borderBt = new JButton();
        this.addNewButton(this.borderBt, LanguageEncoder.getText("Border"), "BORDER", "BorderIcon.png");
        this.dualColorsBt = new JButton();
        this.addNewButton(this.dualColorsBt, LanguageEncoder.getText("Dual Colors"), "DUAL_COLORS", "DualColorsIcon.png");
        this.boundsBt = new JButton();
        this.addNewButton(this.boundsBt, LanguageEncoder.getText("Bounds"), "BOUNDS", "BoundsIcon.png");
        this.addSeparator();
        this.pageSetupBt = new JButton();
        this.addNewButton(this.pageSetupBt, LanguageEncoder.getText("Page Setup"), "PAGE_SETUP", "PageSetupIcon.png");
        this.previewDisplayRowsBt = new JButton();
        this.addNewButton(this.previewDisplayRowsBt, LanguageEncoder.getText("Preview Display Options"), "PREVIEW_DISPLAY_OPTIONS", "PreviewOptionsIcon.png");
    }

    private String getDisplayName(String orgName) {
        if (orgName.length() > 20) {
            return orgName.substring(0, 17) + "...";
        }
        return orgName;
    }

    private void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    private void addNewButton(JButton newBtn, String tip, String command, String img) {
        img = ServerMessage.reportImagesPath + img;
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading image icon [" + img, e);
        }
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    private void addNewButton(JToggleButton newBtn, String tip, String command, String img) {
        img = ServerMessage.reportImagesPath + img;
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading image icon [" + img, e);
        }
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    @Override
    public void setEnabled(boolean b) {
        this.fontFaceBox.setEnabled(b);
        this.fontSizeBox.setEnabled(b);
        this.boldBt.setEnabled(b);
        this.italicBt.setEnabled(b);
        this.underlineBt.setEnabled(b);
        this.hAlignLeftBt.setEnabled(b);
        this.hAlignCenterBt.setEnabled(b);
        this.hAlignRightBt.setEnabled(b);
        this.editBt.setEnabled(b);
        this.dataFormatBt.setEnabled(b);
        this.scriptingBt.setEnabled(b);
        this.fontColorBt.setEnabled(b);
        this.bgColorBt.setEnabled(b);
        this.borderBt.setEnabled(b);
        this.dualColorsBt.setEnabled(b);
        this.boundsBt.setEnabled(b);
        this.pageSetupBt.setEnabled(b);
        this.previewDisplayRowsBt.setEnabled(b);
    }

    public void setObject(ReportElement elt) {
        this.setSelectingObject = true;
        if (elt instanceof ReportImage || elt instanceof ReportTableElement) {
            this.resetObject();
        }
        Font font = elt.getRefFont();
        this.setFontFace(font);
        this.fontSizeBox.setValue(font.getSize());
        this.boldBt.setSelected(font.isBold());
        this.italicBt.setSelected(font.isItalic());
        this.underlineBt.setSelected(elt.isUnderline());
        this.hAlignLeftBt.setSelected(elt.getAlign() == 1);
        this.hAlignCenterBt.setSelected(elt.getAlign() == 0);
        this.hAlignRightBt.setSelected(elt.getAlign() == 2);
        this.setSelectingObject = false;
    }

    public void setGroupObject() {
        this.setSelectingObject = true;
        Font font = this.reportMain.designPanel.rulerPanel.groupFormatInitFont();
        String fontName = this.reportMain.designPanel.rulerPanel.groupFormatInitFontName();
        boolean fontItalic = this.reportMain.designPanel.rulerPanel.groupFormatInitFontItalic();
        boolean fontBold = this.reportMain.designPanel.rulerPanel.groupFormatInitFontBold();
        int fontSize = this.reportMain.designPanel.rulerPanel.groupFormatInitFontSize();
        int align = this.reportMain.designPanel.rulerPanel.groupFormatInitHAlignment();
        boolean underline = this.reportMain.designPanel.rulerPanel.groupFormatInitFontUnderline();
        if (font != null) {
            this.setFontFace(font);
            this.fontSizeBox.setValue(font.getSize());
            this.boldBt.setSelected(font.isBold());
            this.italicBt.setSelected(font.isItalic());
        } else {
            if (fontName != null) {
                this.setFontFace(font);
            }
            if (fontSize != -1) {
                this.fontSizeBox.setValue(fontSize);
            }
            this.boldBt.setSelected(fontBold);
            this.italicBt.setSelected(fontItalic);
        }
        this.underlineBt.setSelected(underline);
        this.hAlignLeftBt.setSelected(align == 1);
        this.hAlignCenterBt.setSelected(align == 0);
        this.hAlignRightBt.setSelected(align == 2);
        this.setSelectingObject = false;
    }

    public void resetObject() {
        this.boldBt.setSelected(false);
        this.italicBt.setSelected(false);
        this.underlineBt.setSelected(false);
        this.hAlignLeftBt.setSelected(false);
        this.hAlignCenterBt.setSelected(false);
        this.hAlignRightBt.setSelected(false);
    }

    public void setFontFace(Font font) {
        if (font == null) {
            return;
        }
        this.fontFaceBox.setSelectedIndex(this.getName(font.getName()));
    }

    private int getName(String str) {
        int lastDot = (str = str.toLowerCase()).lastIndexOf(46);
        if (lastDot > -1) {
            str = str.substring(0, lastDot);
        }
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!str.equals(this.fontList[i].toLowerCase())) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reportMain.isDesignMode = true;
        String command = e.getActionCommand();
        this.reportMain.createBackupReport();
        if (e.getSource() == this.fontSizeBox) {
            this.reportMain.setEltFontSize(this.fontSizeBox.getValue());
        } else if (command.equals("BOLD")) {
            this.reportMain.setEltFontBold(this.boldBt.isSelected());
        } else if (command.equals("ITALIC")) {
            this.reportMain.setEltFontItalic(this.italicBt.isSelected());
        } else if (command.equals("UNDERLINE")) {
            this.reportMain.setEltUnderline(this.underlineBt.isSelected());
        } else if (command.equals("H_ALIGN_LEFT")) {
            this.reportMain.setEltAlign((short)1);
        } else if (command.equals("H_ALIGN_CENTER")) {
            this.reportMain.setEltAlign((short)0);
        } else if (command.equals("H_ALIGN_RIGHT")) {
            this.reportMain.setEltAlign((short)2);
        } else if (command.equals("EDIT")) {
            this.reportMain.setEltText();
        } else if (command.equals("DATA_FORMAT")) {
            this.reportMain.setEltFormat();
        } else if (command.equals("SCRIPTING")) {
            this.reportMain.setEltScript();
        } else if (command.equals("FONT STYLE AND SIZE")) {
            this.reportMain.setEltFont();
        } else if (command.equals("BG_COLOR")) {
            this.reportMain.setEltBackgroundColor();
        } else if (command.equals("BORDER")) {
            this.reportMain.setEltBorder();
        } else if (command.equals("DUAL_COLORS")) {
            this.reportMain.setEltDualColors();
        } else if (command.equals("BOUNDS")) {
            this.reportMain.setEltBounds();
        } else if (command.equals("PAGE_SETUP")) {
            this.reportMain.pageSetup();
        } else if (command.equals("PREVIEW_DISPLAY_OPTIONS")) {
            this.reportMain.setPreviewDataOptions();
        } else {
            LOGGER.warning("Unknown command: " + command);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.setSelectingObject) {
            return;
        }
        Object obj = e.getSource();
        if (e.getStateChange() == 1) {
            this.reportMain.createBackupReport();
            if (obj == this.fontFaceBox) {
                this.reportMain.setEltFontFace(this.fontList[this.fontFaceBox.getSelectedIndex()]);
            }
        }
    }
}

