/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.InternalListItem;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class DrillDownColumnMapDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DrillDownColumnMapDialog.class.getName());
    private boolean modified = false;
    private Report report = null;
    private JComboBox[] columnChoices = null;
    private JButton okButton;
    private JButton cancelButton;
    private int[] colInfo_indices = null;
    QueryInParam[] params = null;

    public DrillDownColumnMapDialog(JFrame parent, Report r, QueryInParamSet pset, boolean crossTabDrillDown) throws Exception {
        super((Frame)parent, true);
        this.init(r, pset, crossTabDrillDown);
    }

    public DrillDownColumnMapDialog(JDialog parent, Report r, QueryInParamSet pset, boolean crossTabDrillDown) throws Exception {
        super((Dialog)parent, true);
        this.init(r, pset, crossTabDrillDown);
    }

    private void init(Report r, QueryInParamSet pset, boolean crossTabDrillDown) throws Exception {
        if (r == null) {
            throw new Exception(LanguageEncoder.getText("Parent report not found.\nPlease open a report and try again."));
        }
        if (pset == null || pset.getParameter() == null) {
            throw new Exception(LanguageEncoder.getText("Parameters are not properly initialized.\nPlease modify the query and try again."));
        }
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Parameter to Column/Parameter Mapping"));
        this.setDefaultCloseOperation(2);
        this.report = r;
        this.params = pset.getParameter();
        JPanel topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        this.columnChoices = new JComboBox[this.params.length];
        boolean mapToColumn = false;
        for (int i = 0; i < this.params.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i;
            QueryInParam currP = this.params[i];
            Label comp = new Label(currP.getPromptName());
            gbl.setConstraints(comp, gbc);
            topPanel.add(comp);
            Vector<InternalListItem> compColumns = DrillDownColumnMapDialog.getCompatibleColumns(currP.getSqlType(), this.report, crossTabDrillDown);
            if (compColumns == null) {
                compColumns = new Vector();
            } else {
                mapToColumn = true;
            }
            compColumns.addElement((InternalListItem)((Object)"None"));
            this.columnChoices[i] = new JComboBox<InternalListItem>(compColumns);
            gbc.gridx = 1;
            gbl.setConstraints(this.columnChoices[i], gbc);
            topPanel.add(this.columnChoices[i]);
        }
        if (!mapToColumn) {
            throw new Exception(LanguageEncoder.getText("Failed to find a compatible column field for any of the parameters.") + "\n" + LanguageEncoder.getText("At least one parameter must map to a column."));
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)topPanel, "Center");
        contentPanel.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    public static Vector<InternalListItem> getCompatibleColumns(int sqlType, Report report) {
        return DrillDownColumnMapDialog.getCompatibleColumns(sqlType, report, false);
    }

    public static Vector<InternalListItem> getCompatibleColumns(int sqlType, Report report, boolean crossTabDrillDown) {
        try {
            int i;
            Vector<InternalListItem> ret = new Vector<InternalListItem>();
            if (crossTabDrillDown) {
                for (int i2 = 0; i2 < report.colInfo.length; ++i2) {
                    if (report.colInfo[i2].isColumnBreakValue() || !DataType.isCompatibleSQLTypes(sqlType, report.getSQLType(i2, true))) continue;
                    ret.addElement(new InternalListItem(report.colInfo[i2].getName(), i2, null));
                }
            } else {
                ReportTable tbl = report.getReportTables().elementAt(0);
                for (int i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                    if (!DataType.isCompatibleSQLTypes(sqlType, report.getSQLType(report.getColInfoIndex(tbl.getColumn(i3))))) continue;
                    ret.addElement(new InternalListItem(tbl.getColumn(i3).getText(), i3, tbl.getColumn(i3).getID()));
                }
            }
            Vector<Parameter> queryParams = report.getQueryParameters();
            Vector<Parameter> formulaParams = report.getFormulaParameters();
            int numberOfQueryParams = queryParams.size();
            int numberOfFormulaParams = formulaParams.size();
            int l = ret.size();
            for (i = 0; i < numberOfQueryParams; ++i) {
                ret.addElement(new InternalListItem(":" + queryParams.elementAt(i).getName(), i + 1000, null));
            }
            l = ret.size();
            for (i = 0; i < numberOfFormulaParams; ++i) {
                ret.addElement(new InternalListItem(":" + formulaParams.elementAt(i).getName(), i + 2000, null));
            }
            if (ret.size() <= 0) {
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Cannot load list of compatible columns", e);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            boolean mapToColumn = false;
            try {
                this.colInfo_indices = new int[this.columnChoices.length];
                for (int i = 0; i < this.columnChoices.length; ++i) {
                    if (this.columnChoices[i].getSelectedItem() instanceof InternalListItem) {
                        this.colInfo_indices[i] = ((InternalListItem)this.columnChoices[i].getSelectedItem()).colInfo_index;
                        mapToColumn = true;
                        continue;
                    }
                    if (!((String)this.columnChoices[i].getSelectedItem()).equals("None")) continue;
                    if (this.params[i].getDefaultValue() == null || this.params[i].getDefaultValue().equals("")) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Unmapped drilldown parameter must have a default value! Please cancel and modify the query parameter(s)"));
                        return;
                    }
                    this.colInfo_indices[i] = -1;
                }
                if (!mapToColumn) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("At least one parameter must map to a column"));
                    return;
                }
                this.modified = true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to perform action", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An unexpected error has occured.\nPlease cancel and try again."));
                this.colInfo_indices = null;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int[] getColInfoIndices() {
        if (!this.modified) {
            return null;
        }
        return this.colInfo_indices;
    }
}

