/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;

public class DrillDownNavigationFrame
extends JFrame
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DrillDownNavigationFrame.class.getName());
    private ReportMain reportMain;
    private JButton addBut;
    private JButton removeBut;
    private JButton editBut;
    private JButton closeBut;
    private JScrollPane scrollPane;
    private JTree tree;

    public DrillDownNavigationFrame(ReportMain rm) throws Exception {
        super(LanguageEncoder.getText("Drill-Down Navigation"));
        if (rm == null || rm.getDrillDownTree() == null) {
            throw new Exception(LanguageEncoder.getText("Failed to initialize drill-down navigation window."));
        }
        this.reportMain = rm;
        this.setDefaultCloseOperation(2);
        this.tree = rm.getDrillDownTree();
        this.setupTree(this.tree);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.scrollPane, "Center");
        contentPanel.add((Component)this.getButtonPanel(), "East");
        this.reportMain.getDrillDownTree().setSelectionRow(0);
        this.setPosition();
    }

    public void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.height = 300;
        dim.width = 400;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private boolean isRemoveEnable(DrillDownNode node) {
        return node != null && !node.equals((DrillDownNode)this.reportMain.getDrillDownTree().getModel().getRoot());
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1, 5, 5));
        this.editBut = new JButton(LanguageEncoder.getText("EDIT"));
        panel.add(this.editBut);
        this.addBut = new JButton(LanguageEncoder.getText("ADD"));
        panel.add(this.addBut);
        this.removeBut = new JButton(LanguageEncoder.getText("REMOVE"));
        panel.add(this.removeBut);
        this.closeBut = new JButton(LanguageEncoder.getText("CLOSE"));
        panel.add(this.closeBut);
        this.editBut.addActionListener(this);
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.closeBut.addActionListener(this);
        return panel;
    }

    public boolean doEdit(DrillDownNode node) {
        if (node != null && !node.equals(this.reportMain.report.currentNode)) {
            boolean success;
            block19: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                success = false;
                try {
                    String nodeFileName = node.getFileName(this.reportMain.getSubFilesTable());
                    byte[] bytes = this.reportMain.getSubFilesTable().get(nodeFileName);
                    if (bytes != null) {
                        success = this.reportMain.openFileFromMemoryTable(nodeFileName, bytes);
                    } else {
                        FileInfo file = new FileInfo(nodeFileName);
                        if (file.exists()) {
                            success = this.reportMain.openFile(nodeFileName);
                        }
                    }
                    if (success && (this.reportMain.report.currentNode == null || this.reportMain.report.currentNode.getUserObject() == null)) {
                        this.reportMain.report.currentNode = node;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to edit drill-down node", ex);
                    if (node.getByteArray() == null) break block19;
                    try {
                        Report newReport = new LoadReport(true).loadReport(new DataInputStream(new ByteArrayInputStream(node.getByteArray())), null);
                        if (this.reportMain.report.currentNode != null) {
                            this.reportMain.report.currentNode.setSelected(false);
                            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.reportMain.report.currentNode);
                        }
                        this.reportMain.setReport(newReport);
                        success = true;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to recreate report", e);
                    }
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (success) {
                if (node.getChartPath() != null) {
                    this.reportMain.report.setChartPath(node.getChartPath());
                }
                if (node.getImagePath() != null) {
                    this.reportMain.report.setImagePath(node.getImagePath());
                }
                if (node.getSubReportPath() != null) {
                    this.reportMain.report.setSubReportPath(node.getSubReportPath());
                }
                if (node.getDrillDownPath() != null) {
                    this.reportMain.report.setDrillDownPath(node.getDrillDownPath());
                }
                JTree drilldownTree = this.reportMain.getDrillDownTree();
                DrillDownNode rootNode = (DrillDownNode)drilldownTree.getModel().getRoot();
                if (node.getFileName(this.reportMain.getSubFilesTable()).equals(rootNode.getFileName(this.reportMain.getSubFilesTable()))) {
                    this.reportMain.report.currentNode = rootNode;
                    if (this.reportMain.report.parentNode != null) {
                        this.reportMain.menuBar.setMenuForSubReport();
                        this.reportMain.designPanel.designToolBar.setToolbarForSubReport();
                    }
                } else {
                    rootNode.setSelected(false);
                    ((DefaultTreeModel)this.tree.getModel()).nodeChanged(rootNode);
                    this.reportMain.menuBar.setMenuForDrillDown();
                    this.reportMain.designPanel.designToolBar.setToolbarForDrillDown();
                }
                ((DefaultTreeModel)drilldownTree.getModel()).reload();
                this.reportMain.report.currentNode.setSelected(true);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.reportMain.report.currentNode);
                this.reportMain.menuBar.showCellOutline.setSelected(this.reportMain.report.showCellOutline);
                this.reportMain.menuBar.shift.setSelected(false);
                this.reportMain.menuBar.formulaName.setSelected(this.reportMain.report.showFormulaNameSelected);
                this.reportMain.menuBar.prevParamPrompt.setSelected(this.reportMain.report.isPrevParamPrompt);
                DrillDownNavigationFrame.expandAllTreeNodes(drilldownTree);
                drilldownTree.setSelectionRow(node.getLevel());
            }
            if (!success) {
                this.setVisible(false);
                this.dispose();
            }
            return success;
        }
        return true;
    }

    private static void expandAllTreeNodes(JTree tree) {
        if (tree != null) {
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
        }
    }

    private void doRemove(DrillDownNode node) {
        if (!this.isRemoveEnable(node)) {
            return;
        }
        DrillDownNode parentNode = (DrillDownNode)node.getParent();
        boolean deletedCurrent = this.removeDrillDownNode(node);
        if (deletedCurrent) {
            try {
                boolean exists = false;
                String fname = "";
                try {
                    fname = ((DrillDownNode)this.reportMain.getDrillDownTree().getModel().getRoot()).getFileName(this.reportMain.getSubFilesTable());
                    exists = SaveReport.isPAKFile(fname) ? this.reportMain.getSubFilesTable().containsKey(fname) : new FileInfo(fname).exists();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to check if file exists", ex);
                }
                if (exists) {
                    this.reportMain.saveTree(fname, (DrillDownNode)this.reportMain.getDrillDownTree().getModel().getRoot());
                } else {
                    this.reportMain.saveTree(this.reportMain.getTitle(), (DrillDownNode)this.reportMain.getDrillDownTree().getModel().getRoot());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to update drill-down structure", ex);
                new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to update drill-down structure.\n") + LanguageEncoder.getText("This file may be corrupted. Drill-down reports may not work properly in the future."));
            }
            this.doEdit(parentNode);
        }
        for (int i = 0; i < this.reportMain.getDrillDownTree().getRowCount(); ++i) {
            this.reportMain.getDrillDownTree().setSelectionRow(i);
            DrillDownNode node2 = (DrillDownNode)this.reportMain.getDrillDownTree().getSelectionPath().getLastPathComponent();
            if (node2.equals(this.reportMain.report.currentNode)) break;
        }
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ReportColumn column = table.getColumn(i);
            if (column.getDrillDownName() != null && column.getDrillDownName().equals(node.getName())) {
                column.setDrillDownName(null);
            }
            column.setLink("");
        }
        this.reportMain.setModified();
        this.reportMain.setIsUndoEnabled(false);
        this.reportMain.clearUndoRedoList();
        if (this.reportMain.isReportOpenedInPakFormat()) {
            SaveReport saveReport = new SaveReport(this.reportMain.report);
            saveReport.setSubFilesTable(this.reportMain.getSubFilesTable());
            try {
                this.reportMain.saveToFile(saveReport, this.reportMain.report.getFileName(), true);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to save report into memory after removing drilldown.", e);
            }
        } else {
            this.reportMain.save(this.reportMain.getRPTFileName());
        }
        this.reportMain.getDrillDownTree().validate();
        this.reportMain.getDrillDownTree().repaint();
    }

    private boolean removeDrillDownNode(DrillDownNode node) {
        boolean deleted = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.removeDrillDownNode(node.getChildAt(i))) continue;
            deleted = true;
        }
        if (node == this.reportMain.report.currentNode) {
            deleted = true;
        }
        if (this.reportMain.isReportOpenedInPakFormat()) {
            this.reportMain.getSubFilesTable().remove(node.getFileName());
        } else {
            new DeleteFile(node.getFileName()).delete();
        }
        ((DefaultTreeModel)this.reportMain.getDrillDownTree().getModel()).removeNodeFromParent(node);
        return deleted;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.reportMain.getDrillDownTree().isSelectionEmpty()) {
            DrillDownNode node = (DrillDownNode)this.reportMain.getDrillDownTree().getSelectionPath().getLastPathComponent();
            if (e.getSource() == this.editBut) {
                this.doEdit(node);
            } else if (e.getSource() == this.addBut) {
                if (node != this.reportMain.report.currentNode && !this.doEdit(node)) {
                    return;
                }
                this.setVisible(false);
                this.dispose();
                this.reportMain.addDrillDown();
            } else if (e.getSource() == this.removeBut) {
                this.doRemove(node);
            }
        }
        if (e.getSource() == this.closeBut) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean state) {
        if (state && this.reportMain.getDrillDownTree() != null) {
            int rowCount = this.reportMain.getDrillDownTree().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.reportMain.getDrillDownTree().expandPath(this.reportMain.getDrillDownTree().getPathForRow(i));
            }
            this.reportMain.getDrillDownTree().setSelectionRow(0);
        }
        super.setVisible(state);
    }

    public void updateTree(JTree newTree) {
        if (this.scrollPane != null) {
            try {
                this.scrollPane.getViewport().remove(this.tree);
                this.scrollPane.getViewport().add(newTree);
                this.setupTree(newTree);
                this.tree = newTree;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to update drill-down tree", ex);
            }
        }
    }

    private void setupTree(JTree t) {
        t.getSelectionModel().setSelectionMode(1);
        t.setShowsRootHandles(true);
        DrillDownNavigationFrame.expandAllTreeNodes(t);
        t.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DrillDownNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DrillDownNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                if (tn == null) {
                    DrillDownNavigationFrame.this.editBut.setEnabled(false);
                    DrillDownNavigationFrame.this.addBut.setEnabled(false);
                } else {
                    DrillDownNavigationFrame.this.editBut.setEnabled(true);
                    DrillDownNavigationFrame.this.addBut.setEnabled(true);
                }
                DrillDownNavigationFrame.this.removeBut.setEnabled(DrillDownNavigationFrame.this.isRemoveEnable(tn));
            }
        });
    }
}

