/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetFontDialog;
import quadbase.reportdesigner.util.ColInfo;

public class DualColorsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DualColorsDialog.class.getName());
    private JButton bgColorButton;
    private JButton fontStyleButton;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox dualCheck;
    private JCheckBox styleCheck;
    private JTextField styleNameField;
    private JRadioButton rowIndexButton;
    private JRadioButton rowBreakButton;
    private JRadioButton columnValueButton;
    private JTextField indexField;
    private JList columnList;
    private ReportColumn column;
    private ReportMain reportMain;
    private ColorDialog bgColorDialog;
    private SetFontDialog setFontDialog;
    private Color bgColor;
    private Color fontColor;
    private boolean isUnderline;
    private Font font;
    private int rowIndex;
    private boolean rowBreak;
    private int[] colInfoIndex;
    private boolean modified = false;
    private String styleName;
    private int[] colInfo;

    public DualColorsDialog(ReportMain reportMain, ReportColumn column) {
        super(reportMain, LanguageEncoder.getText("Dual Colors ..."), true);
        this.reportMain = reportMain;
        this.column = column;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        int i;
        this.setBackground(Color.lightGray);
        this.bgColor = new Color(233, 233, 233);
        this.fontColor = Color.black;
        boolean isAdjustFont = this.reportMain.report == null ? true : this.reportMain.report.isAdjustFont();
        this.font = new Font("Dialog", 0, QbUtil.getAdjustedFont(12, isAdjustFont));
        this.rowIndex = 0;
        this.rowBreak = false;
        this.colInfoIndex = null;
        this.styleName = "";
        if (this.column != null) {
            this.bgColor = this.column.getBgColor2();
            this.fontColor = this.column.getFontColor2();
            this.font = this.column.getFont2();
            this.isUnderline = this.column.isUnderline2();
            this.rowIndex = this.column.getAlternateRow();
            this.rowBreak = this.column.isDualColorOnRowBreak();
            this.colInfoIndex = this.column.getDualColorColInfoIndex();
            this.styleName = this.column.getStyleName2();
        }
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Set Dual Colors")));
        p1.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        JPanel dualCheckPanel = new JPanel(new FlowLayout(0));
        this.dualCheck = new JCheckBox(LanguageEncoder.getText("Enable Dual Colors"), this.rowIndex > 0 || this.rowBreak || this.colInfoIndex != null);
        dualCheckPanel.add(this.dualCheck);
        this.dualCheck.addItemListener(this);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new FlowLayout(0));
        this.styleCheck = new JCheckBox(LanguageEncoder.getText("Use Div Style Class Name"), !this.styleName.equals(""));
        this.styleNameField = new JTextField(this.styleName, 20);
        this.styleNameField.setEnabled(this.styleCheck.isSelected());
        this.styleCheck.addItemListener(this);
        stylePanel.add(this.styleCheck);
        stylePanel.add(this.styleNameField);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setBorder(new TitledBorder(""));
        radioButtonPanel.setLayout(new BorderLayout());
        JPanel indexPanel = new JPanel();
        indexPanel.setLayout(new GridLayout(1, 2));
        this.rowIndexButton = new JRadioButton(LanguageEncoder.getText("Row Index"), this.rowIndex > 0);
        this.rowIndexButton.addItemListener(this);
        this.indexField = new JTextField(this.rowIndex + "", 5);
        if (!this.isCrosstab()) {
            indexPanel.add(this.rowIndexButton);
            indexPanel.add(this.indexField);
        }
        JPanel breakPanel = new JPanel();
        breakPanel.setLayout(new GridLayout(1, 2));
        this.rowBreakButton = new JRadioButton(LanguageEncoder.getText("Row Break"), this.rowBreak);
        if (!this.isCrosstab()) {
            breakPanel.add(this.rowBreakButton);
        }
        JPanel columnPanel = new JPanel();
        columnPanel.setLayout(new GridLayout(1, 2));
        this.columnValueButton = new JRadioButton(LanguageEncoder.getText("Column Value Change"), this.colInfoIndex != null);
        this.columnValueButton.addItemListener(this);
        if (this.isCrosstab()) {
            columnPanel.add(new Label("Column Value Change"));
            int ct = 0;
            for (ColInfo element : this.reportMain.report.colInfo) {
                if (!element.isRowBreak()) continue;
                ++ct;
            }
            this.colInfo = new int[ct];
            ct = 0;
            for (i = 0; i < this.reportMain.report.colInfo.length; ++i) {
                if (!this.reportMain.report.colInfo[i].isRowBreak()) continue;
                this.colInfo[ct++] = i;
            }
        } else {
            columnPanel.add(this.columnValueButton);
            this.colInfo = new int[this.reportMain.report.colInfo.length];
            for (int i2 = 0; i2 < this.reportMain.report.colInfo.length; ++i2) {
                this.colInfo[i2] = i2;
            }
        }
        String[] columnNames = new String[this.colInfo.length];
        for (i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.reportMain.report.colInfo[this.colInfo[i]].getName();
        }
        this.columnList = new JList<String>(columnNames);
        if (this.colInfoIndex != null) {
            int[] temp = new int[this.colInfoIndex.length];
            for (int i3 = 0; i3 < this.colInfoIndex.length; ++i3) {
                for (int j = 0; j < this.colInfo.length; ++j) {
                    if (this.colInfoIndex[i3] != this.colInfo[j]) continue;
                    temp[i3] = j;
                }
            }
            this.columnList.setSelectedIndices(temp);
        }
        columnPanel.add(new JScrollPane(this.columnList));
        radioButtonPanel.add((Component)indexPanel, "North");
        radioButtonPanel.add((Component)breakPanel, "Center");
        radioButtonPanel.add((Component)columnPanel, "South");
        upperPanel.add((Component)dualCheckPanel, "North");
        upperPanel.add((Component)stylePanel, "Center");
        upperPanel.add((Component)radioButtonPanel, "South");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(1, 3, 5, 5));
        this.bgColorButton = new JButton(LanguageEncoder.getText("Background Color"));
        optionPanel.add(this.bgColorButton);
        this.bgColorButton.addActionListener(this);
        this.fontStyleButton = new JButton(LanguageEncoder.getText("Font Style And Size"));
        optionPanel.add(this.fontStyleButton);
        this.fontStyleButton.addActionListener(this);
        if (!this.isCrosstab()) {
            ButtonGroup group = new ButtonGroup();
            group.add(this.rowIndexButton);
            group.add(this.rowBreakButton);
            group.add(this.columnValueButton);
        }
        p1.add((Component)upperPanel, "Center");
        p1.add((Component)optionPanel, "South");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setDualEnabled();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
    }

    private boolean isCrosstab() {
        return this.reportMain.report.reportType == 2;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setDualEnabled();
    }

    private void setDualEnabled() {
        this.rowIndexButton.setEnabled(this.dualCheck.isSelected());
        this.rowBreakButton.setEnabled(this.dualCheck.isSelected());
        this.indexField.setEnabled(this.rowIndexButton.isSelected());
        if (this.rowIndexButton.isSelected() && this.rowIndex == 0) {
            this.rowIndex = 1;
            this.indexField.setText(this.rowIndex + "");
        }
        this.columnValueButton.setEnabled(this.dualCheck.isSelected());
        this.columnList.setEnabled(this.dualCheck.isSelected() && (this.isCrosstab() || this.columnValueButton.isSelected()));
        this.bgColorButton.setEnabled(this.dualCheck.isSelected());
        this.fontStyleButton.setEnabled(this.dualCheck.isSelected());
        this.styleNameField.setEnabled(this.styleCheck.isSelected());
    }

    Color getBackgroundColor() {
        return this.bgColor;
    }

    Color getFontColor() {
        return this.fontColor;
    }

    Font getFontStyle() {
        return this.font;
    }

    boolean isUnderline() {
        return this.isUnderline;
    }

    int getRowIndex() {
        return this.rowIndex;
    }

    boolean getRowBreak() {
        return this.rowBreak;
    }

    int[] getDualColorColInfoIndex() {
        return this.colInfoIndex;
    }

    boolean isModified() {
        return this.modified;
    }

    String getStyleName() {
        return this.styleName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bgColorButton) {
            if (this.bgColorDialog == null) {
                this.bgColorDialog = new ColorDialog(this.reportMain, true, 4, this.bgColor);
            }
            this.bgColorDialog.setVisible(true);
            return;
        }
        if (e.getSource() == this.fontStyleButton) {
            if (this.setFontDialog == null) {
                this.setFontDialog = new SetFontDialog(this.reportMain, this.font, this.isUnderline, this.fontColor, 4);
            }
            this.setFontDialog.setVisible(true);
            return;
        }
        if (e.getSource() == this.okButton) {
            this.modified = true;
            if (this.styleCheck.isSelected() && this.styleNameField.getText().trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please specify the style class name!"));
                return;
            }
            if (this.dualCheck.isSelected()) {
                if (this.rowIndexButton.isSelected()) {
                    try {
                        int tmpIndex;
                        this.rowIndex = tmpIndex = Integer.parseInt(this.indexField.getText());
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.FINEST, "Row Index: Invalid number", ex);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Row Index: Integer Only!"));
                        return;
                    }
                } else {
                    this.rowIndex = 0;
                }
                this.rowBreak = this.rowBreakButton.isSelected();
                if (this.columnValueButton.isSelected() || this.isCrosstab()) {
                    if (this.columnList.getSelectedIndices() == null || this.columnList.getSelectedIndices().length == 0) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You must select at least one column which the value change is based on"));
                        return;
                    }
                    this.colInfoIndex = new int[this.columnList.getSelectedIndices().length];
                    for (int i = 0; i < this.columnList.getSelectedIndices().length; ++i) {
                        this.colInfoIndex[i] = this.colInfo[this.columnList.getSelectedIndices()[i]];
                    }
                } else {
                    this.colInfoIndex = null;
                }
            } else {
                this.rowIndex = 0;
                this.rowBreak = false;
                this.colInfoIndex = null;
            }
            this.styleName = this.styleNameField.getText().trim();
            if (!this.styleCheck.isSelected()) {
                this.styleName = "";
            }
            if (this.bgColorDialog != null) {
                this.bgColor = this.bgColorDialog.getColor();
            }
            if (this.setFontDialog != null) {
                this.font = this.setFontDialog.getFont();
                this.fontColor = this.setFontDialog.getFontColor();
                this.isUnderline = this.setFontDialog.isUnderline();
            }
            if (this.reportMain.groupFormatFlag()) {
                this.reportMain.setIsUndoEnabled(true);
            } else {
                this.reportMain.menuBar.setUndoEnabled(true);
            }
        }
        this.setVisible(false);
        this.dispose();
    }
}

