/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ReportExplorer;
import quadbase.reportdesigner.designer.ReportIcons;
import quadbase.reportdesigner.report.Script;

public class ExplorerTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final Logger LOGGER = Logger.getLogger(ExplorerTreeCellRenderer.class.getName());
    private ImageIcon sectionIcon = ReportIcons.getIcon(ReportIcons.EXP_COLLSECTION);
    private ImageIcon sectionIconExpanded = ReportIcons.getIcon(ReportIcons.EXP_EXPSECTION);
    private ImageIcon columnIcon = ReportIcons.getIcon(ReportIcons.EXP_COLUMN);
    private ImageIcon formulaIcon = ReportIcons.getIcon(ReportIcons.EXP_FORMULA);
    private ImageIcon reportChartObjectIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_CHART_OBJECT);
    private ImageIcon reportLineIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_LINE);
    private ImageIcon reportRectangleIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_RECTACTANGLE);
    private ImageIcon reportImageIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_IMAGE);
    private ImageIcon reportDocumentIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_DOCUMENT);
    private ImageIcon subReportObjectIcon = ReportIcons.getIcon(ReportIcons.EXP_SUB_REPORT_OBJECT);
    private ImageIcon reportRTFObjectIcon = ReportIcons.getIcon(ReportIcons.EXP_REPORT_RTF_OBJECT);
    private ImageIcon labelIcon = ReportIcons.getIcon(ReportIcons.EXP_LABEL);
    private ImageIcon rootIcon = ReportIcons.getIcon(ReportIcons.EXP_ROOT);
    private ImageIcon columnHeaderIcon = ReportIcons.getIcon(ReportIcons.EXP_COLUMN_HEADER);
    private Script script;

    public ExplorerTreeCellRenderer(Script script) {
        this.script = script;
    }

    public int getIconHeight() {
        if (this.sectionIcon == null) {
            return 0;
        }
        return this.sectionIcon.getIconHeight();
    }

    private void setSectionIcon(DefaultMutableTreeNode node, boolean expanded) {
        if (node.getLevel() > 0) {
            this.setIcon(expanded ? this.sectionIconExpanded : this.sectionIcon);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ReportElement elt;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof String) {
            this.setText((String)node.getUserObject());
            this.setIcon(this.rootIcon);
        } else if (node.getUserObject() instanceof ReportTable) {
            elt = (ReportTable)node.getUserObject();
            this.setText(ExplorerTreeCellRenderer.getName(elt, this.script));
            this.setSectionIcon(node, expanded);
        } else if (node.getUserObject() instanceof ReportSection) {
            elt = (ReportSection)node.getUserObject();
            this.setText(ExplorerTreeCellRenderer.getName(elt, this.script));
            this.setSectionIcon(node, expanded);
        } else if (node.getUserObject() instanceof ReportColumn) {
            elt = (ReportColumn)node.getUserObject();
            this.setText(ExplorerTreeCellRenderer.getName(elt, this.script));
            this.setIcon(this.columnIcon);
        } else {
            elt = (ReportCell)node.getUserObject();
            this.setText(ExplorerTreeCellRenderer.getName(elt, this.script));
            this.setIcon(this.getIcon((ReportCell)elt));
        }
        if (selected) {
            JTextField label = new JTextField("TEMP");
            this.setForeground(label.getSelectedTextColor());
            this.setBackground(label.getSelectionColor());
        } else {
            boolean visibleElt = ReportExplorer.isVisible(node);
            if (visibleElt) {
                this.setForeground(tree.getForeground());
                this.setBackground(tree.getBackground());
            } else {
                this.setForeground(Color.lightGray);
                this.setBackground(tree.getBackground());
            }
        }
        return this;
    }

    private static String getName(ReportElement elt) {
        if (!elt.getCustomID().equals("")) {
            return elt.getCustomID();
        }
        return elt.getID();
    }

    private static String getName(ReportElement elt, Script script) {
        if (elt.getScriptObj() != null && elt.getScriptObj().equals(script)) {
            return ExplorerTreeCellRenderer.getName(elt) + "*";
        }
        return ExplorerTreeCellRenderer.getName(elt);
    }

    private Icon getIcon(ReportCell cell) {
        if (cell instanceof ColumnHeader) {
            return this.columnHeaderIcon;
        }
        if (cell.getFormula() != null || cell.getFormulaName() != null) {
            return this.formulaIcon;
        }
        if (cell instanceof ReportChartObject) {
            return this.reportChartObjectIcon;
        }
        if (cell instanceof ReportLine) {
            return this.reportLineIcon;
        }
        if (cell instanceof ReportGrid) {
            return this.reportRectangleIcon;
        }
        if (cell instanceof ReportImage) {
            return this.reportImageIcon;
        }
        if (cell instanceof ReportDocument) {
            return this.reportDocumentIcon;
        }
        if (cell instanceof SubReportObject) {
            return this.subReportObjectIcon;
        }
        if (cell instanceof ReportRTFObject) {
            return this.reportRTFObjectIcon;
        }
        return this.labelIcon;
    }

    @Override
    public void paint(Graphics g) {
        int textstart = 0;
        Icon icon = this.getIcon();
        textstart = this.getIcon().getIconWidth() + this.getIconTextGap();
        int textwidth = this.getSize().width - textstart;
        if (icon != null) {
            icon.paintIcon(this, g, 0, 0);
        }
        g.setColor(this.getBackground());
        g.fillRect(textstart, 0, textwidth, this.getSize().height);
        g.setColor(this.getForeground());
        g.drawString(this.getText(), textstart, (this.getSize().height + g.getFontMetrics().getAscent()) / 2);
    }
}

