/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.reportdesigner.report.WriteDataFile;

public class ExportFontMapping {
    private static final Logger LOGGER = Logger.getLogger(ExportFontMapping.class.getName());
    public static final String PDFFONTMAPPINGTABLE = "PDFFONTMAPPINGTABLE";
    public static final String PDFFONTMAPPING = "PDFFONTMAPPING";
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    private Hashtable fontMapping = null;
    private PrintStream out;

    public ExportFontMapping(Hashtable mapping) {
        this.fontMapping = mapping;
    }

    public void exportXML(String file) throws IOException {
        if (file == null || file.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        int fontMappingSize = 0;
        if (this.fontMapping != null) {
            fontMappingSize = this.fontMapping.size();
        }
        Object[] fontMappingKeys = new Object[fontMappingSize];
        String[] fontMappingValues = new String[fontMappingSize];
        if (this.fontMapping != null) {
            Enumeration e = this.fontMapping.keys();
            int index = 0;
            while (e.hasMoreElements()) {
                fontMappingKeys[index] = e.nextElement();
                ++index;
            }
        }
        for (int i = 0; i < fontMappingSize; ++i) {
            fontMappingValues[i] = (String)this.fontMapping.get(fontMappingKeys[i]);
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
        this.out = new PrintStream((OutputStream)outstream, false, ServerMessage.xmlEncoding);
        this.out.println("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>");
        this.out.println("<PDFFONTMAPPINGTABLE>");
        for (int i = 0; i < fontMappingSize; ++i) {
            this.out.print("<PDFFONTMAPPING ");
            this.out.print("Key=\"" + (String)fontMappingKeys[i] + "\" ");
            this.out.print("Value=\"" + fontMappingValues[i] + "\" ");
            this.out.println("></PDFFONTMAPPING>");
        }
        this.out.println("</PDFFONTMAPPINGTABLE>");
        this.out.flush();
        this.out.close();
        try {
            WriteDataFile wdfile = new WriteDataFile();
            if (!file.endsWith(".xml")) {
                file = file + ".xml";
            }
            wdfile.output(null, outstream.toByteArray(), file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write XML file", ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            outstream.close();
        }
    }
}

