/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.NumericFormat;

public class FixedPointDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(FixedPointDialog.class.getName());
    NumericFormat nf;
    JTextField spinDecimals;
    JComboBox choiceCurrencySymbol;
    JComboBox choiceCurrencyPosition;
    JLabel labelRounding;
    JTextField spinRounding;
    JComboBox choiceNegative;
    JComboBox choiceDecimal;
    JComboBox choiceThousands;
    JCheckBox chkLeadingZero;
    JButton btnOk;
    JButton btnCancel;

    public FixedPointDialog(JFrame frame, String title, NumericFormat nf) {
        super(frame, title, true);
        this.init(nf);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(NumericFormat nf) {
        this.nf = nf;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        plMain.setLayout(new BorderLayout());
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new GridLayout(5, 1, 5, 5));
        JPanel panelRight = new JPanel();
        panelRight.setLayout(new GridLayout(5, 1, 5, 5));
        plMain.add("West", panelLeft);
        plMain.add("East", panelRight);
        this.choiceCurrencySymbol = new JComboBox();
        panelRight.add(this.labelComponent(LanguageEncoder.getText("Units symbol:"), this.choiceCurrencySymbol));
        this.choiceCurrencySymbol.addItem(LanguageEncoder.getText("<none>"));
        this.choiceCurrencySymbol.addItem("$");
        this.choiceCurrencySymbol.addItem("\u00a2");
        this.choiceCurrencySymbol.addItem("\u00a3");
        this.choiceCurrencySymbol.addItem("\u00a5");
        this.choiceCurrencySymbol.addItem("%");
        this.choiceCurrencySymbol.addItem("\u20ac");
        this.choiceCurrencySymbol.addItem("\u20b9");
        this.choiceCurrencyPosition = new JComboBox();
        panelRight.add(this.labelComponent(LanguageEncoder.getText("Units symbol position:"), this.choiceCurrencyPosition));
        this.choiceCurrencyPosition.addItem("$-10");
        this.choiceCurrencyPosition.addItem("-$10");
        this.choiceCurrencyPosition.addItem("10$-");
        this.choiceCurrencyPosition.addItem("10-$");
        this.choiceNegative = new JComboBox();
        panelRight.add(this.labelComponent(LanguageEncoder.getText("Negative sign position:"), this.choiceNegative));
        this.choiceNegative.addItem("-10");
        this.choiceNegative.addItem("10-");
        this.choiceNegative.addItem("(10)");
        panelRight.add(new JLabel());
        this.spinDecimals = new JTextField(3);
        panelLeft.add(this.labelComponent(LanguageEncoder.getText("Decimals:"), this.spinDecimals));
        this.spinRounding = new JTextField(3);
        panelLeft.add(this.labelComponent(LanguageEncoder.getText("Rounding:"), this.spinRounding));
        this.choiceDecimal = new JComboBox();
        panelLeft.add(this.labelComponent(LanguageEncoder.getText("Decimal point symbol:"), this.choiceDecimal));
        this.choiceDecimal.addItem(".");
        this.choiceDecimal.addItem(",");
        this.choiceDecimal.addItem(" ");
        this.choiceThousands = new JComboBox();
        panelLeft.add(this.labelComponent(LanguageEncoder.getText("Thousands separator:"), this.choiceThousands));
        this.choiceThousands.addItem(LanguageEncoder.getText("<none>"));
        this.choiceThousands.addItem(",");
        this.choiceThousands.addItem(".");
        this.choiceThousands.addItem(LanguageEncoder.getText("<space>"));
        this.chkLeadingZero = new JCheckBox(LanguageEncoder.getText("Leading zero for fractions"));
        panelLeft.add(this.chkLeadingZero);
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
        this.spinDecimals.setText(nf.decimal + "");
        if (nf.currencySymbol == 'N') {
            this.choiceCurrencySymbol.setSelectedIndex(0);
        } else {
            this.choiceCurrencySymbol.setSelectedItem("" + nf.currencySymbol);
        }
        this.choiceCurrencyPosition.setSelectedIndex(nf.currencyPos);
        this.spinRounding.setText(nf.rounding + "");
        this.choiceNegative.setSelectedIndex(nf.negative);
        this.choiceDecimal.setSelectedItem("" + nf.decimalSep);
        if (nf.thousandSep == 'N') {
            this.choiceThousands.setSelectedIndex(0);
        } else if (nf.thousandSep == ' ') {
            this.choiceThousands.setSelectedIndex(3);
        } else {
            this.choiceThousands.setSelectedItem("" + nf.thousandSep);
        }
        this.chkLeadingZero.setSelected(nf.leadingZero);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                int dec = Integer.parseInt(this.spinDecimals.getText());
                dec = dec > 15 ? 15 : (dec < 0 ? 0 : dec);
                int rod = Integer.parseInt(this.spinRounding.getText());
                rod = rod > 15 ? 15 : (rod < 0 ? 0 : rod);
                this.nf = new NumericFormat();
                this.nf.setFormat(this.getCurrencySymbol(), false, this.choiceCurrencyPosition.getSelectedIndex(), dec, rod, this.choiceNegative.getSelectedIndex(), ((String)this.choiceDecimal.getSelectedItem()).charAt(0), this.getThousandsSeparator(), this.chkLeadingZero.isSelected());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Decimal and rounding fields: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Decimal and rounding fields : Integer only!"));
                return;
            }
        }
        this.dispose();
    }

    NumericFormat getFormat() {
        return this.nf;
    }

    private char getCurrencySymbol() {
        if (this.choiceCurrencySymbol.getSelectedIndex() == 0) {
            return ' ';
        }
        return ((String)this.choiceCurrencySymbol.getSelectedItem()).charAt(0);
    }

    private char getThousandsSeparator() {
        if (this.choiceThousands.getSelectedIndex() == 0) {
            return 'N';
        }
        if (this.choiceThousands.getSelectedIndex() == 3) {
            return ' ';
        }
        return ((String)this.choiceThousands.getSelectedItem()).charAt(0);
    }

    private JPanel labelComponent(String label, Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new JLabel(label));
        panel.add(component);
        return panel;
    }
}

