/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ExportFontMapping;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.ImportFontMapping;

public class FontMappingDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(FontMappingDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    JButton importButton;
    JButton exportButton;
    JButton addButton;
    JButton editButton;
    JButton deleteButton;
    ReportMain reportMain;
    String ttfName;
    int ttcIndex = 0;
    Hashtable<String, String> fontMapping = new Hashtable();
    JComboBox nameList;
    JComboBox styleList;
    JList fontList;
    JLabel label;
    JTextField fileLoc;
    JTextField ttcIndexField;
    JButton browseButton;
    DefaultListModel model;
    JFileChooser fileChooser;
    BrowseDialog browseDialog;
    String currentDir = null;
    private final String[] ext = new String[]{"TTF", "AFM", "TTC", "OTF"};
    private boolean modified = false;
    private static final String PLAIN = "PLAIN";
    private static final String BOLD = "BOLD";
    private static final String ITALIC = "ITALIC";
    private static final String BOLDITALIC = "BOLDITALIC";
    BrowseDirectories browseDir;

    public FontMappingDialog(ReportMain reportMain, Hashtable<String, String> mappings) {
        super(reportMain, LanguageEncoder.getText("Set Font Mapping ..."), true);
        this.reportMain = reportMain;
        this.currentDir = "";
        this.fontMapping = mappings;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        String[] ls;
        String[] fontNameList;
        this.setBackground(Color.lightGray);
        JPanel mappingPanel = new JPanel();
        mappingPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font Mapping ...")));
        mappingPanel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Select Font")));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name")));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Style")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.nameList = new JComboBox();
        for (String element : fontNameList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.nameList.addItem(element);
        }
        this.styleList = new JComboBox();
        this.styleList.addItem(LanguageEncoder.getText(PLAIN));
        this.styleList.addItem(LanguageEncoder.getText(BOLD));
        this.styleList.addItem(LanguageEncoder.getText(ITALIC));
        this.styleList.addItem(LanguageEncoder.getText(BOLDITALIC));
        mainPanel.add(this.nameList);
        mainPanel.add(this.styleList);
        p1.add(labelPanel);
        p1.add(mainPanel);
        JPanel selectFilePanel = new JPanel();
        selectFilePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Font File")));
        selectFilePanel.setLayout(new BorderLayout());
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 13;
        cons.insets = new Insets(0, 0, 0, 5);
        this.label = new JLabel(LanguageEncoder.getText("Map To:"));
        p2.add((Component)this.label, cons);
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.gridwidth = 1;
        cons2.insets = new Insets(0, 0, 0, 5);
        this.fileLoc = new JTextField(20);
        p2.add((Component)this.fileLoc, cons2);
        this.fileLoc.setText("");
        GridBagConstraints cons3 = new GridBagConstraints();
        cons3.gridwidth = 0;
        cons3.insets = new Insets(0, 0, 0, 5);
        this.browseButton = new JButton(LanguageEncoder.getText("Browse"));
        this.browseButton.addActionListener(this);
        p2.add((Component)this.browseButton, cons3);
        JPanel indexPanel = new JPanel(new FlowLayout(0));
        indexPanel.add(new JLabel(LanguageEncoder.getText("True Type Collection Index :")));
        this.ttcIndexField = new JTextField(2);
        indexPanel.add(this.ttcIndexField);
        JPanel p3 = new JPanel(new FlowLayout(2));
        this.addButton = new JButton(LanguageEncoder.getText("Add"));
        this.addButton.addActionListener(this);
        p3.add(this.addButton);
        selectFilePanel.add("North", p2);
        selectFilePanel.add("Center", indexPanel);
        selectFilePanel.add("South", p3);
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.add("North", p1);
        fontPanel.add("Center", selectFilePanel);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Mapped Fonts...")));
        this.model = new DefaultListModel();
        for (String element : ls = this.getMappedFontNames()) {
            this.model.addElement(element);
        }
        this.fontList = new JList(this.model);
        this.fontList.setSelectionMode(0);
        this.fontList.clearSelection();
        this.fontList.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.fontList);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        JPanel p4 = new JPanel(new FlowLayout(1));
        this.editButton = new JButton(LanguageEncoder.getText("Edit"));
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton(LanguageEncoder.getText("Delete"));
        this.deleteButton.addActionListener(this);
        p4.add(this.editButton);
        p4.add(this.deleteButton);
        listPanel.add("Center", scroll);
        listPanel.add("South", p4);
        mappingPanel.add("West", fontPanel);
        mappingPanel.add("Center", listPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.importButton = new JButton(LanguageEncoder.getText("Import"));
        this.importButton.addActionListener(this);
        this.exportButton = new JButton(LanguageEncoder.getText("Export"));
        this.exportButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.importButton);
        buttonPanel.add(this.exportButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mappingPanel);
        contentPane.add("South", buttonPanel);
        this.setButtons();
        this.pack();
    }

    public String[] getMappedFontNames() {
        if (this.fontMapping == null) {
            return new String[0];
        }
        String[] names = new String[this.fontMapping.size()];
        Enumeration<String> keys = this.fontMapping.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            names[i] = keys.nextElement();
            ++i;
        }
        return names;
    }

    public Hashtable<String, String> getFontMapping() {
        return this.fontMapping;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setButtons();
        if (this.fontList.getSelectedIndex() == -1) {
            return;
        }
        String key = (String)this.fontList.getSelectedValue();
        int index = key.lastIndexOf(32);
        String fontname = key;
        String style = PLAIN;
        if (index > -1) {
            fontname = key.substring(0, index);
            style = key.substring(index + 1);
        }
        if (!(style.equals(BOLD) || style.equals(ITALIC) || style.equals(BOLDITALIC))) {
            style = PLAIN;
        }
        if (this.fontMapping != null && this.fontMapping.containsKey(key)) {
            String name = this.fontMapping.get(key);
            this.fileLoc.setText(this.getTrueTypeFontFileName(name));
            this.ttcIndexField.setText(this.getTTCIndex(name));
        }
        this.nameList.setSelectedItem(fontname);
        this.styleList.setSelectedItem(style);
    }

    private void setButtons() {
        this.editButton.setEnabled(this.fontList.getSelectedIndex() > -1);
        this.deleteButton.setEnabled(this.fontList.getSelectedIndex() > -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.browseButton) {
            String filename = this.loadFile();
            if (filename != null && !filename.trim().equals("")) {
                this.fileLoc.setText(filename);
            }
        } else if (e.getSource() == this.importButton) {
            this.setVisible(false);
            this.dispose();
            this.importFontMapping();
        } else if (e.getSource() == this.exportButton) {
            this.exportFontMapping();
        } else if (e.getSource() == this.addButton) {
            this.doAdd();
        } else if (e.getSource() == this.editButton) {
            this.doEdit();
        } else if (e.getSource() == this.deleteButton) {
            this.doDelete();
        }
    }

    private String getTrueTypeFontFileName(String name) {
        if (name.toLowerCase().endsWith(".afm")) {
            return name;
        }
        if (name.toLowerCase().endsWith(".ttf")) {
            return name;
        }
        int index = name.toLowerCase().indexOf(".ttc,");
        if (index > 0) {
            return name.substring(0, index + 4);
        }
        return name;
    }

    private String getTTCIndex(String name) {
        int index = name.toLowerCase().indexOf(".ttc,");
        if (index > 0) {
            return name.substring(index + 5).trim();
        }
        return "";
    }

    private void doAdd() {
        String fontName = (String)this.nameList.getSelectedItem();
        String style = (String)this.styleList.getSelectedItem();
        String fileName = this.fileLoc.getText().trim();
        if (fileName.equals("")) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Please specify the path of the true type font file!");
            return;
        }
        if (fileName.toLowerCase().endsWith(".ttc")) {
            if (this.ttcIndexField.getText().trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Please specify the index of true type collection!");
                return;
            }
            try {
                this.ttcIndex = Integer.parseInt(this.ttcIndexField.getText().trim());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "TTC Index: Invalid number", e);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("TTC Index : Integer Only!"));
                return;
            }
        }
        String key = fontName + " " + style;
        if (this.fontMapping == null) {
            this.fontMapping = new Hashtable();
        }
        if (fileName.toLowerCase().endsWith(".ttc")) {
            fileName = fileName + "," + this.ttcIndex;
        }
        this.fontMapping.put(key, fileName);
        this.refreshFontList();
    }

    private void doEdit() {
        if (this.fontList.getSelectedIndex() == -1) {
            return;
        }
        String key = (String)this.fontList.getSelectedValue();
        int index = key.lastIndexOf(32);
        String fontname = key;
        String style = PLAIN;
        if (index > -1) {
            fontname = key.substring(0, index);
            style = key.substring(index + 1);
        }
        if (!(style.equals(BOLD) || style.equals(ITALIC) || style.equals(BOLDITALIC))) {
            style = PLAIN;
        }
        if (this.fontMapping != null && this.fontMapping.containsKey(key)) {
            String name = this.fontMapping.get(key);
            this.fileLoc.setText(this.getTrueTypeFontFileName(name));
            this.ttcIndexField.setText(this.getTTCIndex(name));
        } else {
            this.fileLoc.setText("Can't find the mapped font file!");
            this.ttcIndexField.setText("");
        }
        this.nameList.setSelectedItem(fontname);
        this.styleList.setSelectedItem(style);
        this.refreshFontList();
    }

    private void doDelete() {
        if (this.fontList.getSelectedIndex() == -1) {
            return;
        }
        String key = (String)this.fontList.getSelectedValue();
        if (this.fontMapping != null && this.fontMapping.containsKey(key)) {
            this.fontMapping.remove(key);
        }
        this.refreshFontList();
    }

    private void refreshFontList() {
        String[] ls;
        this.model = new DefaultListModel();
        for (String element : ls = this.getMappedFontNames()) {
            this.model.addElement(element);
        }
        this.fontList.setModel(this.model);
        this.fontList.clearSelection();
        this.fontList.validate();
        this.fontList.repaint();
    }

    private void importFontMapping() {
        ImportFontMapping importFontMapping = new ImportFontMapping();
        try {
            String currentDir = this.browseDir.getFontMappingXmlDir();
            OpenFileDialog fDialog = new OpenFileDialog(this.reportMain, LanguageEncoder.getText("Import Font Mapping From ..."), currentDir, new String[]{"XML"}, currentDir);
            fDialog.setVisible(true);
            String selectedFile = fDialog.getSelectedFile();
            if (selectedFile != null) {
                if (!selectedFile.toUpperCase().endsWith(".XML")) {
                    selectedFile = selectedFile + ".xml";
                }
            } else {
                return;
            }
            this.browseDir.setFontMappingXmlDir(fDialog.getCurrentDirectory());
            this.fontMapping = importFontMapping.importXML(selectedFile);
            this.modified = true;
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Import font mapping failed", ex);
            String msg = ex.getMessage();
            this.reportMain.errorMessage(msg);
        }
    }

    private void exportFontMapping() {
        ExportFontMapping export = new ExportFontMapping(this.getFontMapping());
        try {
            String currentDir = this.browseDir.getFontMappingXmlDir();
            OpenFileDialog fDialog = new OpenFileDialog(this.reportMain, LanguageEncoder.getText("Export Font Mapping"), currentDir, new String[]{"XML"}, currentDir);
            fDialog.setVisible(true);
            String selectedFile = fDialog.getSelectedFile();
            if (selectedFile != null) {
                if (!selectedFile.toUpperCase().endsWith(".XML")) {
                    selectedFile = selectedFile + ".xml";
                }
                if (!OverWriteDialog.continueSave(this.reportMain, selectedFile)) {
                    return;
                }
            } else {
                return;
            }
            this.browseDir.setFontMappingXmlDir(fDialog.getCurrentDirectory());
            export.exportXML(selectedFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Export font mapping failed", ex);
            String msg = ex.getMessage();
            this.reportMain.errorMessage(msg);
        }
    }

    private String loadFile() {
        this.currentDir = this.browseDir.getFontMappingFontsDir();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setCurrentDirectory(new File(this.currentDir));
            }
            this.fileChooser.showDialog(this.reportMain, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.browseDir.setFontMappingFontsDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.reportMain, this.currentDir, this.ext, true, false);
        }
        this.browseDialog.setVisible(true);
        this.browseDir.setFontMappingFontsDir(this.browseDialog.getCurrentDirectory());
        return this.browseDialog.getSelectedFile();
    }

    public void setBrowseDirectories(BrowseDirectories browseDir) {
        this.browseDir = browseDir;
    }
}

