/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.DateTimeSamplePanel;
import quadbase.reportdesigner.designer.LogicalPanel;
import quadbase.reportdesigner.designer.NumericSamplePanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.StringPanel;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LogicalFormat;

public class FormatDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    JFrame parent;
    IFormat initFormat;
    int type;
    JPanel formatPanel;
    private boolean modified = false;
    private boolean setMenuUndo = true;

    public FormatDialog(ReportMain reportMain, IFormat initFormat, int dataType) {
        super(reportMain, LanguageEncoder.getText("Set Format ..."), true);
        this.parent = reportMain;
        this.initFormat = initFormat;
        this.type = dataType;
        this.init(true);
        this.setPosition();
    }

    public FormatDialog(JFrame parent, IFormat initFormat, int dataType, String title, boolean allowBarcode) {
        super(parent, title, true);
        this.parent = parent;
        this.initFormat = initFormat;
        this.type = dataType;
        this.init(allowBarcode);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init(boolean allowBarcode) {
        this.setBackground(Color.lightGray);
        if (this.type == 7) {
            this.formatPanel = new StringPanel(this.parent, this.initFormat);
        } else if (this.type == 0) {
            this.formatPanel = new LogicalPanel(true);
            ((LogicalPanel)this.formatPanel).setFormat(((LogicalFormat)this.initFormat).getformat());
        } else {
            this.formatPanel = this.type == 9 ? new DateTimeSamplePanel(this.parent, this.initFormat, false, true, true) : (this.type == 8 ? new DateTimeSamplePanel(this.parent, this.initFormat, true, false, true) : (this.type == 10 ? new DateTimeSamplePanel(this.parent, this.initFormat, true, true, true) : new NumericSamplePanel(this.parent, this.initFormat, allowBarcode)));
        }
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.formatPanel);
        contentPane.add("South", p2);
        this.pack();
    }

    public IFormat getFormat() {
        return this.initFormat;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.formatPanel instanceof NumericSamplePanel) {
                this.initFormat = ((NumericSamplePanel)this.formatPanel).getformat();
            } else if (this.formatPanel instanceof DateTimeSamplePanel) {
                this.initFormat = ((DateTimeSamplePanel)this.formatPanel).getFormat();
            } else if (this.formatPanel instanceof LogicalPanel) {
                this.initFormat = new LogicalFormat(((LogicalPanel)this.formatPanel).getFormatInt());
            } else if (this.formatPanel instanceof StringPanel) {
                this.initFormat = ((StringPanel)this.formatPanel).getFormat();
            }
            if (this.setMenuUndo && this.parent instanceof ReportMain) {
                ((ReportMain)this.parent).menuBar.setUndoEnabled(true);
            }
            this.modified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }
}

