/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.designer.NewEditDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class FormulaDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(FormulaDialog.class.getName());
    private JButton editButton;
    private JButton newButton;
    private JButton renameButton;
    private JButton insertButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JButton cancelButton;
    private JList formulaList;
    private Vector<Formula> formulas;
    private ReportMain reportMain;
    private Report report;

    public FormulaDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Formula"), true);
        this.reportMain = reportMain;
        this.report = reportMain.report;
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.formulaList = new JList();
        MouseAdapter addListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int size = FormulaDialog.this.formulas.size();
                    int idx = FormulaDialog.this.formulaList.locationToIndex(e.getPoint());
                    if (idx >= 0 && size > 0) {
                        String title = LanguageEncoder.getText("Edit Formula") + " " + ((Formula)FormulaDialog.this.formulas.elementAt(idx)).getName();
                        int reportIdx = ((FormulaDialog)FormulaDialog.this).report.formulas.indexOf(FormulaDialog.this.formulas.get(idx));
                        new NewEditDialog(FormulaDialog.this.reportMain, reportIdx, true, title).setVisible(true);
                        FormulaDialog.this.refreshList();
                        if (size < FormulaDialog.this.formulas.size()) {
                            FormulaDialog.this.formulaList.setSelectedIndex(size);
                        } else {
                            FormulaDialog.this.formulaList.setSelectedIndex(idx);
                        }
                    }
                }
            }
        };
        this.formulaList.addMouseListener(addListener);
        this.formulaList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((Formula)value).getName());
                return component;
            }
        });
        this.refreshList();
        JScrollPane scrollPane = new JScrollPane(this.formulaList);
        contentPane.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(7, 1, 5, 5));
        this.editButton = new JButton(LanguageEncoder.getText("EDIT"));
        buttonPanel.add(this.editButton);
        this.newButton = new JButton(LanguageEncoder.getText("NEW"));
        buttonPanel.add(this.newButton);
        this.renameButton = new JButton(LanguageEncoder.getText("RENAME"));
        buttonPanel.add(this.renameButton);
        this.insertButton = new JButton(LanguageEncoder.getText("INSERT"));
        buttonPanel.add(this.insertButton);
        this.deleteButton = new JButton(LanguageEncoder.getText("DELETE"));
        buttonPanel.add(this.deleteButton);
        this.deleteAllButton = new JButton(LanguageEncoder.getText("DELETE UNUSED"));
        buttonPanel.add(this.deleteAllButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("CLOSE"));
        buttonPanel.add(this.cancelButton);
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        this.insertButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteAllButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add((Component)buttonPanel, "East");
    }

    private void refreshList() {
        this.formulas = new Vector<Formula>(this.report.formulas);
        Collections.sort(this.formulas);
        this.formulaList.setListData(this.formulas);
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.45);
        dim.width = (int)((double)screenSize.width * 0.35);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.editButton) {
            int size = this.formulas.size();
            int idx = this.formulaList.getSelectedIndex();
            if (idx >= 0 && this.formulas.size() > 0) {
                String title = LanguageEncoder.getText("Edit Formula") + " " + this.formulas.elementAt(idx).getName();
                int reportIdx = this.report.formulas.indexOf(this.formulas.get(idx));
                new NewEditDialog(this.reportMain, reportIdx, true, title).setVisible(true);
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a formula first"));
            }
            this.refreshList();
            if (size < this.formulas.size()) {
                this.formulaList.setSelectedIndex(size);
            } else {
                this.formulaList.setSelectedIndex(idx);
            }
        } else if (src == this.newButton) {
            String inputValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1);
            if (inputValue == null) {
                return;
            }
            while (this.report.formulaExists(inputValue) || !QbUtil.isValidName(inputValue)) {
                if (this.report.formulaExists(inputValue)) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("is an invalid formula name"));
                }
                if ((inputValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1)) != null) continue;
                return;
            }
            Formula f = new Formula(inputValue);
            new NewEditDialog(this.reportMain, f, null, null, LanguageEncoder.getText("Edit Formula") + " " + inputValue).setVisible(true);
            this.refreshList();
            this.formulaList.setSelectedValue(inputValue, true);
        } else if (src == this.renameButton) {
            int idx = this.formulaList.getSelectedIndex();
            if (idx >= 0 && this.formulas.size() > 0) {
                Object input = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1, null, null, this.formulas.elementAt(idx).getName());
                if (input == null) {
                    return;
                }
                String inputValue = input.toString();
                while (this.report.formulaExists(inputValue) || !QbUtil.isValidName(inputValue)) {
                    if (this.report.formulaExists(inputValue)) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                    } else {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("is an invalid formula name"));
                    }
                    if ((inputValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1)) != null) continue;
                    return;
                }
                this.formulas.elementAt(idx).setName(inputValue);
                this.refreshList();
                this.formulaList.setSelectedValue(inputValue, true);
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a formula first"));
            }
        } else if (src == this.deleteButton) {
            int idx = this.formulaList.getSelectedIndex();
            if (idx >= 0 && this.formulas.size() > 0) {
                Formula form = this.formulas.elementAt(idx);
                boolean[] formRef = this.report.formulaReferenced(form);
                if (!formRef[0]) {
                    LoadReport lr = new LoadReport(true);
                    lr.setRelativeDomainPath(this.reportMain.relativeDomainPath);
                    try {
                        Report mainReport = lr.loadReportFromFile(this.reportMain.getReportFile());
                        formRef = mainReport.formulaReferenced(form);
                        if (formRef[0]) {
                            if (formRef[1]) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot delete this formula because it is referenced by an invisible report column"));
                            } else {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot delete this formula because it is referenced by formulas in Main Report"));
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Checking for formula refferences failed", ex);
                    }
                    this.report.formulas.remove(this.formulas.get(idx));
                    for (int i = 0; i < this.report.getFormulaParameters().size(); ++i) {
                        Parameter param = this.report.getFormulaParameters().elementAt(i);
                        param.removeFormula((String)this.formulaList.getSelectedValue());
                        if (param.getFormulaNames() == null || param.getFormulaNames().size() != 0) continue;
                        this.report.getFormulaParameters().remove(param);
                    }
                    this.refreshList();
                } else if (formRef[1]) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot delete this formula because it is referenced by an invisible report column"));
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot delete this formula because it is referenced by at least one report elements"));
                }
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a formula first"));
            }
        } else if (src == this.deleteAllButton) {
            if (this.report.formulas.size() > 0) {
                for (int i = this.report.formulas.size() - 1; i >= 0; --i) {
                    Formula f = this.report.formulas.elementAt(i);
                    boolean[] formRef = this.report.formulaReferenced(f);
                    if (formRef[0]) continue;
                    this.report.formulas.remove(i);
                    for (int j = 0; j < this.report.getFormulaParameters().size(); ++j) {
                        Parameter param = this.report.getFormulaParameters().elementAt(j);
                        param.removeFormula(f.getName());
                        if (param.getFormulaNames() == null || param.getFormulaNames().size() != 0) continue;
                        this.report.getFormulaParameters().remove(param);
                    }
                }
                this.refreshList();
            }
        } else if (src == this.insertButton) {
            this.reportMain.insertFormula = true;
            int idx = this.formulaList.getSelectedIndex();
            if (idx >= 0 && this.formulas.size() > 0) {
                this.reportMain.setSelectedFormula(this.formulas.elementAt(idx));
                this.setVisible(false);
                this.dispose();
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a formula first"));
            }
        } else if (src == this.cancelButton) {
            this.reportMain.insertFormula = false;
            this.setVisible(false);
            this.dispose();
        }
    }
}

