/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.designer.ReportMain;

public class GoToDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(GoToDialog.class.getName());
    JTextField pageField;
    JTextField sectionField;
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    ReportCanvas canvas;

    public GoToDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Go To ..."), true);
        this.reportMain = reportMain;
        this.canvas = reportMain.previewPanel.viewer.getReportCanvas();
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Page")));
        this.pageField = new JTextField(this.canvas.getPage() + "", 3);
        p1.add(this.pageField);
        this.sectionField = new JTextField(this.canvas.getSection() + "", 3);
        if (this.canvas.getTotalSections() > 1) {
            p1.add(new JLabel(LanguageEncoder.getText("Section")));
            p1.add(this.sectionField);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int page = this.canvas.getPage();
            int section = this.canvas.getSection();
            String msg = null;
            try {
                page = Integer.parseInt(this.pageField.getText());
                if (page <= 0) {
                    page = 1;
                }
                if (page > this.canvas.getTotalPages()) {
                    page = this.canvas.getTotalPages();
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Page field: Invalid number", ex);
                msg = LanguageEncoder.getText("Page Field : Invalid Input!");
            }
            try {
                section = Integer.parseInt(this.sectionField.getText());
                if (section <= 0) {
                    section = 1;
                }
                if (section > this.canvas.getTotalSections()) {
                    section = this.canvas.getTotalSections();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Section field: Invalid number", ex);
                msg = LanguageEncoder.getText("Section Field : Invalid Input!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            this.canvas.setPage(page);
            this.canvas.setSection(section);
            this.canvas.repaint();
        }
        this.setVisible(false);
        this.dispose();
    }
}

