/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.util.Vector;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.designer.ReportElementPanel;

public class GridLine {
    Vector panelList;
    boolean isDesignMode = true;

    public GridLine(Vector panelList) {
        this.panelList = panelList;
    }

    public GridLine(Vector panelList, boolean designMode) {
        this.panelList = panelList;
        this.isDesignMode = designMode;
    }

    private int[] findStartEndPanel(int startPanel, int y1, int y2) {
        return this.findStartEndPanel(startPanel, y1, y2, false);
    }

    public int[] findStartEndPanel(int startPanel, int y1, int y2, boolean canBeNegative) {
        return this.findStartEndPanel(startPanel, y1, y2, canBeNegative, false);
    }

    private int[] findStartEndPanel(int startPanel, int y1, int y2, boolean canBeNegative, boolean adjustForDivider) {
        ReportElementPanel p;
        if (!this.isDesignMode) {
            return new int[]{startPanel, y1, startPanel, y2};
        }
        if (y1 > y2 && canBeNegative) {
            int topPanel;
            for (topPanel = startPanel; topPanel > 0; --topPanel) {
                ReportElementPanel p2 = (ReportElementPanel)this.panelList.elementAt(topPanel - 1);
                if (y2 > 0) break;
                y2 += p2.getHeight();
            }
            if (topPanel < 0) {
                topPanel = 0;
                y2 = 0;
            }
            return new int[]{topPanel, y2, startPanel, y1};
        }
        int i = startPanel - 1;
        while (i >= 0 && y1 < 0) {
            p = (ReportElementPanel)this.panelList.elementAt(i);
            y1 = p.getHeight() + y1;
            y2 = p.getHeight() + y2;
            startPanel = i--;
        }
        if (startPanel < 0) {
            startPanel = this.panelList.size() - 2;
        }
        if (startPanel == 0 && y1 < 0) {
            y1 = 0;
        }
        while (startPanel < this.panelList.size() - 1 && y1 > (p = (ReportElementPanel)this.panelList.elementAt(startPanel)).getHeight()) {
            y1 -= p.getHeight();
            y2 -= p.getHeight();
            ++startPanel;
        }
        if (startPanel >= this.panelList.size() - 1) {
            return null;
        }
        for (i = startPanel; i < this.panelList.size() - 1; ++i) {
            p = (ReportElementPanel)this.panelList.elementAt(i);
            int curHeight = p.getHeight();
            if (adjustForDivider) {
                curHeight += p.getDividerSize();
            }
            if (y2 <= curHeight) break;
            y2 -= curHeight;
        }
        if (i >= this.panelList.size() - 1) {
            i = this.panelList.size() - 2;
            y2 = ((ReportElementPanel)this.panelList.elementAt(i)).getHeight();
        }
        return new int[]{startPanel, y1, i, y2};
    }

    int getOffset(int startPanel, int y1, int y2) {
        int[] res = this.findStartEndPanel(startPanel, y1, y2);
        if (res == null) {
            return 0;
        }
        return this.getOffset(res[0], res[2]);
    }

    private int getOffset(int startPanel, int endPanel) {
        double tmp = 0.0;
        for (int i = startPanel; i < endPanel; ++i) {
            if (!((ReportElementPanel)this.panelList.elementAt(i + 1)).isElementVisible()) continue;
            tmp += 4.5;
        }
        return (int)Math.ceil(tmp);
    }

    public ReportCell set(int startPanel, int x1, int y1, int x2, int y2, boolean isLine, boolean isVert, ReportElement tplCell) {
        return this.set(startPanel, x1, y1, x2, y2, isLine, isVert, tplCell, false);
    }

    ReportCell set(int startPanel, int x1, int y1, int x2, int y2, boolean isLine, boolean isVert, ReportElement tplCell, boolean canBeNegative) {
        return this.set(startPanel, x1, y1, x2, y2, isLine, isVert, tplCell, canBeNegative, false);
    }

    ReportCell set(int startPanel, int x1, int y1, int x2, int y2, boolean isLine, boolean isVert, ReportElement tplCell, boolean canBeNegative, boolean adjustForDivider) {
        if (isLine && isVert) {
            x2 = x1;
        } else if (isLine && !isVert) {
            y2 = y1;
        }
        int[] res = this.findStartEndPanel(startPanel, y1, y2, canBeNegative, adjustForDivider);
        if (res == null) {
            return null;
        }
        return this.set(res[0], x1 < x2 ? x1 : x2, res[1], res[2], x1 < x2 ? x2 : x1, res[3], tplCell);
    }

    private ReportCell set(int startPanel, int x1, int y1, int endPanel, int x2, int y2, ReportElement tplCell) {
        int i;
        ((ReportElementPanel)this.panelList.elementAt((int)startPanel)).selectedObject = null;
        ((ReportElementPanel)this.panelList.elementAt((int)endPanel)).selectedObject = null;
        if (y1 == y2 && startPanel == endPanel) {
            ReportLine cell = new ReportLine(false);
            if (tplCell != null) {
                cell.applyTemplate((ReportLine)tplCell, true);
            }
            int x = x1 < x2 ? x1 : x2;
            return this.addCell(cell, x, y1, Math.abs(x2 - x1), QbUtil.toPixel(cell.getHeight()), (ReportElementPanel)this.panelList.elementAt(startPanel));
        }
        ReportCell[] cells = new ReportCell[endPanel - startPanel + 1];
        int ct = 0;
        for (i = startPanel; i <= endPanel; ++i) {
            if (x1 == x2) {
                cells[ct++] = this.setVerticalLine((ReportElementPanel)this.panelList.elementAt(i), i == startPanel, i == endPanel, x1, y1, y2, tplCell);
                continue;
            }
            cells[ct++] = this.setGrid((ReportElementPanel)this.panelList.elementAt(i), i == startPanel, i == endPanel, x1, y1, x2, y2, tplCell);
        }
        for (i = 0; i < cells.length; ++i) {
            if (x1 == x2) {
                if (i > 0) {
                    ((ReportLine)cells[i]).setPrevious((ReportLine)cells[i - 1]);
                }
                if (i + 1 >= cells.length) continue;
                ((ReportLine)cells[i]).setNext((ReportLine)cells[i + 1]);
                continue;
            }
            if (i > 0) {
                ((ReportGrid)cells[i]).setPrevious((ReportGrid)cells[i - 1]);
            }
            if (i + 1 >= cells.length) continue;
            ((ReportGrid)cells[i]).setNext((ReportGrid)cells[i + 1]);
        }
        return cells[0];
    }

    private ReportCell setVerticalLine(ReportElementPanel panel, boolean startPanel, boolean endPanel, int x1, int y1, int y2, ReportElement tplCell) {
        int stY = -1;
        int height = -1;
        if (startPanel) {
            stY = y1;
        }
        if (endPanel) {
            height = y2 - stY;
        }
        ReportLine cell = new ReportLine(true);
        if (tplCell != null) {
            cell.applyTemplate((ReportLine)tplCell, true);
        }
        return this.addCell(cell, x1, stY, QbUtil.toPixel(cell.getWidth()), height, panel);
    }

    private ReportCell setGrid(ReportElementPanel panel, boolean startPanel, boolean endPanel, int x1, int y1, int x2, int y2, ReportElement tplCell) {
        ReportGrid cell = new ReportGrid();
        if (tplCell != null) {
            cell.applyTemplate((ReportGrid)tplCell, true);
        }
        if (startPanel && endPanel) {
            return this.addCell(cell, x1, y1, x2 - x1, y2 - y1, panel);
        }
        if (startPanel) {
            return this.addCell(cell, x1, y1, x2 - x1, -1, panel);
        }
        if (endPanel) {
            return this.addCell(cell, x1, -1, x2 - x1, y2, panel);
        }
        return this.addCell(cell, x1, -1, x2 - x1, -1, panel);
    }

    private ReportCell addCell(ReportCell cell, int x, int y, int w, int h, ReportElementPanel panel) {
        cell.setX(QbUtil.toInch(x));
        cell.setY(QbUtil.toInch(y));
        if (y == -1) {
            cell.setYY(QbUtil.toInch(0.0));
        }
        cell.setWidth(QbUtil.toInch(w));
        cell.setHeight(QbUtil.toInch(h));
        if (h >= 0) {
            cell.setHeight(QbUtil.toInch(h));
        } else {
            cell.setHeight(-1.0);
        }
        if (!this.isDesignMode) {
            return cell;
        }
        if (panel.getElement() instanceof ReportSection) {
            ((ReportSection)panel.getElement()).addData(cell);
        } else {
            panel.getOriginalReportTable().addImage((ReportImage)cell);
        }
        return cell;
    }

    private void removeGrid(ReportGrid cell) {
        for (cell = cell.getHeadNode(); cell != null; cell = cell.next()) {
            for (int i = 0; i < this.panelList.size() - 1; ++i) {
                ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
                if (panel.getElement() instanceof ReportSection) {
                    ((ReportSection)panel.getElement()).removeData(cell);
                    continue;
                }
                panel.getOriginalReportTable().removeImage(cell);
            }
        }
    }

    private void removeLine(ReportLine cell) {
        for (cell = cell.getHeadNode(); cell != null; cell = cell.next()) {
            for (int i = 0; i < this.panelList.size() - 1; ++i) {
                ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
                if (panel.getElement() instanceof ReportSection) {
                    ((ReportSection)panel.getElement()).removeData(cell);
                    continue;
                }
                panel.getOriginalReportTable().removeImage(cell);
            }
        }
    }

    public void remove(ReportElement cell) {
        if (cell instanceof ReportGrid) {
            this.removeGrid((ReportGrid)cell);
        } else if (cell instanceof ReportLine) {
            this.removeLine((ReportLine)cell);
        }
    }
}

