/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ParameterShareDialog;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class GroupDetailDialog
extends JDialog
implements ActionListener {
    Report mainReport;
    Report report;
    int reportIndex;
    String reportName;
    String paramName;
    boolean queryParam;
    String title;
    JButton closeButton;
    int action;
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int VIEW = 2;

    public GroupDetailDialog(ParameterShareDialog dialog, String reportName, String paramName, boolean queryParam, int action) {
        super((Dialog)dialog, true);
        this.mainReport = dialog.mainReport;
        this.report = dialog.report;
        this.reportIndex = dialog.reportIndex;
        this.reportName = reportName;
        this.paramName = paramName;
        this.queryParam = queryParam;
        this.action = action;
        this.title = "MAIN_REPORT";
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.action == 2) {
            this.setTitle(LanguageEncoder.getText("Group details"));
        } else {
            this.setTitle(LanguageEncoder.getText("Confirmation"));
        }
        this.setDefaultCloseOperation(2);
        Vector<String> reports = new Vector<String>();
        Vector<String> params = new Vector<String>();
        this.getParamsInGroup(reports, params);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(reports.size(), 1, 5, 5));
        String text = "";
        if (this.action == 0) {
            text = LanguageEncoder.getText("The parameter is added to the group");
        } else if (this.action == 1) {
            text = LanguageEncoder.getText("The parameter is removed from the group");
        } else if (this.action == 2) {
            text = LanguageEncoder.getText("Parameters in this group");
        }
        mainPanel.setBorder(new TitledBorder(text));
        for (int i = 0; i < reports.size(); ++i) {
            String s = reports.elementAt(i) + " : " + params.elementAt(i);
            mainPanel.add(new Label(s));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.closeButton = new JButton(LanguageEncoder.getText("CLOSE"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        Dimension screensize = this.getToolkit().getScreenSize();
        this.pack();
        int width = (int)((double)this.getSize().width * 1.5);
        int height = (int)((double)this.getSize().height * 1.2);
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    public int getParamsInGroupCount() {
        Vector<String> reports = new Vector<String>();
        Vector<String> params = new Vector<String>();
        this.getParamsInGroup(reports, params);
        return params.size();
    }

    private void getParamsInGroup(Vector<String> reports, Vector<String> params) {
        block8: {
            block7: {
                if (!this.queryParam) break block7;
                Vector<Parameter> vec = this.reportIndex == 0 ? this.report.getQueryParameters() : this.mainReport.getQueryParameters();
                for (int i = 0; i < vec.size(); ++i) {
                    Parameter param = vec.elementAt(i);
                    if ((!this.reportName.equals(this.title) || !this.paramName.equals(param.getName())) && (!this.reportName.equals(param.getSharedReportName()) || !this.paramName.equals(param.getSharedParamName()))) continue;
                    reports.addElement("Main_Report");
                    params.addElement(param.getName());
                }
                Report[] subReports = this.mainReport.getSubReportArray();
                Vector<SubReportObject> sub = this.mainReport.subReports;
                if (subReports == null) break block8;
                for (int i = 0; i < subReports.length; ++i) {
                    vec = i == this.reportIndex - 1 ? this.report.getQueryParameters() : subReports[i].getQueryParameters();
                    for (int j = 0; j < vec.size(); ++j) {
                        Parameter param = vec.elementAt(j);
                        String subID = sub.elementAt(i).getParamShareReportID();
                        if ((!this.reportName.equals(subID) || !this.paramName.equals(param.getName())) && (!param.isShared() || !this.reportName.equals(param.getSharedReportName()) || !this.paramName.equals(param.getSharedParamName()))) continue;
                        reports.addElement("Sub_Report_" + (i + 1));
                        params.addElement(param.getName());
                    }
                }
                break block8;
            }
            Vector<Parameter> vec = this.reportIndex == 0 ? this.report.getFormulaParameters() : this.mainReport.getFormulaParameters();
            for (int i = 0; i < vec.size(); ++i) {
                Parameter param = vec.elementAt(i);
                if ((!this.reportName.equals(this.title) || !this.paramName.equals(param.getName())) && (!this.reportName.equals(param.getSharedReportName()) || !this.paramName.equals(param.getSharedParamName()))) continue;
                reports.addElement("Main_Report");
                params.addElement(param.getName());
            }
            Report[] subReports = this.mainReport.getSubReportArray();
            Vector<SubReportObject> sub = this.mainReport.subReports;
            if (subReports != null) {
                for (int i = 0; i < subReports.length; ++i) {
                    vec = i == this.reportIndex - 1 ? this.report.getFormulaParameters() : subReports[i].getFormulaParameters();
                    for (int j = 0; j < vec.size(); ++j) {
                        Parameter param = vec.elementAt(j);
                        String subID = sub.elementAt(i).getParamShareReportID();
                        if ((!this.reportName.equals(subID) || !this.paramName.equals(param.getName())) && (!this.reportName.equals(param.getSharedReportName()) || !this.paramName.equals(param.getSharedParamName()))) continue;
                        reports.addElement("Sub_Report_" + (i + 1));
                        params.addElement(param.getName());
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.closeButton)) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

