/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;

public class HTMLTableBorderDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(HTMLTableBorderDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JCheckBox setHTMLTableBorder;
    JTextField borderThickness;
    JButton borderColor;
    ReportTableElement elt;
    ColorDialog colorDialog;

    public HTMLTableBorderDialog(ReportMain reportMain, ReportTableElement elt) {
        super(reportMain, LanguageEncoder.getText("Set HTML Table Border ..."), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Border")));
        upperPanel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        this.setHTMLTableBorder = new JCheckBox(LanguageEncoder.getText("Set HTML Table Border"), this.elt.hasHTMLTableBorder());
        p1.add(this.setHTMLTableBorder);
        this.setHTMLTableBorder.addItemListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        p2.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.borderThickness = new JTextField(3);
        p2.add(this.borderThickness);
        this.borderThickness.setEnabled(this.elt.hasHTMLTableBorder());
        this.borderThickness.setText(this.elt.getHTMLTableBorderThickness() + "");
        p2.add(new JLabel("       "));
        this.borderColor = new JButton(LanguageEncoder.getText("Border Color"));
        p2.add(this.borderColor);
        this.borderColor.setEnabled(this.elt.hasHTMLTableBorder());
        this.borderColor.addActionListener(this);
        upperPanel.add("Center", p1);
        upperPanel.add("South", p2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", upperPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.setHTMLTableBorder) {
            if (this.borderThickness != null) {
                this.borderThickness.setEnabled(this.setHTMLTableBorder.isSelected());
            }
            if (this.borderColor != null) {
                this.borderColor.setEnabled(this.setHTMLTableBorder.isSelected());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.elt.setHTMLTableBorder(this.setHTMLTableBorder.isSelected());
            if (this.setHTMLTableBorder.isSelected()) {
                try {
                    int thickness = Integer.parseInt(this.borderThickness.getText());
                    this.elt.setHTMLTableBorderThickness(thickness);
                    if (this.colorDialog != null) {
                        this.elt.setHTMLTableBorderColor(this.colorDialog.getColor());
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Border thickness: Invalid number", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Integer only"));
                }
            }
            this.setVisible(false);
            this.dispose();
            this.reportMain.setModified(true);
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.borderColor) {
            if (this.colorDialog == null) {
                this.colorDialog = new ColorDialog(this.reportMain, true, 3, this.elt.getHTMLTableBorderColor());
            }
            this.colorDialog.setVisible(true);
        }
    }
}

