/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;

public class HeightDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(HeightDialog.class.getName());
    ReportMain reportMain;
    ReportElement elt;
    double theHeight = 0.0;
    boolean modified = false;
    JButton okButton;
    JButton cancelButton;
    JTextField tf;
    double maxHeight = 0.0;
    double modifier = 1.0;

    public HeightDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Set Height ..."), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        String units = this.reportMain.isCm ? "cms" : "inches";
        this.modifier = this.reportMain.isCm ? 2.54 : 1.0;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("")));
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new JLabel(LanguageEncoder.getText("Height (in " + units + "):")));
        String s = "";
        if (this.elt != null) {
            s = Double.valueOf(this.elt.getHeight() * this.modifier).toString();
        }
        this.maxHeight = (this.reportMain.report.getPageHeight() - this.reportMain.report.getTopMargin() - this.reportMain.report.getBottomMargin()) * this.modifier;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(Locale.US);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(5);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Double.valueOf(0.0));
        numberFormatter.setAllowsInvalid(false);
        this.tf = new JFormattedTextField(numberFormatter);
        panel.add(this.tf);
        this.tf.setColumns(5);
        this.tf.setText(s);
        this.tf.setToolTipText(LanguageEncoder.getText("Please a number greater than 0 and less than") + " " + this.maxHeight + " " + units);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add("Center", panel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                this.theHeight = Double.parseDouble(this.tf.getText());
                if (this.theHeight > 0.0 && this.theHeight < this.maxHeight) {
                    this.theHeight /= this.modifier;
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Number greater than 0 and less than") + " " + this.maxHeight + " " + LanguageEncoder.getText("please!"));
                    return;
                }
                this.modified = true;
                this.reportMain.setModified();
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.FINEST, "Invalid number", nfe);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Number only please!"));
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public double getTheHeight() {
        return this.theHeight;
    }
}

