/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class HyperLinkDialog
extends JDialog
implements ActionListener {
    JTextField linkField;
    JTextField hintField;
    JTextField targetField;
    JButton browseButton;
    JButton okButton;
    JButton cancelButton;
    JFileChooser fileChooser;
    BrowseDialog browseDialog;
    String link = "";
    String hint = "";
    String target = "";
    ReportMain reportMain;
    boolean isModified = false;

    public HyperLinkDialog(ReportMain reportMain, String link, String hint, String target) {
        super(reportMain, LanguageEncoder.getText("Setup HyperLink..."), true);
        this.reportMain = reportMain;
        this.link = link;
        this.hint = hint;
        this.target = target;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p1.setLayout(gbl);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        JLabel comp = new JLabel(LanguageEncoder.getText("Link :"));
        gbl.setConstraints(comp, gbc);
        p1.add(comp);
        gbc.weightx = 20.0;
        this.linkField = new JTextField(this.link, 30);
        Dimension d = this.linkField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.linkField.setMinimumSize(d);
        gbl.setConstraints(this.linkField, gbc);
        p1.add(this.linkField);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        gbl.setConstraints(this.browseButton, gbc);
        this.browseButton.addActionListener(this);
        p1.add(this.browseButton);
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        comp = new JLabel(LanguageEncoder.getText("Hint :"));
        gbl.setConstraints(comp, gbc);
        p1.add(comp);
        gbc.weightx = 20.0;
        this.hintField = new JTextField(this.hint, 30);
        d = this.hintField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.hintField.setMinimumSize(d);
        gbl.setConstraints(this.hintField, gbc);
        p1.add(this.hintField);
        gbc.weightx = 1.0;
        comp = new JLabel("");
        gbl.setConstraints(comp, gbc);
        p1.add(comp);
        gbc.gridy = 2;
        comp = new JLabel(LanguageEncoder.getText("Target :"));
        gbl.setConstraints(comp, gbc);
        p1.add(comp);
        gbc.weightx = 20.0;
        this.targetField = new JTextField(this.target, 30);
        d = this.targetField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.targetField.setMinimumSize(d);
        gbl.setConstraints(this.targetField, gbc);
        p1.add(this.targetField);
        gbc.weightx = 1.0;
        comp = new JLabel("");
        gbl.setConstraints(comp, gbc);
        p1.add(comp);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
    }

    private String loadFile() {
        String currentDir = this.reportMain.getBrowseDirectories().getFormatHyperlinkDir();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                this.fileChooser.setCurrentDirectory(new File(currentDir));
            }
            this.fileChooser.showDialog(this.reportMain, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.reportMain.getBrowseDirectories().setFormatHyperlinkDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.reportMain, currentDir, new String[]{"PAK", "RPT"});
        }
        this.browseDialog.setVisible(true);
        if (this.browseDialog.getSelectedFile() != null) {
            this.reportMain.getBrowseDirectories().setFormatHyperlinkDir(this.browseDialog.getCurrentDirectory());
        }
        return this.browseDialog.getSelectedFile();
    }

    boolean isModified() {
        return this.isModified;
    }

    String getLink() {
        return this.link;
    }

    String getHint() {
        return this.hint;
    }

    String getTarget() {
        return this.target;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            String linkFile = this.loadFile();
            if (linkFile != null) {
                this.linkField.setText(linkFile);
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.linkField || e.getSource() == this.hintField || e.getSource() == this.targetField) {
            this.link = this.linkField.getText();
            this.hint = this.hintField.getText();
            this.target = this.targetField.getText();
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

