/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.designer.ReportMain;

public class ImageOptionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JButton ok;
    private JButton cancel;
    private JCheckBox transparentGIF;
    private JCheckBox generateMapFile;
    private JCheckBox animatedBut;
    private JSlider jpegSlider;
    private JSlider pngSlider;
    private JRadioButton isGIF;
    private JRadioButton isPNG;
    private JRadioButton isJPEG;
    private JRadioButton isFLASH;
    private JRadioButton exportPNG;
    private JRadioButton exportSVG;
    SpinBox noOfFrame;
    SpinBox frameRate;
    boolean isGIFTransparent;
    boolean isExportMapFile = false;
    int flashFrameCount = 12;
    float flashFrameRate = 20.0f;
    int jpegQuality = 99;
    int pngCompression = 0;
    int imageType = 7;
    int pdfImageType = 10;
    int[] pngMap = new int[]{3, 0, 2};

    public ImageOptionDialog(ReportMain reportMain, ReportImage chart) {
        super(reportMain, LanguageEncoder.getText("Chart Export Format"), true);
        if (chart != null) {
            this.jpegQuality = chart.getJPEGQuality();
            this.pngCompression = chart.getPNGCompression();
            this.isGIFTransparent = chart.isGIFTransparent();
            this.flashFrameCount = chart.getFlashFrameCount();
            this.flashFrameRate = chart.getFlashFrameRate();
            this.imageType = chart.getImageType();
            this.pdfImageType = chart.getPdfImageType();
            if (chart instanceof ReportChartObject) {
                this.isExportMapFile = ((ReportChartObject)chart).isExportMapFile();
            }
        }
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JPanel imgPanel = new JPanel();
        imgPanel.setBorder(new TitledBorder(LanguageEncoder.getText("HTML/DHTML Image Type")));
        imgPanel.setLayout(new BorderLayout());
        this.isJPEG = new JRadioButton("JPEG", this.imageType == 7);
        this.isGIF = new JRadioButton("GIF", this.imageType == 1);
        this.isPNG = new JRadioButton("PNG", this.imageType == 10);
        this.isFLASH = new JRadioButton("FLASH", this.imageType == 15);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.isJPEG);
        bg.add(this.isGIF);
        bg.add(this.isPNG);
        bg.add(this.isFLASH);
        imgPanel.setLayout(new GridLayout(1, 3, 5, 5));
        imgPanel.add(this.isJPEG);
        imgPanel.add(this.isGIF);
        imgPanel.add(this.isPNG);
        imgPanel.add(this.isFLASH);
        JPanel pdfImagePanel = new JPanel();
        pdfImagePanel.setBorder(new TitledBorder(LanguageEncoder.getText("PDF Image Type")));
        pdfImagePanel.setLayout(new BorderLayout());
        this.exportPNG = new JRadioButton("PNG", this.pdfImageType == 10);
        this.exportSVG = new JRadioButton("SVG", this.pdfImageType == 14);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.exportPNG);
        bg2.add(this.exportSVG);
        pdfImagePanel.setLayout(new GridLayout(1, 2, 5, 5));
        pdfImagePanel.add(this.exportPNG);
        pdfImagePanel.add(this.exportSVG);
        JPanel mapPanel = new JPanel();
        mapPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Image Map")));
        mapPanel.setLayout(new BorderLayout());
        this.generateMapFile = new JCheckBox(LanguageEncoder.getText("Generate Map File"), this.isExportMapFile);
        mapPanel.add("Center", this.generateMapFile);
        JPanel jpegPanel = new JPanel();
        jpegPanel.setBorder(new TitledBorder(LanguageEncoder.getText("JPEG Quality")));
        jpegPanel.setLayout(new BorderLayout());
        this.jpegSlider = new JSlider(0, 0, 100, this.jpegQuality);
        this.jpegSlider.setMajorTickSpacing(25);
        this.jpegSlider.setMinorTickSpacing(5);
        this.jpegSlider.setPaintTicks(true);
        this.jpegSlider.setPaintLabels(true);
        this.jpegSlider.setValue(this.jpegQuality);
        jpegPanel.add("Center", this.jpegSlider);
        JPanel gifPanel = new JPanel();
        gifPanel.setBorder(new TitledBorder(LanguageEncoder.getText("GIF/PNG Transparency")));
        gifPanel.setLayout(new BorderLayout());
        this.transparentGIF = new JCheckBox(LanguageEncoder.getText("Set Background Transparent"), this.isGIFTransparent);
        gifPanel.add("Center", this.transparentGIF);
        JPanel flashPanel = new JPanel();
        flashPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Flash Option")));
        flashPanel.setLayout(new BorderLayout());
        JPanel animatePanel = new JPanel();
        animatePanel.setLayout(new FlowLayout(0));
        this.animatedBut = new JCheckBox(LanguageEncoder.getText("Enable Animation"), this.flashFrameCount > 1);
        animatePanel.add(this.animatedBut);
        this.animatedBut.addItemListener(this);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(2, 2, 5, 5));
        mainPanel.add(new JLabel(LanguageEncoder.getText("Frame Count")));
        this.noOfFrame = new SpinBox(2, 50);
        mainPanel.add(this.noOfFrame);
        if (this.flashFrameCount != 1) {
            this.noOfFrame.setValue(this.flashFrameCount);
        } else {
            this.noOfFrame.setValue(12);
        }
        mainPanel.add(new JLabel(LanguageEncoder.getText("Frame Rate")));
        this.frameRate = new SpinBox(1, 99);
        mainPanel.add(this.frameRate);
        this.frameRate.setValue((int)this.flashFrameRate);
        flashPanel.add("North", animatePanel);
        flashPanel.add("Center", mainPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(2, 2, 0, 0));
        optionPanel.add(jpegPanel);
        optionPanel.add(gifPanel);
        optionPanel.add(flashPanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(imgPanel);
        contentPane.add(optionPanel);
        contentPane.add(mapPanel);
        contentPane.add(buttonPanel);
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.noOfFrame.setEnabled(this.animatedBut.isSelected());
        this.frameRate.setEnabled(this.animatedBut.isSelected());
    }

    int getImageType() {
        return this.imageType;
    }

    int getPdfImageType() {
        return this.pdfImageType;
    }

    int getJPEGQuality() {
        return this.jpegQuality;
    }

    int getPNGCompression() {
        return 0;
    }

    boolean isGIFTransparent() {
        return this.isGIFTransparent;
    }

    boolean isExportMapFile() {
        return this.isExportMapFile;
    }

    int getFlashFrameCount() {
        return this.animatedBut.isSelected() ? this.flashFrameCount : 1;
    }

    float getFlashFrameRate() {
        return this.flashFrameRate;
    }

    public int getPNGMap(int pngComp) {
        for (int i = 0; i < this.pngMap.length; ++i) {
            if (this.pngMap[i] != pngComp) continue;
            return i;
        }
        return 1;
    }

    public int getImageMap() {
        if (this.isGIF.isSelected()) {
            return 1;
        }
        if (this.isPNG.isSelected()) {
            return 10;
        }
        if (this.isFLASH.isSelected()) {
            return 15;
        }
        return 7;
    }

    public int getPdfImageMap() {
        if (this.exportPNG.isSelected()) {
            return 10;
        }
        return 14;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            this.isExportMapFile = this.generateMapFile.isSelected();
            this.imageType = this.getImageMap();
            this.pdfImageType = this.getPdfImageMap();
            this.isGIFTransparent = this.transparentGIF.isSelected();
            this.jpegQuality = this.jpegSlider.getValue();
            this.flashFrameCount = this.noOfFrame.getValue();
            this.flashFrameRate = this.frameRate.getValue();
            this.pngCompression = 0;
            this.setVisible(false);
            this.dispose();
        }
    }
}

