/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class InitParamDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(InitParamDialog.class.getName());
    Vector params;
    Vector tempParams;
    int index;
    ReportMain reportMain;
    protected JPanel mainPanel;
    protected JPanel btnPanel;
    protected JPanel subPanel3;
    protected JPanel UIPanel;
    JCheckBox mapDBcheckbox;
    JComboBox paramChoice;
    JComboBox columnChoice;
    JComboBox typeChoice;
    JComboBox defaultChoice;
    JButton prevParamButton;
    JButton nextParamButton;
    JButton cancelButton;
    JButton okButton;
    JTextField defaultText;
    JTextField promptText;
    String[] types = new String[]{"Number", "String", "Boolean", "Date", "Time", "TimeStamp"};
    boolean showingDefaultText;

    public InitParamDialog(ReportMain reportMain, JDialog parent, Vector params) {
        super(parent, LanguageEncoder.getText("Initialize parameters"), true);
        this.reportMain = reportMain;
        this.params = params;
        this.tempParams = new Vector();
        for (int i = 0; i < params.size(); ++i) {
            this.tempParams.addElement(Parameter.clone((Parameter)params.elementAt(i)));
        }
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(new TitledBorder(""));
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new FlowLayout(0));
        paramPanel.add(new JLabel(LanguageEncoder.getText("Parameter")));
        this.paramChoice = new JComboBox();
        paramPanel.add(this.paramChoice);
        for (int i = 0; i < this.params.size(); ++i) {
            this.paramChoice.addItem(((Parameter)this.params.elementAt(i)).getName());
        }
        this.paramChoice.addItemListener(this);
        this.index = 0;
        this.paramChoice.setSelectedIndex(this.index);
        JPanel attributePanel = new JPanel();
        attributePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Attributes")));
        attributePanel.setLayout(new GridLayout(2, 2));
        JPanel subPanel1 = new JPanel();
        this.mapDBcheckbox = new JCheckBox(LanguageEncoder.getText("Map to report column"));
        subPanel1.add(this.mapDBcheckbox);
        this.mapDBcheckbox.setEnabled(true);
        this.mapDBcheckbox.setSelected(((Parameter)this.params.elementAt(this.index)).isMapToColumn());
        this.mapDBcheckbox.addItemListener(this);
        attributePanel.add(subPanel1);
        JPanel subPanel2 = new JPanel();
        this.columnChoice = new JComboBox();
        subPanel2.add(this.columnChoice);
        this.columnChoice.addItemListener(this);
        this.columnChoice.setEnabled(this.mapDBcheckbox.isSelected());
        attributePanel.add(subPanel2);
        this.subPanel3 = new JPanel();
        this.subPanel3.add(new JLabel(LanguageEncoder.getText("Default Value:")));
        this.defaultText = new JTextField(10);
        this.subPanel3.add(this.defaultText);
        this.defaultChoice = new JComboBox();
        attributePanel.add(this.subPanel3);
        this.showingDefaultText = true;
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        if (param.getDefaultValue() != null && !param.isMapToColumn()) {
            this.defaultText.setText(this.formatDefaultValue());
        }
        this.setupColumnChoice();
        JPanel subPanel4 = new JPanel();
        subPanel4.add(new JLabel(LanguageEncoder.getText("DataType:")));
        this.typeChoice = new JComboBox();
        subPanel4.add(this.typeChoice);
        attributePanel.add(subPanel4);
        this.setupTypeChoice();
        if (!param.isMapToColumn() && param.getDatatype(this.reportMain.report) >= 0) {
            this.typeChoice.setSelectedIndex(param.getDatatype(this.reportMain.report));
        }
        this.UIPanel = new JPanel();
        this.UIPanel.setBorder(new TitledBorder(LanguageEncoder.getText("User Interface")));
        this.UIPanel.setLayout(new FlowLayout(0));
        this.UIPanel.add(new JLabel(LanguageEncoder.getText("Prompting Text:")));
        String s = ((Parameter)this.params.elementAt(this.index)).getPromptText();
        this.promptText = new JTextField(s, 20);
        this.UIPanel.add(this.promptText);
        this.btnPanel = new JPanel(new FlowLayout(1));
        this.prevParamButton = new JButton(LanguageEncoder.getText("Previous Parameter"));
        this.prevParamButton.addActionListener(this);
        this.btnPanel.add(this.prevParamButton);
        this.nextParamButton = new JButton(LanguageEncoder.getText("Next Parameter"));
        this.nextParamButton.addActionListener(this);
        this.btnPanel.add(this.nextParamButton);
        this.setFlowButtons();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.btnPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.btnPanel.add(this.cancelButton);
        this.mainPanel.add((Component)paramPanel, "North");
        this.mainPanel.add((Component)attributePanel, "Center");
        this.mainPanel.add((Component)this.UIPanel, "South");
        panel.add((Component)this.mainPanel, "Center");
        panel.add((Component)this.btnPanel, "South");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.paramChoice && this.index != this.paramChoice.getSelectedIndex()) {
            this.index = this.paramChoice.getSelectedIndex();
            this.resetAttributePanel();
        } else if (source == this.mapDBcheckbox) {
            this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
            this.selectColumnChoice();
            this.setDefaultValueUI();
        } else if (source == this.columnChoice) {
            this.setTypeChoice();
            this.setDefaultValueUI();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.prevParamButton) {
            this.saveCurrentParam();
            --this.index;
            this.paramChoice.setSelectedIndex(this.index);
            this.resetAttributePanel();
        } else if (source == this.nextParamButton) {
            this.saveCurrentParam();
            ++this.index;
            this.paramChoice.setSelectedIndex(this.index);
            this.resetAttributePanel();
        } else if (source == this.okButton) {
            this.saveCurrentParam();
            for (int i = 0; i < this.params.size(); ++i) {
                ((Parameter)this.params.elementAt(i)).copy((Parameter)this.tempParams.elementAt(i));
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setupColumnChoice() {
        this.columnChoice.addItem(LanguageEncoder.getText("Not Applicable"));
        ColData[] colData = this.reportMain.report.colData;
        for (int i = 0; i < colData.length - 1; ++i) {
            if (colData[i].getTableName() == null || colData[i].getTableName().equals("")) {
                this.columnChoice.addItem(colData[i].getName());
                continue;
            }
            this.columnChoice.addItem(colData[i].getTableName() + "." + colData[i].getName());
        }
        this.selectColumnChoice();
    }

    private void selectColumnChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.columnChoice.setEnabled(mapState);
        if (!mapState) {
            this.columnChoice.setSelectedIndex(0);
            return;
        }
        this.columnChoice.setSelectedIndex(((Parameter)this.tempParams.elementAt(this.index)).getMapColIdx() + 1);
        this.setTypeChoice();
    }

    private void setupTypeChoice() {
        for (String type : this.types) {
            this.typeChoice.addItem(type);
        }
        this.setTypeChoice();
    }

    private void setTypeChoice() {
        int idx;
        if (this.typeChoice == null) {
            return;
        }
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.typeChoice.setEnabled(!mapState);
        if (mapState && (idx = this.columnChoice.getSelectedIndex()) > 0) {
            for (int i = 0; i < this.types.length; ++i) {
                int sqlType = this.reportMain.report.colData[idx - 1].getOriginalDataType();
                if (!this.types[Operand.mapToOperandType(sqlType)].equals(this.types[i])) continue;
                this.typeChoice.setSelectedIndex(i);
                return;
            }
        }
        this.typeChoice.setSelectedIndex(1);
    }

    private void setDefaultChoice() {
        if (this.defaultChoice == null) {
            return;
        }
        int idx = this.columnChoice.getSelectedIndex();
        if (idx > 0) {
            ColData colData = this.reportMain.report.colData[idx - 1];
            this.defaultChoice.removeAllItems();
            for (int i = 0; i < colData.getSize(); ++i) {
                boolean duplicate = false;
                for (int j = 0; j < this.defaultChoice.getItemCount(); ++j) {
                    if (!colData.getData(i).equals(this.defaultChoice.getItemAt(j))) continue;
                    duplicate = true;
                }
                if (duplicate) continue;
                this.defaultChoice.addItem(colData.getData(i));
            }
        }
    }

    private void setDefaultValueUI() {
        if (this.mapDBcheckbox.isSelected() && this.showingDefaultText) {
            this.resetDefaultChoice();
        } else if (!this.mapDBcheckbox.isSelected() && !this.showingDefaultText) {
            this.removeDefaultChoice();
        } else if (!this.showingDefaultText) {
            this.resetDefaultChoice();
        }
    }

    private void removeDefaultChoice() {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        this.showingDefaultText = true;
        this.subPanel3.remove(this.defaultChoice);
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        if (param.getDefaultValue() != null && !param.isMapToColumn()) {
            String defaultString = param.getDefaultValue().toString();
            this.defaultText.setText(defaultString);
            this.typeChoice.setSelectedIndex(param.getDatatype(this.reportMain.report));
        }
        this.subPanel3.add(this.defaultText);
        this.subPanel3.repaint();
        this.pack();
        this.validate();
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private void resetDefaultChoice() {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        if (this.showingDefaultText) {
            this.subPanel3.remove(this.defaultText);
            this.showingDefaultText = false;
        } else {
            this.subPanel3.remove(this.defaultChoice);
        }
        this.defaultChoice.removeItemListener(this);
        this.defaultChoice = new JComboBox();
        this.setDefaultChoice();
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        Object defaultValue = param.getDefaultValue();
        if (defaultValue != null && param.isMapToColumn() && this.typeChoice != null && param.getDatatype(this.reportMain.report) == this.typeChoice.getSelectedIndex()) {
            block4: for (int i = 0; i < this.defaultChoice.getItemCount(); ++i) {
                switch (param.getDatatype(this.reportMain.report)) {
                    case 0: {
                        double d = Double.valueOf(this.defaultChoice.getItemAt(i).toString());
                        if (d == Double.valueOf(defaultValue.toString())) {
                            this.defaultChoice.setSelectedIndex(i);
                            continue block4;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!this.defaultChoice.getItemAt(i).equals(defaultValue)) continue block4;
                        this.defaultChoice.setSelectedIndex(i);
                    }
                }
            }
        }
        this.subPanel3.add(this.defaultChoice);
        this.subPanel3.repaint();
        this.pack();
        this.validate();
        this.mapDBcheckbox.setEnabled(saveState);
    }

    private void resetAttributePanel() {
        this.setFlowButtons();
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        this.promptText.setText(param.getPromptText());
        boolean state = param.isMapToColumn();
        this.mapDBcheckbox.setSelected(state);
        if (state) {
            this.selectColumnChoice();
        } else {
            this.columnChoice.setSelectedIndex(0);
        }
        Object defaultValue = param.getDefaultValue();
        this.defaultText.setText(defaultValue == null ? "" : this.formatDefaultValue());
    }

    private void setFlowButtons() {
        int nParameter = this.paramChoice.getItemCount();
        int idx = this.paramChoice.getSelectedIndex();
        this.prevParamButton.setEnabled(idx > 0);
        this.nextParamButton.setEnabled(idx < nParameter - 1);
    }

    private void saveCurrentParam() {
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        param.setMapToColumn(this.mapDBcheckbox.isSelected());
        if (this.mapDBcheckbox.isSelected()) {
            if (this.columnChoice.getSelectedIndex() > 0) {
                param.setMapColIdx(this.columnChoice.getSelectedIndex() - 1);
                param.setDefaultValue(this.defaultChoice.getSelectedItem());
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select the column to map to"));
            }
        } else {
            param.setDefaultValue(this.makeDefaultValueFromText());
        }
        param.setDatatype(this.typeChoice.getSelectedIndex());
        param.setPromptText(this.promptText.getText());
    }

    private Object makeDefaultValueFromText() {
        String text = this.defaultText.getText();
        text = text.trim();
        int dataType = this.typeChoice.getSelectedIndex();
        if (text.equals("") && dataType != 1) {
            return null;
        }
        try {
            switch (dataType) {
                case 0: {
                    return Double.valueOf(text);
                }
                case 1: {
                    return text;
                }
                case 2: {
                    return Boolean.valueOf(text);
                }
                case 3: {
                    return FormatUtil.createDate(text);
                }
                case 4: {
                    return FormatUtil.createTime(text);
                }
                case 5: {
                    return FormatUtil.createTimestamp(text);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Cannot determine data type", e);
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), e.getMessage());
            return null;
        }
    }

    private String formatDefaultValue() {
        Parameter param = (Parameter)this.tempParams.elementAt(this.index);
        Report report = this.reportMain.report;
        switch (param.getDatatype(this.reportMain.report)) {
            case 0: 
            case 1: 
            case 2: {
                return param.getDefaultValue().toString();
            }
            case 3: {
                return FormatUtil.getDateTimeText(report.getLocale(), report.getTimeZone(), "MM'/'dd'/'yyyy", (Date)param.getDefaultValue());
            }
            case 4: {
                return FormatUtil.getDateTimeText(report.getLocale(), report.getTimeZone(), "hh:mm:ss", (Date)param.getDefaultValue());
            }
            case 5: {
                return FormatUtil.getDateTimeText(report.getLocale(), report.getTimeZone(), "MM'/'dd'/'yyyy hh:mm:ss", (Date)param.getDefaultValue());
            }
        }
        return null;
    }
}

