/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class InsertChartDialog
extends JDialog
implements ActionListener,
ItemListener,
WindowListener {
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    boolean isCancelled = false;
    JRadioButton summaryDataBut;
    JRadioButton reportDataBut;
    JRadioButton otherDataBut;
    JRadioButton importChartBut;
    JCheckBox sectionDataBox;
    boolean useReportData;
    boolean useSectionData;
    boolean useSummaryData;
    boolean useImportChart;
    boolean disableChartDataSource;
    boolean disableSummaryData;

    public InsertChartDialog(ReportMain reportMain, boolean disableChartDataSource, boolean disableSummaryData) {
        super(reportMain, LanguageEncoder.getText("Insert Chart ..."), true);
        this.reportMain = reportMain;
        this.disableChartDataSource = disableChartDataSource;
        this.disableSummaryData = disableSummaryData;
        this.init();
        this.setPosition();
        this.addWindowListener(this);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(LanguageEncoder.getText("Setup Data...")));
        panel.setLayout(new GridLayout(-1, 2));
        this.reportDataBut = new JRadioButton(LanguageEncoder.getText("Report Data"), true);
        this.sectionDataBox = new JCheckBox(LanguageEncoder.getText("Include Section Data"), false);
        this.otherDataBut = new JRadioButton(LanguageEncoder.getText("Other Data Source"), false);
        this.summaryDataBut = new JRadioButton(LanguageEncoder.getText("Summary Data"), false);
        this.importChartBut = new JRadioButton(LanguageEncoder.getText("Import Chart"), false);
        if (this.disableChartDataSource) {
            this.otherDataBut.setEnabled(false);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.reportDataBut);
        bg.add(this.otherDataBut);
        bg.add(this.importChartBut);
        panel.add(this.reportDataBut);
        panel.add(this.sectionDataBox);
        if (!this.disableSummaryData) {
            panel.add(this.summaryDataBut);
            bg.add(this.summaryDataBut);
            panel.add(new JLabel(""));
        }
        panel.add(this.otherDataBut);
        panel.add(new JLabel(""));
        panel.add(this.importChartBut);
        panel.add(new JLabel(""));
        this.reportDataBut.addItemListener(this);
        this.otherDataBut.addItemListener(this);
        this.importChartBut.addItemListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        contentPane.add("South", p2);
        this.pack();
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.sectionDataBox.setEnabled(this.reportDataBut.isSelected());
    }

    boolean useReportData() {
        return this.useReportData;
    }

    boolean useSectionData() {
        return this.useSectionData;
    }

    boolean useSummaryData() {
        return this.useSummaryData;
    }

    boolean importChart() {
        return this.useImportChart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.useReportData = this.reportDataBut.isSelected();
            this.useSectionData = this.sectionDataBox.isSelected();
            this.useSummaryData = this.summaryDataBut.isSelected();
            this.useImportChart = this.importChartBut.isSelected();
        } else if (e.getSource() == this.cancelButton) {
            this.isCancelled = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isCancelled = true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

